/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot.neoforge;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.SpoutCastingBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;

public class CastingDepotRendererImpl {
    public static void renderFluid(CastingDepotBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        SpoutCastingBehaviour spoutBehaviour = (SpoutCastingBehaviour)be.getBehaviour(SpoutCastingBehaviour.TYPE);
        if (spoutBehaviour.getState() == SpoutCastingBehaviour.State.NONE) {
            return;
        }
        int processingDuration = spoutBehaviour.getRecipeProcessingDuration();
        FluidStack fluidStack = new FluidStack(be.getVisualFluid(), 1);
        int processingTicks = spoutBehaviour.getProcessingTicks() - 1;
        float processingPT = (float)processingTicks + partialTicks;
        float level = 1.0f;
        if (spoutBehaviour.getState() == SpoutCastingBehaviour.State.FILLING) {
            level = Mth.clamp((float)((processingPT - 5.0f) / (float)(processingDuration - 5)), (float)0.0f, (float)1.0f);
        }
        if (!fluidStack.isEmpty() && level != 0.0f) {
            float xMin = 0.0625f;
            float xMax = 0.9375f;
            float yMin = 0.6875f;
            float yMax = 0.6875f + 0.04375f * level;
            float zMin = 0.0625f;
            float zMax = 0.9375f;
            ms.pushPose();
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, 0.6875f, 0.0625f, xMax, yMax, 0.9375f, buffer, ms, light, false, false);
            ms.popPose();
        }
    }
}

