/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot.neoforge;

import com.dudko.blazinghot.content.casting.casting_depot.CastingBySpout;
import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBehaviour;
import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.SpoutCastingBehaviour;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBehaviourImpl;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBlockEntityImpl;
import com.dudko.blazinghot.content.casting.casting_depot.recipe.CastingRecipe;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.foundation.mixin.accessor.SpoutBlockEntityAccessor;
import com.dudko.blazinghot.foundation.multiloader.fluid.neoforge.MultiFluidStackNeoForge;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpoutCastingBehaviourImpl
extends SpoutCastingBehaviour {
    public SpoutCastingBehaviourImpl(CastingDepotBlockEntity depot) {
        super(depot);
    }

    public static SpoutCastingBehaviour of(CastingDepotBlockEntity depot) {
        return new SpoutCastingBehaviourImpl(depot);
    }

    @Override
    public int getRecipeCoolingDuration() {
        return this.getCurrentRecipe() == null ? -1 : ((CastingRecipe)this.getCurrentRecipe().value()).getCoolingDuration();
    }

    @Override
    public int getRecipeProcessingDuration() {
        return this.getCurrentRecipe() == null ? -1 : ((CastingRecipe)this.getCurrentRecipe().value()).getProcessingDuration();
    }

    private FluidStack getFluid() {
        SpoutBlockEntity spout = this.getSpout();
        if (spout == null) {
            return FluidStack.EMPTY;
        }
        return ((SpoutBlockEntityAccessor)spout).getTank().getPrimaryHandler().getFluid();
    }

    public void tick() {
        super.tick();
        SpoutBlockEntity spout = this.getSpout();
        if (spout == null) {
            if (this.state == SpoutCastingBehaviour.State.FILLING) {
                this.resetProcessing();
                return;
            }
            if (this.state == SpoutCastingBehaviour.State.NONE) {
                return;
            }
        }
        Level level = this.getWorld();
        CastingDepotBlockEntityImpl depot = (CastingDepotBlockEntityImpl)this.blockEntity;
        ItemStack stack = depot.getHeldItem();
        if (stack.isEmpty()) {
            this.resetProcessing();
            return;
        }
        FluidStack availableFluid = this.getFluid();
        if (availableFluid.isEmpty() && this.state != SpoutCastingBehaviour.State.COOLING) {
            return;
        }
        int requiredAmount = CastingBySpout.getRequiredAmountForItem(level, stack, MultiFluidStackNeoForge.fromNeoForgeStack(availableFluid));
        RecipeHolder<CastingRecipe> currentRecipe = this.getCurrentRecipe();
        if (this.state == SpoutCastingBehaviour.State.NONE) {
            if (!this.canSpout()) {
                return;
            }
            if (!depot.getOutputItem().isEmpty()) {
                return;
            }
            if (!CastingBySpout.canItemBeCast(level, stack) || availableFluid.getAmount() < requiredAmount) {
                return;
            }
            currentRecipe = CastingBySpout.findRecipe(depot, level, requiredAmount, stack, MultiFluidStackNeoForge.fromNeoForgeStack(availableFluid));
            if (currentRecipe == null) {
                return;
            }
            this.currentRecipeId = currentRecipe.id();
            this.visualFluid = availableFluid.getFluid();
            this.state = SpoutCastingBehaviour.State.FILLING;
            depot.notifyUpdate();
        } else if (this.state == SpoutCastingBehaviour.State.FILLING) {
            if (currentRecipe == null || spout == null || !this.canSpout()) {
                this.resetProcessing();
                return;
            }
            if (this.processingTicks == 0) {
                AllSoundEvents.SPOUTING.playOnServer(level, (Vec3i)this.getPos(), 0.75f, 0.9f + 0.2f * (float)Math.random());
            }
            ++this.processingTicks;
            int duration = ((CastingRecipe)currentRecipe.value()).getProcessingDuration();
            if (this.visualFluid == Fluids.EMPTY) {
                this.visualFluid = availableFluid.getFluid();
            }
            if (level.isClientSide) {
                if (this.processingTicks >= 4 && duration - this.processingTicks > 8) {
                    depot.spawnProcessingParticles(availableFluid);
                }
                if (this.processingTicks >= 5 && this.processingTicks % 4 == 0) {
                    depot.spawnSplash(availableFluid);
                }
            }
            if (this.processingTicks >= duration) {
                SmartFluidTank spoutTank = ((SpoutBlockEntityAccessor)spout).getTank().getPrimaryHandler();
                this.state = SpoutCastingBehaviour.State.COOLING;
                this.processingTicks = -1;
                spoutTank.drain(requiredAmount, IFluidHandler.FluidAction.EXECUTE);
                depot.setFluid(spoutTank.getFluid().getFluid(), requiredAmount);
                this.castItem = CastingBySpout.getCastingResult((CastingRecipe)currentRecipe.value(), level);
                this.coolingDuration = ((CastingRecipe)currentRecipe.value()).getCoolingDuration();
                this.keepMold = ((CastingRecipe)currentRecipe.value()).isKeepItem();
            }
        } else if (this.state == SpoutCastingBehaviour.State.COOLING) {
            if (level.isClientSide && (int)this.coolingTicks % 3 == 0) {
                depot.spawnCoolingParticles();
            }
            float coolingSpeed = depot.getCoolingSpeed();
            this.coolingTicks = Math.max(this.coolingTicks + coolingSpeed, 0.0f);
            if (this.coolingTicks >= (float)this.coolingDuration) {
                if (!this.keepMold) {
                    stack.shrink(1);
                }
                CastingDepotBehaviourImpl depotBehaviour = (CastingDepotBehaviourImpl)depot.getBehaviour(CastingDepotBehaviour.TYPE);
                if (this.castItem.is(BlazingTags.Items.STURDY_MOLDS.tag())) {
                    depot.award(BlazingAdvancements.STURDY_MOLD);
                }
                depot.award(BlazingAdvancements.CASTING);
                if (this.castItem.is(BlazingTags.Items.MOLDS.tag())) {
                    depotBehaviour.setHeldStack(this.castItem);
                } else {
                    depotBehaviour.processingOutputBuffer.insertItem(0, this.castItem, false);
                }
                depot.resetFluid();
                this.resetProcessing();
                if (level.isClientSide) {
                    level.playLocalSound(this.getPos(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.6f, 2.0f, false);
                }
            }
        }
    }

    @Override
    public void resetProcessing() {
        this.state = SpoutCastingBehaviour.State.NONE;
        this.processingTicks = -1;
        this.coolingTicks = -1.0f;
        this.coolingDuration = -1;
        this.keepMold = false;
        this.currentRecipeId = null;
        this.castItem = ItemStack.EMPTY;
        ((CastingDepotBlockEntity)this.blockEntity).setVisualFluid(Fluids.EMPTY);
    }

    @Nullable
    public RecipeHolder<CastingRecipe> getCurrentRecipe() {
        Level level = this.getWorld();
        if (level == null) {
            return null;
        }
        return CastingBySpout.findRecipe((CastingDepotBlockEntity)this.blockEntity, level, this.currentRecipeId);
    }
}

