/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot.recipe;

import com.dudko.blazinghot.content.casting.casting_depot.recipe.CastingRecipeParams;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CastingRecipe
extends ProcessingRecipe<SingleRecipeInput, CastingRecipeParams> {
    public static final int SAFE_RENDERING_LIMIT = 10;

    public CastingRecipe(CastingRecipeParams params) {
        super((IRecipeTypeInfo)BlazingRecipeTypes.CASTING, (ProcessingRecipeParams)params);
    }

    public boolean isKeepItem() {
        return ((CastingRecipeParams)this.params).keepMold;
    }

    public int getCoolingDuration() {
        return ((CastingRecipeParams)this.params).coolingDuration;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return ((Ingredient)this.ingredients.getFirst()).test(input.getItem(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public List<String> validate() {
        List errors = super.validate();
        if (this.fluidIngredients.isEmpty()) {
            errors.add("Recipe has no fluid ingredient!");
        }
        return errors;
    }

    public SizedFluidIngredient getRequiredFluid() {
        return (SizedFluidIngredient)this.fluidIngredients.getFirst();
    }

    public static class Serializer
    implements RecipeSerializer<CastingRecipe> {
        private final ProcessingRecipe.Factory<CastingRecipeParams, CastingRecipe> factory;
        private final MapCodec<CastingRecipe> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, CastingRecipe> streamCodec;

        public Serializer(ProcessingRecipe.Factory<CastingRecipeParams, CastingRecipe> factory) {
            this.factory = factory;
            this.codec = ProcessingRecipe.codec(factory, CastingRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, CastingRecipeParams.STREAM_CODEC);
        }

        public MapCodec<CastingRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CastingRecipe> streamCodec() {
            return this.streamCodec;
        }

        public ProcessingRecipe.Factory<CastingRecipeParams, CastingRecipe> factory() {
            return this.factory;
        }
    }
}

