/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.entity;

import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.util.WorldUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlazeArrowEntity
extends AbstractArrow {
    @Nullable
    private ResourceKey<Level> dimensionOrigin;

    public BlazeArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.dimensionOrigin = level.dimension();
    }

    public BlazeArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(entityType, owner, level, pickupItemStack, firedFromWeapon);
        this.dimensionOrigin = level.dimension();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)BlazingItems.BLAZE_ARROW.asItem());
    }

    public void tick() {
        if (this.level().isClientSide && !this.inGround && this.level().dimension() == Level.NETHER) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        if (this.level().dimension().equals(Level.NETHER)) {
            this.setBaseDamage(this.getBaseDamage() * 1.5);
        }
        super.onHitEntity(result);
        if (this.getOwner() != null && (entity = this.getOwner()) instanceof Player) {
            LivingEntity entity2;
            Player player = (Player)entity;
            entity = result.getEntity();
            if (entity instanceof LivingEntity && (entity2 = (LivingEntity)entity).level().dimension().equals(Level.NETHER)) {
                BlazingAdvancements.BLAZE_ARROW.awardTo(player);
                if (this.dimensionOrigin != null && this.dimensionOrigin.equals((Object)Level.OVERWORLD) && (entity2.getHealth() <= 0.0f || !entity2.isAlive())) {
                    BlazingAdvancements.BLAZE_ARROW_INTERDIMENSIONAL.awardTo(player);
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DimensionOrigin", WorldUtil.dimensionToString(this.dimensionOrigin));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.dimensionOrigin = WorldUtil.dimensionFromString(compound.getString("DimensionOrigin"));
    }
}

