/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.fluid.neoforge;

import com.dudko.blazinghot.registry.neoforge.BlazingFluidsImpl;
import com.simibubi.create.AllFluids;
import com.simibubi.create.api.event.PipeCollisionEvent;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

@EventBusSubscriber
public class FluidReactionsImpl {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePipeFlowCollisionFallback(PipeCollisionEvent.Flow event) {
        Fluid f1 = event.getFirstFluid();
        Fluid f2 = event.getSecondFluid();
        BaseFlowingFluid netherLava = BlazingFluidsImpl.NETHER_LAVA.getSource();
        if (f1 == Fluids.WATER && f2 == netherLava || f2 == Fluids.WATER && f1 == netherLava) {
            event.setState(Blocks.COBBLESTONE.defaultBlockState());
        } else if (f1 == netherLava && FluidHelper.hasBlockState((Fluid)f2)) {
            BlockState lavaInteraction = AllFluids.getLavaInteraction((FluidState)FluidHelper.convertToFlowing((Fluid)f2).defaultFluidState());
            if (lavaInteraction != null) {
                event.setState(lavaInteraction);
            }
        } else if (f2 == netherLava && FluidHelper.hasBlockState((Fluid)f1)) {
            BlockState lavaInteraction = AllFluids.getLavaInteraction((FluidState)FluidHelper.convertToFlowing((Fluid)f1).defaultFluidState());
            if (lavaInteraction != null) {
                event.setState(lavaInteraction);
            }
        } else if (BlazingFluidsImpl.MOLTEN_METALS.contains(f1) && f2 == Fluids.WATER) {
            FluidReactionsImpl.metalInteraction((PipeCollisionEvent)event, f1, f2);
        } else if (BlazingFluidsImpl.MOLTEN_METALS.contains(f2) && f1 == Fluids.WATER) {
            FluidReactionsImpl.metalInteraction((PipeCollisionEvent)event, f2, f1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePipeSpillCollisionFallback(PipeCollisionEvent.Spill event) {
        Fluid pf = event.getPipeFluid();
        Fluid wf = event.getWorldFluid();
        if (FluidHelper.isTag((Fluid)pf, (TagKey)FluidTags.WATER) && wf == BlazingFluidsImpl.NETHER_LAVA.getSource()) {
            event.setState(Blocks.OBSIDIAN.defaultBlockState());
        } else if (pf == Fluids.WATER && wf == BlazingFluidsImpl.NETHER_LAVA.getSource()) {
            event.setState(Blocks.COBBLESTONE.defaultBlockState());
        } else if (pf == BlazingFluidsImpl.NETHER_LAVA.getSource() && wf == Fluids.WATER) {
            event.setState(Blocks.STONE.defaultBlockState());
        } else if (pf == BlazingFluidsImpl.NETHER_LAVA.getSource() && wf == Fluids.FLOWING_WATER) {
            event.setState(Blocks.COBBLESTONE.defaultBlockState());
        }
        if (pf == BlazingFluidsImpl.NETHER_LAVA.getSource()) {
            FluidReactionsImpl.lavaInteraction((PipeCollisionEvent)event, wf);
        } else if (wf == BlazingFluidsImpl.NETHER_LAVA.getSource() && FluidHelper.hasBlockState((Fluid)pf)) {
            FluidReactionsImpl.lavaInteraction((PipeCollisionEvent)event, pf);
        } else if (BlazingFluidsImpl.MOLTEN_METALS.contains(pf) && FluidHelper.isTag((Fluid)wf, (TagKey)FluidTags.WATER)) {
            FluidReactionsImpl.metalInteraction((PipeCollisionEvent)event, pf, wf);
        } else if (BlazingFluidsImpl.MOLTEN_METALS.contains(wf) && FluidHelper.isTag((Fluid)pf, (TagKey)FluidTags.WATER)) {
            FluidReactionsImpl.metalInteraction((PipeCollisionEvent)event, wf, pf);
        }
    }

    private static void metalInteraction(PipeCollisionEvent event, Fluid metal, Fluid waterLike) {
        BlockState metalInteraction = BlazingFluidsImpl.getFluidInteraction(metal.defaultFluidState(), waterLike.defaultFluidState());
        if (metalInteraction != null) {
            event.setState(metalInteraction);
        } else {
            FluidReactionsImpl.lavaInteraction(event, waterLike);
        }
    }

    private static void lavaInteraction(PipeCollisionEvent event, Fluid fluid) {
        BlockState lavaInteraction = AllFluids.getLavaInteraction((FluidState)FluidHelper.convertToFlowing((Fluid)fluid).defaultFluidState());
        if (lavaInteraction != null) {
            event.setState(lavaInteraction);
        }
    }
}

