/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.item.food;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.content.item.food.BlazingFoodItem;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.data.lang.ItemDescriptions;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BlazingFood {
    public final String name;
    public final Item.Properties itemProperties;
    public final BiConsumer<Level, LivingEntity> onUse;
    public final boolean generateRecipe;
    public final List<NonNullConsumer<? super BlazingFoodItem>> onRegisterAfter;
    public final List<TagKey<Item>> tags;

    protected BlazingFood(Builder builder) {
        this.name = builder.name;
        this.itemProperties = builder.itemProperties;
        this.generateRecipe = builder.generateRecipe;
        this.onUse = builder.onUse;
        this.onRegisterAfter = builder.onRegisterAfter;
        this.tags = new ArrayList<TagKey<Item>>();
    }

    public static ItemEntry<BlazingFoodItem> create(String name, UnaryOperator<Builder> builder) {
        return ((Builder)builder.apply(new Builder(name))).register();
    }

    private ItemEntry<BlazingFoodItem> register() {
        ItemBuilder builder = BlazingHot.registrate().item(this.name, properties -> new BlazingFoodItem((Item.Properties)properties, this.onUse)).properties(properties -> this.itemProperties);
        for (NonNullConsumer<? super BlazingFoodItem> consumer : this.onRegisterAfter) {
            builder.onRegisterAfter(Registries.ITEM, consumer);
        }
        return builder.register();
    }

    public static class Builder {
        private final String name;
        private final FoodProperties.Builder foodProperties;
        private final Item.Properties itemProperties;
        private BiConsumer<Level, LivingEntity> onUse;
        private boolean generateRecipe;
        private final List<NonNullConsumer<? super BlazingFoodItem>> onRegisterAfter;
        private final List<TagKey<Item>> tags;

        private Builder(String name) {
            this.name = name;
            this.onUse = (level, entity) -> {};
            this.foodProperties = new FoodProperties.Builder();
            this.itemProperties = new Item.Properties();
            this.generateRecipe = true;
            this.onRegisterAfter = new ArrayList<NonNullConsumer<? super BlazingFoodItem>>();
            this.tags = new ArrayList<TagKey<Item>>();
        }

        public Builder onUse(BiConsumer<Level, LivingEntity> onUse) {
            this.onUse = onUse;
            return this;
        }

        public Builder food(UnaryOperator<FoodProperties.Builder> transform) {
            transform.apply(this.foodProperties);
            return this;
        }

        public Builder properties(UnaryOperator<Item.Properties> transform) {
            transform.apply(this.itemProperties);
            return this;
        }

        public Builder onRegisterAfter(NonNullConsumer<? super BlazingFoodItem> onRegisterAfter) {
            this.onRegisterAfter.add(onRegisterAfter);
            return this;
        }

        public Builder fireResistant() {
            return this.properties(Item.Properties::fireResistant);
        }

        public Builder foil() {
            return this.properties(properties -> properties.component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true));
        }

        public Builder rarity(Rarity rarity) {
            return this.properties(properties -> properties.rarity(rarity));
        }

        public Builder nutrition(int nutrition) {
            return this.food(foodProperties -> foodProperties.nutrition(nutrition));
        }

        public Builder saturation(float saturationModifier) {
            return this.food(foodProperties -> foodProperties.saturationModifier(saturationModifier));
        }

        public Builder alwaysEat() {
            return this.food(FoodProperties.Builder::alwaysEdible);
        }

        public Builder effect(Holder<MobEffect> effect, int duration, int amplifier, float probability) {
            return this.food(foodProperties -> foodProperties.effect(new MobEffectInstance(effect, duration, amplifier), probability));
        }

        public Builder effect(Holder<MobEffect> effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public Builder effect(Holder<MobEffect> effect, int duration) {
            return this.effect(effect, duration, 0);
        }

        public Builder extinguish() {
            this.onRegisterAfter((NonNullConsumer<? super BlazingFoodItem>)((NonNullConsumer)c -> ItemDescription.useKey((ItemLike)c, (String)ItemDescriptions.EXTINGUISHING_FOOD.getKey())));
            return this.onUse((level, entity) -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!level.isClientSide() && entity.getRemainingFireTicks() > 0 && entity.getHealth() < 4.0f) {
                        BlazingAdvancements.EXTINGUISHING_FOOD_SAVE.awardTo(player);
                    }
                }
                entity.extinguishFire();
            });
        }

        public Builder addOxygen(int oxygen) {
            this.onRegisterAfter((NonNullConsumer<? super BlazingFoodItem>)((NonNullConsumer)c -> ItemDescription.useKey((ItemLike)c, (String)ItemDescriptions.OXYGEN_FOOD.getKey())));
            return this.onUse((level, entity) -> entity.setAirSupply(Math.min(entity.getAirSupply() + oxygen, entity.getMaxAirSupply())));
        }

        public Builder removeSlowness(int maxAmplifier) {
            this.onRegisterAfter((NonNullConsumer<? super BlazingFoodItem>)((NonNullConsumer)c -> ItemDescription.useKey((ItemLike)c, (String)ItemDescriptions.slownessRemovedDescription(maxAmplifier).getKey())));
            return this.onUse((level, entity) -> {
                if (maxAmplifier >= 0 && entity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) && Objects.requireNonNull(entity.getEffect(MobEffects.MOVEMENT_SLOWDOWN)).getAmplifier() <= maxAmplifier) {
                    entity.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                }
            });
        }

        public Builder removeSlowness() {
            this.onRegisterAfter((NonNullConsumer<? super BlazingFoodItem>)((NonNullConsumer)c -> ItemDescription.useKey((ItemLike)c, (String)ItemDescriptions.slownessRemovedDescription(255).getKey())));
            return this.onUse((level, entity) -> {
                if (entity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                    entity.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                }
            });
        }

        @SafeVarargs
        public final Builder tags(TagKey<Item> ... tags) {
            this.tags.addAll(Arrays.asList(tags));
            return this;
        }

        public Builder transform(UnaryOperator<Builder> transform) {
            transform.apply(this);
            return this;
        }

        public BlazingFood build() {
            this.itemProperties.food(this.foodProperties.build());
            return new BlazingFood(this);
        }

        public ItemEntry<BlazingFoodItem> register() {
            return this.build().register();
        }
    }
}

