/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.item.food;

import com.dudko.blazinghot.registry.BlazingConfigs;
import com.dudko.blazinghot.util.TooltipUtil;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlazingFoodItem
extends Item {
    private boolean effectTooltip = true;
    private final BiConsumer<Level, LivingEntity> onUse;

    public BlazingFoodItem(Item.Properties properties, BiConsumer<Level, LivingEntity> onUse) {
        super(properties);
        this.onUse = onUse;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        this.onUse.accept(level, livingEntity);
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        FoodProperties foodProperties;
        if (this.effectTooltip && ((Boolean)BlazingConfigs.client().foodTooltips.get()).booleanValue() && (foodProperties = (FoodProperties)this.components().get(DataComponents.FOOD)) != null) {
            foodProperties.effects().stream().map(FoodProperties.PossibleEffect::effect).forEach(mobEffectInstance -> TooltipUtil.addEffectTooltip(tooltipComponents, context, mobEffectInstance));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

