/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.kinetics.blaze_mixer;

import com.dudko.blazinghot.content.kinetics.blaze_mixer.neoforge.BlazeMixerBlockEntityImpl;
import com.dudko.blazinghot.data.advancement.BlazingAdvancement;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.foundation.mixin_interfaces.IAdvancementBehaviour;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiFluids;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public abstract class BlazeMixerBlockEntity
extends BasinOperatingBlockEntity
implements IHaveGoggleInformation {
    protected static final Object shapelessOrMixingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public int dripTicks = 0;
    public boolean running;
    public boolean fueled;
    private int ancientDebrisMelted;
    public SmartFluidTankBehaviour tank;

    protected BlazeMixerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlazeMixerBlockEntity of(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        void var2_2;
        void var1_1;
        return BlazeMixerBlockEntityImpl.of(type, (BlockPos)var1_1, (BlockState)var2_2);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.MIXER});
        this.registerAwardables(behaviours, BlazingAdvancements.BLAZE_MIXER, BlazingAdvancements.MOLTEN_GOLD, BlazingAdvancements.MOLTEN_BLAZE_GOLD, BlazingAdvancements.BLAZE_MIXER_MAX, BlazingAdvancements.ANCIENT_DEBRIS_MELTING);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.cos((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.running) {
            if (this.runningTicks < 15) {
                return speed;
            }
            if (this.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.running = compound.getBoolean("Running");
        this.runningTicks = compound.getInt("Ticks");
        this.fueled = compound.getBoolean("Fueled");
        this.ancientDebrisMelted = compound.getInt("AncientDebrisMelted");
        super.read(compound, registries, clientPacket);
        if (clientPacket && this.hasLevel()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putInt("Ticks", this.runningTicks);
        compound.putBoolean("Fueled", this.fueled);
        compound.putInt("AncientDebrisMelted", this.ancientDebrisMelted);
        super.write(compound, registries, clientPacket);
    }

    public float recipeSpeedMultiplier(Recipe<?> recipe) {
        if (recipe == null) {
            return 1.0f;
        }
        if (recipe instanceof MixingRecipe) {
            for (ItemStack stack : this.getAvailableItems()) {
                List list;
                if (stack.isEmpty() || (list = (List)PotionMixingRecipes.sortRecipesByItem((Level)this.level).get(stack.getItem())) == null) continue;
                for (MixingRecipe mixingRecipe : list) {
                    if (!this.matchBasinRecipe((Recipe)mixingRecipe)) continue;
                    return BlazingConfigs.server().recipes.blazeBrewingSpeedMultiplier.getF();
                }
            }
        }
        if (recipe.getType() == AllRecipeTypes.MIXING.getType()) {
            return BlazingConfigs.server().recipes.blazeMixingSpeedMultiplier.getF();
        }
        if (recipe instanceof CraftingRecipe) {
            return BlazingConfigs.server().recipes.blazeShapelessSpeedMultiplier.getF();
        }
        return 1.0f;
    }

    public void updateAdvancements(Recipe<?> r) {
        this.award(BlazingAdvancements.BLAZE_MIXER);
        if (r instanceof StandardProcessingRecipe) {
            StandardProcessingRecipe recipe = (StandardProcessingRecipe)r;
            if (MultiFluids.recipeResultContains(recipe, BlazingMetals.ANCIENT_DEBRIS.getFluidTag()) && recipe.getIngredients().stream().anyMatch(i -> i.test(Items.ANCIENT_DEBRIS.getDefaultInstance()))) {
                ++this.ancientDebrisMelted;
                if (this.ancientDebrisMelted >= 15) {
                    this.award(BlazingAdvancements.ANCIENT_DEBRIS_MELTING);
                    this.ancientDebrisMelted = 0;
                }
            }
            if (MultiFluids.recipeResultContains(recipe, BlazingMetals.GOLD.getFluidTag())) {
                this.award(BlazingAdvancements.MOLTEN_GOLD);
            }
            if (MultiFluids.recipeResultContains(recipe, BlazingMetals.BLAZE_GOLD.getFluidTag())) {
                this.award(BlazingAdvancements.MOLTEN_BLAZE_GOLD);
            }
            if (Mth.abs((float)this.getSpeed()) >= (float)((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).intValue() && this.hasFuel(MultiAmount.BUCKET.get())) {
                this.award(BlazingAdvancements.BLAZE_MIXER_MAX);
            }
        }
    }

    public abstract long getFuelAmount();

    public abstract boolean hasFuel(long var1);

    public abstract boolean hasFuel(TagKey<Fluid> var1, long var2);

    public abstract boolean hasFuel(SizedFluidIngredient var1);

    public abstract void updateFueled();

    public abstract void renderFuelParticles();

    public abstract void renderParticles();

    public abstract List<ItemStack> getAvailableItems();

    protected void spillParticle(ParticleOptions data) {
        assert (this.level != null);
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).add(0.0, 0.25, 0.0);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly((Vec3)target.subtract(offset), (RandomSource)this.level.random, (float)0.0078125f);
        this.level.addParticle(data, center.x, center.y - 1.75, center.z, target.x, target.y, target.z);
    }

    public static boolean doInputsMatch(ProcessingRecipe<?, ?> a, ProcessingRecipe<?, ?> b) {
        return BlazeMixerBlockEntity.doItemInputsMatch(a, b) && BlazeMixerBlockEntity.doFluidInputsMatch(a, b);
    }

    public static boolean doItemInputsMatch(ProcessingRecipe<?, ?> a, ProcessingRecipe<?, ?> b) {
        if (a.getIngredients().isEmpty() && b.getIngredients().isEmpty()) {
            return true;
        }
        List<ItemStack[]> allItemsA = a.getIngredients().stream().map(Ingredient::getItems).toList();
        for (ItemStack[] matchingStacks : allItemsA) {
            boolean matched = false;
            if (matchingStacks.length == 0) {
                return matched;
            }
            matched = b.getIngredients().stream().anyMatch(i -> Arrays.stream(matchingStacks).allMatch((Predicate<ItemStack>)i));
            if (matched) continue;
            return false;
        }
        List<ItemStack[]> allItemsB = b.getIngredients().stream().map(Ingredient::getItems).toList();
        for (ItemStack[] matchingStacks : allItemsB) {
            boolean matched = false;
            if (matchingStacks.length == 0) {
                return matched;
            }
            matched = a.getIngredients().stream().anyMatch(i -> Arrays.stream(matchingStacks).allMatch((Predicate<ItemStack>)i));
            if (matched) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doFluidInputsMatch(ProcessingRecipe<?, ?> a, ProcessingRecipe<?, ?> b) {
        void var1_1;
        return BlazeMixerBlockEntityImpl.doFluidInputsMatch(a, var1_1);
    }

    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.MIXER);
    }

    public void registerAwardables(List<BlockEntityBehaviour> behaviours, BlazingAdvancement ... advancements) {
        ((IAdvancementBehaviour)((Object)this)).blazinghot$registerAwardables(behaviours, advancements);
    }

    public void award(BlazingAdvancement advancement) {
        ((IAdvancementBehaviour)((Object)this)).blazinghot$award(advancement);
    }

    public void awardPlayerIfNear(BlazingAdvancement advancement, int maxDistance) {
        ((IAdvancementBehaviour)((Object)this)).blazinghot$award(advancement);
    }
}

