/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.kinetics.blaze_mixer;

import com.dudko.blazinghot.content.kinetics.blaze_mixer.BlazeMixerBlockEntity;
import com.dudko.blazinghot.registry.BlazingPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlazeMixerRenderer
extends KineticBlockEntityRenderer<BlazeMixerBlockEntity> {
    public BlazeMixerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(BlazeMixerBlockEntity be) {
        return true;
    }

    protected void renderSafe(BlazeMixerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState blockState = be.getBlockState();
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)BlazingPartialModels.SHAFTLESS_CRIMSON_COGWHEEL, (BlockState)blockState);
        BlazeMixerRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, vb);
        float renderedHeadOffset = be.getRenderedHeadOffset(partialTicks);
        float speed = be.getRenderedHeadRotationSpeed(partialTicks);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float angle = time * speed * 6.0f / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer poleRender = CachedBuffers.partial((PartialModel)BlazingPartialModels.BLAZE_MIXER_POLE, (BlockState)blockState);
        ((SuperByteBuffer)poleRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, vb);
        VertexConsumer vbCutout = buffer.getBuffer(RenderType.cutoutMipped());
        SuperByteBuffer headRender = CachedBuffers.partial((PartialModel)BlazingPartialModels.BLAZE_MIXER_HEAD, (BlockState)blockState);
        ((SuperByteBuffer)((SuperByteBuffer)headRender.rotateCentered(angle, Direction.UP)).translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, vbCutout);
    }
}

