/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.kinetics.blaze_mixer.neoforge;

import com.dudko.blazinghot.content.kinetics.blaze_mixer.BlazeMixerBlockEntity;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.BlazeMixingRecipe;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.registry.BlazingBlockEntityTypes;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BlazeMixerBlockEntityImpl
extends BlazeMixerBlockEntity {
    public int fuelCost;

    protected BlazeMixerBlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlazingBlockEntityTypes.BLAZE_MIXER.get(), (be, context) -> {
            if (context != Direction.DOWN) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((int)MultiAmount.BUCKET.get()));
        this.tank.whenFluidUpdates(() -> {
            if (this.getBasin().isPresent()) {
                ((BasinBlockEntity)this.getBasin().get()).notifyChangeOfContents();
            }
        });
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    @NotNull
    public FluidStack getFluidStack() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @Override
    public void updateFueled() {
        FluidState fluidState = this.getFluidStack().getFluid().defaultFluidState();
        this.fueled = fluidState.is(BlazingTags.Fluids.BLAZE_MIXER_FUEL.tag()) && this.getFuelAmount() > 0L;
    }

    @Override
    public boolean hasFuel(long amount) {
        return this.hasFuel(BlazingTags.Fluids.BLAZE_MIXER_FUEL.tag(), amount);
    }

    @Override
    public boolean hasFuel(TagKey<Fluid> tag, long amount) {
        return amount <= 0L || this.hasFuel(SizedFluidIngredient.of(tag, (int)((int)amount)));
    }

    @Override
    public boolean hasFuel(SizedFluidIngredient fluidIngredient) {
        return fluidIngredient.ingredient().isEmpty() || fluidIngredient.test(this.getFluidStack());
    }

    @Override
    public long getFuelAmount() {
        return this.getFluidStack().getAmount();
    }

    public void tick() {
        super.tick();
        ++this.dripTicks;
        if (this.level != null && this.level.isClientSide && this.dripTicks >= 10) {
            this.dripTicks = 0;
            this.renderFuelParticles();
        }
        this.updateFueled();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.level != null) {
            if (this.level.isClientSide && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!this.level.isClientSide || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple tanks;
                    Recipe t2;
                    ProcessingRecipe processingRecipe;
                    int t2;
                    float recipeSpeed = 1.0f;
                    this.fuelCost = 0;
                    Recipe recipe = this.currentRecipe;
                    if (recipe instanceof ProcessingRecipe && (t2 = (processingRecipe = (ProcessingRecipe)recipe).getProcessingDuration()) != 0) {
                        recipeSpeed = (float)t2 / 100.0f;
                    }
                    if ((t2 = this.currentRecipe) instanceof BlazeMixingRecipe) {
                        BlazeMixingRecipe blazeMixingRecipe = (BlazeMixingRecipe)t2;
                        if (blazeMixingRecipe.getMixerFuel().test(this.getFluidStack())) {
                            this.fuelCost = blazeMixingRecipe.getMixerFuelAmount();
                        }
                    } else {
                        int calculatedCost = (int)BlazeMixingRecipe.getFuelCost(this.currentRecipe, this.level);
                        if (this.hasFuel(calculatedCost)) {
                            recipeSpeed = 1.0f / this.recipeSpeedMultiplier(this.currentRecipe);
                            this.fuelCost = calculatedCost;
                        }
                    }
                    this.processingTicks = Mth.clamp((int)(Mth.log2((int)((int)(512.0f / speed))) * Mth.ceil((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)8192);
                    Optional basin = this.getBasin();
                    if (!(!basin.isPresent() || ((SmartFluidTankBehaviour)(tanks = ((BasinBlockEntity)basin.get()).getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        this.level.playSound(null, this.worldPosition, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                    }
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        FluidStack updatedFuel;
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        if (this.currentRecipe != null) {
                            this.updateAdvancements(this.currentRecipe);
                        }
                        if ((updatedFuel = this.getFluidStack().copy()).getAmount() != 0) {
                            updatedFuel.shrink(Math.min(this.fuelCost, updatedFuel.getAmount()));
                        }
                        this.tank.getPrimaryHandler().setFluid(updatedFuel);
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    @Override
    public void renderFuelParticles() {
        double runningOffset;
        if (this.getFluidStack().isEmpty()) {
            return;
        }
        Vec3 offset = new Vec3(-0.3 + Math.random() * 0.55, -0.3 + Math.random() * 0.55, -0.3 + Math.random() * 0.55);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        double d = runningOffset = this.running && this.runningTicks != 0 ? 1.0 - 1.0 / (double)Math.min(this.runningTicks, 40) : 0.0;
        assert (this.level != null);
        this.level.addParticle(FluidFX.getDrippingParticle((FluidStack)this.getFluidStack()), center.x, center.y - 1.0 - runningOffset, center.z, 0.0, 0.0, 0.0);
        if (this.getFluidStack().getFluid().defaultFluidState().is(BlazingTags.Fluids.BLAZE_MIXER_FUEL.tag())) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, center.x, center.y - 1.0 - runningOffset, center.z, offset.x * 0.05, offset.y * 0.05, offset.z * 0.05);
        }
    }

    @Override
    public void renderParticles() {
        Optional basin = this.getBasin();
        if (basin.isEmpty() || this.level == null) {
            return;
        }
        for (SmartInventory inv : ((BasinBlockEntity)basin.get()).getInvs()) {
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getItem(slot);
                if (stackInSlot.isEmpty()) continue;
                ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, stackInSlot);
                this.spillParticle((ParticleOptions)data);
            }
        }
        for (SmartFluidTankBehaviour behaviour : ((BasinBlockEntity)basin.get()).getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle((FluidStack)tankSegment.getRenderedFluid()));
            }
        }
    }

    @Override
    public List<ItemStack> getAvailableItems() {
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        if (this.level == null) {
            return availableItems;
        }
        BasinBlockEntity basin = this.getBasin().orElse(null);
        if (basin == null) {
            return availableItems;
        }
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, basin.getBlockPos(), null);
        if (handler == null) {
            return availableItems;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            availableItems.add(handler.getStackInSlot(i));
        }
        return availableItems;
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List matchingRecipes = super.getMatchingRecipes();
        if (!((Boolean)BlazingConfigs.server().recipes.allowBrewingInBlazeMixer.get()).booleanValue()) {
            return matchingRecipes;
        }
        Optional basin = this.getBasin();
        if (basin.isEmpty()) {
            return matchingRecipes;
        }
        BasinBlockEntity basinBlockEntity = (BasinBlockEntity)basin.get();
        IItemHandler availableItems = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, basinBlockEntity.getBlockPos(), null);
        if (availableItems == null) {
            return matchingRecipes;
        }
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            List list;
            ItemStack stack = availableItems.getStackInSlot(i);
            if (stack.isEmpty() || (list = (List)PotionMixingRecipes.sortRecipesByItem((Level)this.level).get(stack.getItem())) == null) continue;
            for (MixingRecipe mixingRecipe : list) {
                if (!this.matchBasinRecipe((Recipe)mixingRecipe)) continue;
                matchingRecipes.add(mixingRecipe);
            }
        }
        return matchingRecipes;
    }

    protected <I extends RecipeInput> boolean matchBasinRecipe(Recipe<I> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional basin = this.getBasin();
        if (basin.isEmpty()) {
            return false;
        }
        if (recipe instanceof BlazeMixingRecipe) {
            BlazeMixingRecipe bmxRecipe = (BlazeMixingRecipe)recipe;
            return BasinRecipe.match((BasinBlockEntity)((BasinBlockEntity)basin.get()), (Recipe)bmxRecipe) && this.hasFuel(bmxRecipe.getMixerFuel());
        }
        return BasinRecipe.match((BasinBlockEntity)((BasinBlockEntity)basin.get()), recipe);
    }

    public static boolean doFluidInputsMatch(ProcessingRecipe<?, ?> a, ProcessingRecipe<?, ?> b) {
        if (a.getFluidIngredients().isEmpty() && b.getFluidIngredients().isEmpty()) {
            return true;
        }
        List<FluidStack[]> allFluidsA = a.getFluidIngredients().stream().map(SizedFluidIngredient::getFluids).toList();
        for (FluidStack[] matchingStacks : allFluidsA) {
            if (matchingStacks.length == 0) {
                return false;
            }
            boolean matched = b.getFluidIngredients().stream().anyMatch(i -> Arrays.stream(matchingStacks).allMatch(arg_0 -> ((SizedFluidIngredient)i).test(arg_0)));
            if (matched) continue;
            return false;
        }
        List<FluidStack[]> allFluidsB = b.getFluidIngredients().stream().map(SizedFluidIngredient::getFluids).toList();
        for (FluidStack[] matchingStacks : allFluidsB) {
            if (matchingStacks.length == 0) {
                return false;
            }
            boolean matched = a.getFluidIngredients().stream().anyMatch(i -> Arrays.stream(matchingStacks).allMatch(arg_0 -> ((SizedFluidIngredient)i).test(arg_0)));
            if (matched) continue;
            return false;
        }
        return true;
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> holder) {
        Recipe recipe = holder.value();
        return recipe instanceof CraftingRecipe && !(recipe instanceof ShapedRecipe) && (Boolean)BlazingConfigs.server().recipes.allowShapelessInBlazeMixer.get() != false && recipe.getIngredients().size() > 1 && !MechanicalPressBlockEntity.canCompress((Recipe)recipe) && !AllRecipeTypes.shouldIgnoreInAutomation(holder) || recipe.getType() == AllRecipeTypes.MIXING.getType() && (Boolean)BlazingConfigs.server().recipes.allowMixingInBlazeMixer.get() != false && BlazingRecipeTypes.shouldAllowBlazeMixing(holder) || recipe.getType() == BlazingRecipeTypes.BLAZE_MIXING.getType();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean kinetics;
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        boolean bl = kinetics = !tooltip.isEmpty();
        if (kinetics) {
            tooltip.add((Component)Component.empty());
        }
        boolean fluids = this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, null));
        return kinetics || fluids;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            AllSoundEvents.MIXING.playAt(this.level, (Vec3i)this.worldPosition, 0.75f, 1.0f, true);
        }
    }

    public static BlazeMixerBlockEntity of(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new BlazeMixerBlockEntityImpl(type, pos, state);
    }
}

