/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe;

import com.dudko.blazinghot.content.kinetics.blaze_mixer.BlazeMixerBlockEntity;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.BlazeMixingRecipeParams;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.neoforge.BlazeMixingRecipeImpl;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiFluidIngredient;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.potion.PotionMixingRecipes;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlazeMixingRecipe
extends BasinRecipe {
    public BlazeMixingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)BlazingRecipeTypes.BLAZE_MIXING, params);
    }

    public List<String> validate() {
        List errors = super.validate();
        if (super.getFluidIngredients().isEmpty()) {
            errors.add("Recipe doesn't have any mixer fuel.");
        }
        return errors;
    }

    public NonNullList<SizedFluidIngredient> getFluidIngredients() {
        NonNullList fluidIngredients = NonNullList.create();
        fluidIngredients.addAll((Collection)super.getFluidIngredients());
        fluidIngredients.removeLast();
        return fluidIngredients;
    }

    public static SizedFluidIngredient emptyMixerFuel() {
        return MultiFluidIngredient.fromTag(BlazingTags.Fluids.BLAZE_MIXER_PLACEHOLDER.tag(), MultiAmount.fromBucketFraction(1L, 10L));
    }

    public SizedFluidIngredient getMixerFuel() {
        SizedFluidIngredient fuel = (SizedFluidIngredient)super.getFluidIngredients().getLast();
        if (BlazeMixingRecipe.isPlaceholder(fuel)) {
            return MultiFluidIngredient.empty();
        }
        return fuel;
    }

    public int getMixerFuelAmount() {
        SizedFluidIngredient fuel = this.getMixerFuel();
        if (fuel.ingredient().isEmpty()) {
            return 0;
        }
        return fuel.amount();
    }

    protected int getMaxFluidInputCount() {
        return super.getMaxFluidInputCount() + 1;
    }

    public static long getFuelCost(Recipe<?> recipe, Level level) {
        if (recipe instanceof MixingRecipe) {
            MixingRecipe mixingRecipe = (MixingRecipe)recipe;
            for (Ingredient ingredient : mixingRecipe.getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    List list;
                    if (stack.isEmpty() || (list = (List)PotionMixingRecipes.sortRecipesByItem((Level)level).get(stack.getItem())) == null) continue;
                    for (MixingRecipe potionRecipe : list) {
                        if (!BlazeMixerBlockEntity.doInputsMatch(potionRecipe, mixingRecipe)) continue;
                        return ((Integer)BlazingConfigs.server().recipes.blazeBrewingFuelUsage.get()).intValue();
                    }
                }
            }
        }
        if (recipe.getType() == AllRecipeTypes.MIXING.getType()) {
            return BlazeMixingRecipe.durationToFuelCost(((ProcessingRecipe)recipe).getProcessingDuration());
        }
        if (recipe instanceof CraftingRecipe) {
            return ((Integer)BlazingConfigs.server().recipes.blazeShapelessFuelUsage.get()).intValue();
        }
        return 0L;
    }

    public static long durationToFuelCost(int duration) {
        float recipeSpeed = 1.0f;
        if (duration != 0) {
            recipeSpeed = (float)duration / 100.0f;
        }
        return Mth.ceil((float)(recipeSpeed * (float)((Integer)BlazingConfigs.server().recipes.blazeMixingFuelUsage.get()).intValue()));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isMeltingRecipe(Recipe<?> recipe) {
        return BlazeMixingRecipeImpl.isMeltingRecipe(recipe);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isPlaceholder(SizedFluidIngredient fluidIngredient) {
        return BlazeMixingRecipeImpl.isPlaceholder(fluidIngredient);
    }

    @FunctionalInterface
    public static interface Factory {
        public BlazeMixingRecipe create(BlazeMixingRecipeParams var1);
    }
}

