/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.metal;

import com.dudko.blazinghot.compat.Mods;
import com.dudko.blazinghot.content.casting.Molds;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.data.conditions.DefaultLoadConditions;
import com.dudko.blazinghot.data.conditions.LoadCondition;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.registry.BlazingTags;
import com.dudko.blazinghot.util.NullableSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class BlazingForm {
    public final String name;
    public final String tagFolder;
    public final List<Mods> mods;
    protected final NullableSupplier<ResourceLocation> customLocation;
    @Nullable
    public final Molds.Mold mold;
    public final MultiAmount amount;
    public final int meltingTime;
    public final int castingTime;
    public final int coolingTime;
    public final MultiAmount fuelCost;
    public final boolean mechanicalMixerMeltable;
    public final boolean optional;
    public final List<Flag> flags;

    private BlazingForm(Builder builder) {
        this.name = builder.name;
        this.tagFolder = builder.tagFolder;
        this.mods = List.copyOf(builder.mods);
        this.customLocation = builder.customLocation;
        this.mold = builder.mold;
        assert (builder.amount != null);
        this.amount = builder.amount;
        this.meltingTime = builder.meltingTime;
        this.castingTime = builder.castingTime;
        this.coolingTime = builder.coolingTime;
        assert (builder.fuelCost != null);
        this.fuelCost = builder.fuelCost;
        this.mechanicalMixerMeltable = builder.mechanicalMixerMeltable;
        this.optional = builder.optional;
        this.flags = List.copyOf(builder.flags);
    }

    public static BlazingForm create(String name, UnaryOperator<Builder> builderFunction) {
        return ((Builder)builderFunction.apply(new Builder(name))).build();
    }

    public BlazingForm createFrom(String name, UnaryOperator<Builder> builderFunction) {
        Builder builder = new Builder(name);
        builder.tagFolder = this.tagFolder;
        builder.mods = new ArrayList<Mods>(this.mods);
        builder.customLocation = this.customLocation;
        builder.mold = this.mold;
        builder.amount = this.amount;
        builder.meltingTime = this.meltingTime;
        builder.castingTime = this.castingTime;
        builder.coolingTime = this.coolingTime;
        builder.fuelCost = this.fuelCost;
        builder.mechanicalMixerMeltable = this.mechanicalMixerMeltable;
        builder.optional = this.optional;
        builder.flags = new ArrayList<Flag>(this.flags);
        return ((Builder)builderFunction.apply(builder)).build();
    }

    @Nullable
    public ResourceLocation getCustomLocation() {
        return this.customLocation.get();
    }

    public Ingredient getMeltingIngredient(BlazingMetal metal) {
        if (this.getCustomLocation() != null) {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(this.getCustomLocation())});
        }
        return Ingredient.of(this.getItemTag(metal));
    }

    public List<LoadCondition<?>> getMeltingLoadConditions(BlazingMetal metal) {
        ArrayList conditions = new ArrayList();
        if (this.getCustomLocation() != null) {
            List<Mods> formMods = this.mods.stream().filter(f -> !f.alwaysIncluded).toList();
            List<Mods> metalMods = metal.mods.stream().filter(m -> !m.alwaysIncluded).toList();
            if (!metalMods.isEmpty()) {
                conditions.add(DefaultLoadConditions.anyModLoaded(metalMods));
            }
            if (!formMods.isEmpty()) {
                conditions.add(DefaultLoadConditions.anyModLoaded(formMods));
            }
            return conditions;
        }
        if (this.optional) {
            conditions.add(DefaultLoadConditions.tagsPopulated(this.getItemTag(metal)));
        }
        return conditions;
    }

    public String getMeltingRecipeName(BlazingMetal metal) {
        if (this.getCustomLocation() != null) {
            return "melting/" + this.getCustomLocation().getPath();
        }
        return "melting/" + this.tagFolder + "/" + metal.name;
    }

    public ResourceLocation getCastingResult(BlazingMetal metal, Mods mod) {
        if (this.getCustomLocation() != null) {
            return this.getCustomLocation();
        }
        return mod.asResource(metal.name + "_" + this.name);
    }

    public String getCastingRecipeName(Molds.MoldType moldType, BlazingMetal metal) {
        if (this.getCustomLocation() != null) {
            return String.valueOf((Object)moldType) + "/" + this.getCustomLocation().getPath();
        }
        return String.valueOf((Object)moldType) + "/" + this.name + "/" + metal.name;
    }

    public TagKey<Item> getItemTag(BlazingMetal metal) {
        return this.getItemTag(metal.name);
    }

    public TagKey<Item> getItemTag(String metal) {
        return BlazingTags.itemTag(BlazingTags.Namespace.COMMON.asResource(this.tagFolder, metal));
    }

    public List<Mods> getMods(BlazingMetal metal) {
        if (this.mods.isEmpty()) {
            return metal.mods;
        }
        return this.mods;
    }

    public BlazingForm asOptional(boolean optional) {
        return this.createFrom(this.name, b -> b.optional(optional));
    }

    public BlazingForm fromMods(Mods ... mods) {
        return this.createFrom(this.name, b -> b.clearMods().fromMods(mods));
    }

    public BlazingForm withFlags(Flag ... flags) {
        return this.createFrom(this.name, b -> b.setFlags(flags));
    }

    public static class Builder {
        private final String name;
        private String tagFolder;
        private List<Mods> mods;
        private NullableSupplier<ResourceLocation> customLocation;
        @Nullable
        private Molds.Mold mold;
        @Nullable
        private MultiAmount amount;
        private int meltingTime;
        private int castingTime;
        private int coolingTime;
        @Nullable
        private MultiAmount fuelCost;
        private boolean mechanicalMixerMeltable;
        private boolean optional;
        private List<Flag> flags;

        private Builder(String name) {
            this.name = name;
            this.tagFolder = "";
            this.mods = new ArrayList<Mods>();
            this.customLocation = () -> null;
            this.amount = null;
            this.meltingTime = -1;
            this.castingTime = -1;
            this.coolingTime = -1;
            this.fuelCost = null;
            this.mechanicalMixerMeltable = false;
            this.optional = false;
            this.flags = new ArrayList<Flag>();
            this.flags.add(Flag.MELTING);
            this.flags.add(Flag.CASTING);
        }

        public Builder withTagFolder(String tagFolder) {
            this.tagFolder = tagFolder;
            return this;
        }

        public Builder fromMods(Mods ... mods) {
            this.mods.addAll(List.of(mods));
            return this;
        }

        public Builder clearMods() {
            this.mods.clear();
            return this;
        }

        public Builder withCustomItem(NullableSupplier<ResourceLocation> location) {
            this.customLocation = location;
            return this;
        }

        public Builder withCustomItem(ItemLike item) {
            return this.withCustomItem(() -> BuiltInRegistries.ITEM.getKey((Object)item.asItem()));
        }

        public Builder withMold(@Nullable Molds.Mold mold) {
            this.mold = mold;
            return this;
        }

        public Builder withAmount(MultiAmount amount) {
            this.amount = amount;
            return this;
        }

        public Builder withMeltingTime(int meltingTime) {
            this.meltingTime = meltingTime;
            return this;
        }

        public Builder overrideCastingTime(int castingTime) {
            this.castingTime = castingTime;
            return this;
        }

        public Builder overrideCoolingTime(int coolingTime) {
            this.coolingTime = coolingTime;
            return this;
        }

        public Builder overrideFuelCost(MultiAmount fuelCost) {
            this.fuelCost = fuelCost;
            return this;
        }

        public Builder mechanicalMixerMeltable(boolean value) {
            this.mechanicalMixerMeltable = value;
            return this;
        }

        public Builder optional(boolean value) {
            this.optional = value;
            return this;
        }

        public Builder setFlags(Flag ... flags) {
            this.flags.clear();
            this.flags.addAll(List.of(flags));
            return this;
        }

        public BlazingForm build() {
            if (this.amount == null) {
                throw new NullPointerException("Amount of form " + this.name + " is null");
            }
            if (this.meltingTime < 0) {
                throw new UnsupportedOperationException("Melting time of form " + this.name + " is invalid (" + this.meltingTime + ")");
            }
            int coolingMultiplier = 3;
            int baseDuration = 50;
            int minDuration = 12;
            int castingDuration = (int)((float)this.amount.droplets() / (float)MultiAmount.INGOT.droplets() * (float)baseDuration);
            if (this.castingTime < 0) {
                this.castingTime = Math.max(minDuration, castingDuration);
            }
            if (this.coolingTime < 0) {
                this.coolingTime = this.castingTime * coolingMultiplier;
            }
            if (this.fuelCost == null) {
                this.fuelCost = MultiAmount.fromBucketFraction(1L, 20L).multiply((float)this.amount.droplets() / (float)MultiAmount.INGOT.droplets());
            }
            return new BlazingForm(this);
        }
    }

    public static enum Flag {
        MELTING,
        CASTING;

    }
}

