/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.metal;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.compat.Mods;
import com.dudko.blazinghot.content.metal.BlazingForm;
import com.dudko.blazinghot.registry.BlazingForms;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.dudko.blazinghot.registry.BlazingTags;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BlazingMetal {
    public final String name;
    public final List<Mods> mods;
    public final List<BlazingForm> forms;
    public final Map<Fluid, NonNullSupplier<Block>> fluidInteractions;

    private BlazingMetal(Builder builder) {
        this.name = builder.name;
        this.mods = List.copyOf(builder.mods);
        this.forms = List.copyOf(builder.forms);
        this.fluidInteractions = Map.copyOf(builder.fluidInteractions);
    }

    public static BlazingMetal create(String name, UnaryOperator<Builder> builderFunction) {
        return ((Builder)builderFunction.apply(new Builder(name))).build();
    }

    public BlazingMetal register() {
        BlazingMetals.ALL.add(this);
        return this;
    }

    public String getMoltenName() {
        return "molten_" + this.name;
    }

    public ResourceLocation getFluidLocation() {
        return BlazingHot.asResource(this.getMoltenName());
    }

    public Fluid getFluid() {
        return (Fluid)BuiltInRegistries.FLUID.get(this.getFluidLocation());
    }

    public TagKey<Fluid> getFluidTag() {
        return BlazingTags.fluidTag(BlazingTags.Namespace.COMMON.asResource(this.getMoltenName()));
    }

    public Item getBucket() {
        return this.getFluid().getBucket();
    }

    public static class Builder {
        private final String name;
        private final List<Mods> mods;
        private final List<BlazingForm> forms;
        private final Map<Fluid, NonNullSupplier<Block>> fluidInteractions;

        private Builder(String name) {
            this.name = name;
            this.mods = new ArrayList<Mods>();
            this.forms = new ArrayList<BlazingForm>();
            this.fluidInteractions = new HashMap<Fluid, NonNullSupplier<Block>>();
        }

        public Builder fromMods(Mods ... mods) {
            this.mods.addAll(List.of(mods));
            return this;
        }

        public Builder withForms(BlazingForm ... forms) {
            this.forms.addAll(List.of(forms));
            return this;
        }

        public Builder vanillaForms() {
            return this.withForms(BlazingForms.INGOT, BlazingForms.NUGGET);
        }

        public Builder createForms() {
            if (this.mods.isEmpty() || this.mods.contains((Object)Mods.VANILLA) || this.mods.contains((Object)Mods.CREATE)) {
                return this.vanillaForms().withForms(BlazingForms.CREATE_SHEET);
            }
            return this.vanillaForms().withForms(BlazingForms.SHEET);
        }

        public Builder addFluidInteraction(Fluid fluid, NonNullSupplier<Block> block) {
            this.fluidInteractions.put(fluid, block);
            return this;
        }

        public Builder waterCobble() {
            return this.addFluidInteraction((Fluid)Fluids.WATER, (NonNullSupplier<Block>)((NonNullSupplier)() -> Blocks.COBBLESTONE));
        }

        public BlazingMetal build() {
            if (this.mods.isEmpty()) {
                this.mods.add(Mods.VANILLA);
            }
            return new BlazingMetal(this);
        }
    }
}

