/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.advancement;

import com.dudko.blazinghot.content.casting.Molds;
import com.dudko.blazinghot.data.advancement.BlazingAdvancement;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlazingAdvancements
implements DataProvider {
    public static final List<BlazingAdvancement> ENTRIES = new ArrayList<BlazingAdvancement>();
    public static final BlazingAdvancement START = null;
    public static final BlazingAdvancement ROOT = BlazingAdvancements.create("root", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.BLAZE_WHISK).title("Blazing Hot").description("Create: Hell Edition").awardedForFree().special(BlazingAdvancement.TaskType.SILENT));
    public static final BlazingAdvancement NETHER_COMPOUND = BlazingAdvancements.create("nether_compound", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.NETHER_COMPOUND).title("Mixing the Nether").description("Obtain a Nether Compound").after(ROOT).whenIconCollected());
    public static final BlazingAdvancement BLAZE_ROLL = BlazingAdvancements.create("blaze_roll", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.BLAZE_ROLL).title("Forbidden Sweets").description("\"Bake\" a Blaze Roll").after(NETHER_COMPOUND).whenIconCollected());
    public static final BlazingAdvancement STURDY_ALLOY = BlazingAdvancements.create("sturdy_alloy", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.STURDY_ALLOY).title("Tough Alloys").description("Obtain a Sturdy Alloy").after(NETHER_COMPOUND).whenIconCollected());
    public static final BlazingAdvancement STURDY_CASING = BlazingAdvancements.create("sturdy_casing", b -> b.icon((ItemProviderEntry<?, ?>)BlazingBlocks.STURDY_CASING).title("The Sturdy Age").description("Use your Sturdy Alloys to make some Andesite Casings sturdy").special(BlazingAdvancement.TaskType.NOISY).after(STURDY_ALLOY));
    public static final BlazingAdvancement CASTING = BlazingAdvancements.create("casting", b -> b.icon((ItemProviderEntry<?, ?>)BlazingBlocks.CASTING_DEPOT).title("Casting Apprentice").description("Cast an item using a mold in a Casting Depot").after(STURDY_CASING));
    public static final BlazingAdvancement STURDY_MOLD = BlazingAdvancements.create("sturdy_mold", b -> b.icon((ItemProviderEntry<?, ?>)Molds.INGOT.get(Molds.MoldType.STURDY)).title("Experienced Founder").description("Create a sturdy mold").after(CASTING));
    public static final BlazingAdvancement NETHER_ESSENCE = BlazingAdvancements.create("nether_essence", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.NETHER_ESSENCE).title("Synthetic Hell").description("Haunt Nether Compound into Nether Essence").after(NETHER_COMPOUND).whenIconCollected());
    public static final BlazingAdvancement MOLTEN_GOLD = BlazingAdvancements.create("molten_gold", b -> b.icon((ItemLike)BlazingMetals.GOLD.getBucket()).title("Flowing Riches").description("Melt Gold in Mixer").special(BlazingAdvancement.TaskType.NOISY).after(NETHER_ESSENCE));
    public static final BlazingAdvancement ALL_MOLTEN_METALS = BlazingAdvancements.create("all_molten_metals", b -> b.icon((ItemLike)BlazingMetals.NETHERITE.getBucket()).title("Tinkers' Construct").description("Obtain a bucket of every non-compat molten metal.").after(MOLTEN_GOLD).special(BlazingAdvancement.TaskType.CHALLENGE).rewards(r -> r.addExperience(100).build()).whenItemsCollected(BlazingMetals.allBuckets(false)));
    public static final BlazingAdvancement METAL_APPLE_SPOUT = BlazingAdvancements.create("metal_apple_spout_0000", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.IRON_APPLE).title("Budget Snacks").description("Obtain any Metal Apple by filling regular Apple in Spout").after(MOLTEN_GOLD));
    public static final BlazingAdvancement GOLDEN_APPLE_FACTORY = BlazingAdvancements.create("golden_apple_factory", b -> b.icon((ItemLike)Items.GOLDEN_APPLE).title("Gold Addiction").description("Produce 64 Golden Apples with one Spout").special(BlazingAdvancement.TaskType.EXPERT).after(METAL_APPLE_SPOUT));
    public static final BlazingAdvancement ALL_METAL_FOOD = BlazingAdvancements.create("all_metal_food", b -> b.icon((ItemLike)Items.ENCHANTED_GOLDEN_APPLE).title("A Heavy Diet").description("Eat every Metal Apple and Carrot").after(GOLDEN_APPLE_FACTORY).special(BlazingAdvancement.TaskType.CHALLENGE).rewards(r -> r.addExperience(100).build()).whenAllUsed(BlazingItems.METAL_FOOD));
    public static final BlazingAdvancement EXTINGUISHING_FOOD_SAVE = BlazingAdvancements.create("extinguishing_food_save", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.BLAZE_CARROT).title("Last Resort").description("Save yourself from burning down by eating any extinguishing food when under 2 hearts of health.").after(ALL_METAL_FOOD).special(BlazingAdvancement.TaskType.SECRET));
    public static final BlazingAdvancement MOLTEN_BLAZE_GOLD = BlazingAdvancements.create("molten_blaze_gold_00", b -> b.icon((ItemLike)BlazingMetals.BLAZE_GOLD.getBucket()).title("Fake Alloys").description("Mix Molten Gold and Nether Essence together to obtain Molten Blaze Gold").after(MOLTEN_GOLD));
    public static final BlazingAdvancement BLAZE_GOLD = BlazingAdvancements.create("blaze_gold", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.BLAZE_GOLD_INGOT).title("Hot Treasure").description("Compact Molten Blaze Gold in Basin to obtain a Blaze Gold Ingot").after(MOLTEN_BLAZE_GOLD).whenIconCollected());
    public static final BlazingAdvancement BLAZE_CASING = BlazingAdvancements.create("blaze_casing", b -> b.icon((ItemProviderEntry<?, ?>)BlazingBlocks.BLAZE_CASING).title("The Blaze Age").description("Use Blaze Gold Sheets to upgrade your Copper Casings").special(BlazingAdvancement.TaskType.NOISY).after(BLAZE_GOLD));
    public static final BlazingAdvancement BLAZE_MIXER = BlazingAdvancements.create("blaze_mixer", b -> b.icon((ItemProviderEntry<?, ?>)BlazingBlocks.BLAZE_MIXER).title("New Era of Mixing").description("Combine or melt ingredients in a Blaze Mixer").after(BLAZE_CASING));
    public static final BlazingAdvancement BLAZE_ARROW = BlazingAdvancements.create("blaze_arrow", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.BLAZE_ARROW).title("Power of the Nether").description("Shoot something with a Blaze Arrow in the Nether").special(BlazingAdvancement.TaskType.NOISY).after(BLAZE_MIXER));
    public static final BlazingAdvancement BLAZE_ARROW_INTERDIMENSIONAL = BlazingAdvancements.create("blaze_arrow_interdimensional", b -> b.icon((ItemProviderEntry<?, ?>)BlazingItems.BLAZE_ARROW).title("Interdimensional Sniper").description("Kill an enemy in the Nether with a Blaze Arrow shot in the Overworld").special(BlazingAdvancement.TaskType.CHALLENGE).after(BLAZE_ARROW));
    public static final BlazingAdvancement MODERN_LAMP = BlazingAdvancements.create("modern_lamp", b -> b.icon((ItemProviderEntry<?, ?>)BlazingBlocks.MODERN_LAMP_BLOCKS.get(DyeColor.WHITE)).title("Modern Technology").description("Manually activate any Modern Lamp").after(BLAZE_MIXER));
    public static final BlazingAdvancement BLAZE_MIXER_MAX = BlazingAdvancements.create("blaze_mixer_max", b -> b.icon((ItemProviderEntry<?, ?>)BlazingBlocks.BLAZE_MIXER).title("Fast and Furious").description("Run a fully fueled Blaze Mixer at max speed").after(BLAZE_MIXER).special(BlazingAdvancement.TaskType.EXPERT));
    public static final BlazingAdvancement ANCIENT_DEBRIS_MELTING = BlazingAdvancements.create("ancient_debris_melting", b -> b.icon((ItemLike)Items.ANCIENT_DEBRIS).title("Debris Utilisation").description("Melt 15 Ancient Debris in a single Blaze Mixer").after(BLAZE_MIXER_MAX).special(BlazingAdvancement.TaskType.EXPERT));
    public static final BlazingAdvancement END = null;
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    private static BlazingAdvancement create(String id, UnaryOperator<BlazingAdvancement.Builder> b) {
        return new BlazingAdvancement(id, b);
    }

    public BlazingAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (BlazingAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer, (HolderLookup.Provider)provider);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Blazing Hot's Advancements";
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (BlazingAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

