/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.conditions;

import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;

public class LoadConditionHelper {
    public static <T> String[] stringValues(List<T> values) {
        if (values.isEmpty()) {
            return new String[0];
        }
        if (!(values.getFirst() instanceof String)) {
            throw new IllegalArgumentException("Condition values must be strings");
        }
        return (String[])values.stream().map(c -> (String)c).toArray(String[]::new);
    }

    public static <T, R> TagKey<R>[] tagValues(List<T> values) {
        if (values.isEmpty()) {
            return new TagKey[0];
        }
        if (!(values.getFirst() instanceof TagKey)) {
            throw new IllegalArgumentException("Condition values must be tag keys");
        }
        return (TagKey[])values.stream().map(c -> (TagKey)c).toArray(TagKey[]::new);
    }

    public static <T> ItemLike[] itemLikeValues(List<T> values) {
        if (values.isEmpty()) {
            return new ItemLike[0];
        }
        if (!(values.getFirst() instanceof ItemLike)) {
            throw new IllegalArgumentException("Condition values must be item likes");
        }
        return (ItemLike[])values.stream().map(c -> (ItemLike)c).toArray(ItemLike[]::new);
    }
}

