/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.conditions.neoforge;

import com.dudko.blazinghot.data.conditions.LoadCondition;
import com.dudko.blazinghot.data.conditions.LoadConditionHelper;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.OrCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class LoadConditionImpl<T>
extends LoadCondition<T> {
    protected LoadConditionImpl(LoadCondition.Type type, T ... values) {
        super(type, values);
    }

    @SafeVarargs
    public static <T> LoadCondition<T> create(LoadCondition.Type type, T ... values) {
        return new LoadConditionImpl<T>(type, values);
    }

    private List<ICondition> neoForgeListCondition(LoadCondition<LoadCondition<?>> condition) {
        return condition.getValues().stream().map(this::getNeoForgeCondition).toList();
    }

    public ICondition getNeoForgeCondition() {
        return this.getNeoForgeCondition(this);
    }

    public ICondition getNeoForgeCondition(LoadCondition<?> condition) {
        switch (condition.getType()) {
            case TAGS_POPULATED: {
                TagKey<R>[] tags = LoadConditionHelper.tagValues(condition.getValues());
                if (tags.length == 1) {
                    return new NotCondition((ICondition)new TagEmptyCondition(tags[0].location().toString()));
                }
                List nots = Stream.of(tags).map(tag -> new NotCondition((ICondition)new TagEmptyCondition(tag.location().toString()))).collect(Collectors.toUnmodifiableList());
                return new AndCondition(nots);
            }
            case ALL_MODS_LOADED: {
                String[] mods = LoadConditionHelper.stringValues(condition.getValues());
                if (mods.length == 1) {
                    return new ModLoadedCondition(mods[0]);
                }
                List modLoaded = Stream.of(mods).map(ModLoadedCondition::new).collect(Collectors.toUnmodifiableList());
                return new AndCondition(modLoaded);
            }
            case ANY_MOD_LOADED: {
                String[] mods = LoadConditionHelper.stringValues(condition.getValues());
                if (mods.length == 1) {
                    return new ModLoadedCondition(mods[0]);
                }
                List modLoaded = Stream.of(mods).map(ModLoadedCondition::new).collect(Collectors.toUnmodifiableList());
                return new OrCondition(modLoaded);
            }
            case AND: {
                return new AndCondition(this.neoForgeListCondition(condition));
            }
            case OR: {
                return new OrCondition(this.neoForgeListCondition(condition));
            }
            case NOT: {
                return new NotCondition(this.getNeoForgeCondition(condition.getValues().getFirst()));
            }
            case ITEMS_REGISTERED: {
                ItemLike[] items = LoadConditionHelper.itemLikeValues(condition.getValues());
                if (items.length == 1) {
                    return new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)items[0].asItem()));
                }
                return new OrCondition(Stream.of(items).map(item -> new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)item.asItem()))).collect(Collectors.toUnmodifiableList()));
            }
        }
        throw new UnsupportedOperationException("Unsupported forge condition type: " + condition.getType().id);
    }
}

