/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.lang;

import com.dudko.blazinghot.data.lang.BlazingLang;
import com.dudko.blazinghot.data.lang.ItemDescriptions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class BlazingItemDescription {
    private final String key;
    private final String summary;
    private final Map<String, String> behaviours;

    public BlazingItemDescription(String key, String summary, Map<String, String> behaviours) {
        this.key = key;
        this.summary = summary;
        this.behaviours = behaviours;
    }

    public BlazingItemDescription register() {
        ItemDescriptions.ALL.add(this);
        return this;
    }

    public String getKey() {
        return BlazingLang.Prefix.ITEM.key + "." + this.key;
    }

    public void provideLang(BiConsumer<String, String> consumer) {
        String prefix = this.getKey() + ".tooltip";
        consumer.accept(prefix, this.key.toUpperCase().replace('_', ' '));
        consumer.accept(prefix + ".summary", this.summary);
        int index = 0;
        for (Map.Entry<String, String> entry : this.behaviours.entrySet()) {
            consumer.accept(prefix + ".condition" + ++index, entry.getKey());
            consumer.accept(prefix + ".behaviour" + index, entry.getValue());
        }
    }

    public static Builder builder(String key) {
        return new Builder(key);
    }

    public static class Builder {
        private final String key;
        private String summary;
        private final LinkedHashMap<String, String> behaviours = new LinkedHashMap();

        Builder(String key) {
            this.key = key;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder addBehaviour(String condition, String behaviour) {
            this.behaviours.put(condition, behaviour);
            return this;
        }

        public BlazingItemDescription build() {
            return new BlazingItemDescription(this.key, this.summary, this.behaviours);
        }

        public BlazingItemDescription register() {
            return this.build().register();
        }
    }
}

