/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.lang;

import com.dudko.blazinghot.data.lang.neoforge.BlazingLangImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.BiConsumer;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;

public enum BlazingLang {
    DISPLAY_NAME(Prefix.CATNIP, "display_name", "Create: Blazing Hot"),
    TAB_BASE(Prefix.ITEM_GROUP, "Create: Blazing Hot"),
    TAB_BUILDING(Prefix.ITEM_GROUP, "building", "Blazing Building Blocks"),
    LAMP_LOCKED_MESSAGE(Prefix.MESSAGE, "modern_lamp.lock", "Lamp locked"),
    LAMP_UNLOCKED_MESSAGE(Prefix.MESSAGE, "modern_lamp.unlock", "Lamp unlocked"),
    LAMP_GOGGLE_TITLE(Prefix.GOGGLES, "modern_lamp", "Modern Lamp"),
    LAMP_GOGGLE_STATE(Prefix.GOGGLES, "modern_lamp.state", "Current state:"),
    LAMP_GOGGLE_LOCKED(Prefix.GOGGLES, "modern_lamp.locked", "Locked"),
    LAMP_GOGGLE_UNLOCKED(Prefix.GOGGLES, "modern_lamp.unlocked", "Unlocked"),
    CASTING_GOGGLE_TITLE(Prefix.GOGGLES, "casting_depot", "Casting Depot Info:"),
    CASTING_GOGGLE_NO_MOLD(Prefix.GOGGLES, "casting_depot.no_mold", "Empty"),
    CASTING_GOGGLE_COOLING_SPEED(Prefix.GOGGLES, "casting_depot.cooling_speed", "Cooling speed:"),
    CASTING_GOGGLE_FILLING(Prefix.GOGGLES, "casting_depot.filling", "Casting"),
    CASTING_GOGGLE_COOLING(Prefix.GOGGLES, "casting_depot.cooling", "Cooling"),
    NETHER_LAVA_INFO(Prefix.INFO, "nether_lava_cobblestone", "You can build faster Cobblestone generators when using Nether Lava instead of regular Lava."),
    BLAZE_MIXER_FUEL(Prefix.RECIPE_TOOLTIP, "blaze_mixing.fuel", "Blaze Mixer's fuel"),
    MOLD_CONSUMED(Prefix.RECIPE_TOOLTIP, "spout_casting.consumed", "Consumed on cast"),
    BLAZE_MIXING(Prefix.RECIPE, "blaze_mixing", "Blaze Mixing"),
    BLAZE_AUTO_SHAPELESS(Prefix.RECIPE, "blaze_automatic_shapeless", "Blaze Automated Shapeless Crafting"),
    BLAZE_AUTO_BREWING(Prefix.RECIPE, "blaze_automatic_brewing", "Blaze Automated Brewing"),
    SPOUT_CASTING(Prefix.RECIPE, "spout_casting", "Casting by Spout"),
    EMI_BLAZE_MIXING(Prefix.EMI_RECIPE, "blaze_mixing", "Blaze Mixing"),
    EMI_BLAZE_AUTO_SHAPELESS(Prefix.EMI_RECIPE, "blaze_automatic_shapeless", "Blaze Automated Shapeless Crafting"),
    EMI_BLAZE_AUTO_BREWING(Prefix.EMI_RECIPE, "blaze_automatic_brewing", "Blaze Automated Brewing");

    public final String key;
    private final String translation;

    private BlazingLang(String key, String translation) {
        this.key = key;
        this.translation = translation;
    }

    private BlazingLang(Prefix prefix, String key, String translation) {
        this.key = prefix.key + "." + key;
        this.translation = translation;
    }

    private BlazingLang(Prefix prefix, String translation) {
        this.key = prefix.key;
        this.translation = translation;
    }

    public MutableComponent get() {
        return Component.translatable((String)this.key);
    }

    public LangBuilder translate() {
        String key = this.key.startsWith("blazinghot.") ? this.key.replaceFirst("blazinghot.", "") : this.key;
        return Lang.builder((String)"blazinghot").translate(key, new Object[0]);
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (BlazingLang lang : BlazingLang.values()) {
            consumer.accept(lang.key, lang.translation);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static LangBuilder fluidName(Fluid fluid) {
        return BlazingLangImpl.fluidName(fluid);
    }

    static enum Prefix {
        RECIPE("blazinghot.recipe"),
        RECIPE_TOOLTIP("blazinghot.tooltip"),
        INFO("blazinghot.info"),
        EMI_RECIPE("emi.category.blazinghot"),
        ITEM_GROUP("itemGroup.blazinghot"),
        MESSAGE("message.blazinghot"),
        ITEM("item.blazinghot"),
        GOGGLES("blazinghot.gui.goggles"),
        CATNIP("catnip.blazinghot");

        public final String key;

        private Prefix(String key) {
            this.key = key;
        }
    }
}

