/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.lang;

import com.dudko.blazinghot.data.lang.BlazingItemDescription;
import java.util.HashSet;
import java.util.function.BiConsumer;

public class ItemDescriptions {
    public static final HashSet<BlazingItemDescription> ALL = new HashSet();
    public static final BlazingItemDescription START = null;
    public static final BlazingItemDescription EXTINGUISHING_FOOD = BlazingItemDescription.builder("extinguishing_food").summary("_Extinguishes_ the consumer after being eaten").register();
    public static final BlazingItemDescription OXYGEN_FOOD = BlazingItemDescription.builder("oxygen_food").summary("Restores some _oxygen_ allowing you to _survive underwater_ for a bit longer").register();
    public static final BlazingItemDescription BLAZE_ARROW = BlazingItemDescription.builder("blaze_arrow").summary("Deals _extra damage_ when hitting a target in _The Nether_ dimension").register();
    public static final BlazingItemDescription MODERN_LAMP = BlazingItemDescription.builder("modern_lamp").summary("A _modern_ lamp that can be used to _light up_ your builds, either _manually_ or by _redstone_").addBehaviour("When R-Clicked with Empty Hand", "Toggles between the _on_ and _off_ state").addBehaviour("When R-Clicked with Wrench", "_Locks_ the ability of _toggling_ the lamp _by hand_").register();
    public static final BlazingItemDescription BLAZE_MIXER = BlazingItemDescription.builder("blaze_mixer").summary("A _Blaze_ variant of the _Mechanical Mixer_ that works _faster_ when _fueled_, and has some _special_ recipes.").register();
    public static final BlazingItemDescription END = null;

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (BlazingItemDescription item : ALL) {
            item.provideLang(consumer);
        }
    }

    public static BlazingItemDescription slownessRemovedDescription(int maxAmplitude) {
        Object summary = maxAmplitude == 255 ? "Removes _Slowness_ effect on consumption" : "Removes _Slowness_ effect with _maximum amplitude_ of _" + (maxAmplitude + 1) + "_ on consumption";
        return BlazingItemDescription.builder("slowness_removed_" + maxAmplitude).summary((String)summary).register();
    }
}

