/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.recipe;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.BlazeMixingRecipe;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.BlazeMixingRecipeBuilder;
import com.dudko.blazinghot.content.metal.BlazingForm;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.foundation.recipe.BlazingIngredients;
import com.dudko.blazinghot.foundation.recipe.BlazingRecipeGen;
import com.dudko.blazinghot.registry.BlazingForms;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class BlazeMixingRecipeGen
extends BlazingRecipeGen<ProcessingRecipeParams, BlazeMixingRecipe, BlazeMixingRecipeBuilder> {
    BaseRecipeProvider.GeneratedRecipe NETHER_LAVA = this.create("nether_lava", b -> (BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)b.requireMultiple((ItemLike)BlazingIngredients.netherEssence(), 2)).require(BlazingIngredients.lava(), MultiAmount.fromBucketFraction(1L, 10L))).requiresHeat(HeatCondition.SUPERHEATED)).output((Fluid)BuiltInRegistries.FLUID.get(BlazingHot.asResource("nether_lava")), MultiAmount.fromBucketFraction(1L, 10L)));
    BaseRecipeProvider.GeneratedRecipe MOLTEN_BLAZE_GOLD = this.create("molten_blaze_gold", b -> (BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)b.requireMultiple((ItemLike)BlazingIngredients.netherEssence(), 2)).mixerFuel(BlazingIngredients.fuel(), MultiAmount.fromBucketFraction(1L, 20L)).require(BlazingIngredients.moltenGold(), MultiAmount.INGOT)).requiresHeat(HeatCondition.SUPERHEATED)).duration(200)).output(BlazingMetals.BLAZE_GOLD.getFluid(), MultiAmount.INGOT));
    BaseRecipeProvider.GeneratedRecipe STURDY_MOLDS_MELTING = this.moldMelting();

    public BlazeMixingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        BlazingMetals.ALL.forEach(this::melting);
    }

    protected IRecipeTypeInfo getRecipeType() {
        return BlazingRecipeTypes.BLAZE_MIXING;
    }

    protected BlazeMixingRecipeBuilder getBuilder(ResourceLocation id) {
        return new BlazeMixingRecipeBuilder((ProcessingRecipe.Factory<ProcessingRecipeParams, BlazeMixingRecipe>)((ProcessingRecipe.Factory)BlazeMixingRecipe::new), id);
    }

    private void melting(BlazingMetal metal) {
        for (BlazingForm form : metal.forms) {
            if (!form.flags.contains((Object)BlazingForm.Flag.MELTING)) continue;
            this.create(form.getMeltingRecipeName(metal), b -> (BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)b.withConditions((List)form.getMeltingLoadConditions(metal))).mixerFuel(BlazingIngredients.fuel(), form.fuelCost).require(form.getMeltingIngredient(metal))).duration(form.meltingTime)).requiresHeat(HeatCondition.SUPERHEATED)).output(metal.getFluid(), form.amount));
        }
    }

    private BaseRecipeProvider.GeneratedRecipe moldMelting() {
        BlazingForm form = BlazingForms.STURDY_MOLD;
        return this.create("melting/sturdy_molds", b -> (BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)((BlazeMixingRecipeBuilder)b.mixerFuel(BlazingIngredients.fuel(), form.fuelCost).require(BlazingTags.Items.STURDY_MOLDS.tag())).duration(form.meltingTime)).requiresHeat(HeatCondition.SUPERHEATED)).output(BlazingMetals.STURDY_ALLOY.getFluid(), form.amount));
    }
}

