/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.recipe;

import com.dudko.blazinghot.compat.Mods;
import com.dudko.blazinghot.content.casting.Molds;
import com.dudko.blazinghot.content.casting.casting_depot.recipe.CastingRecipe;
import com.dudko.blazinghot.content.casting.casting_depot.recipe.CastingRecipeBuilder;
import com.dudko.blazinghot.content.casting.casting_depot.recipe.CastingRecipeParams;
import com.dudko.blazinghot.content.metal.BlazingForm;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.data.conditions.DefaultLoadConditions;
import com.dudko.blazinghot.data.conditions.LoadCondition;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.foundation.recipe.BlazingRecipeGen;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CastingRecipeGen
extends BlazingRecipeGen<CastingRecipeParams, CastingRecipe, CastingRecipeBuilder> {
    public CastingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        BlazingMetals.ALL.forEach(this::casting);
        Molds.ALL.forEach(this::mold);
    }

    protected IRecipeTypeInfo getRecipeType() {
        return BlazingRecipeTypes.CASTING;
    }

    protected CastingRecipeBuilder getBuilder(ResourceLocation id) {
        return new CastingRecipeBuilder((ProcessingRecipe.Factory<CastingRecipeParams, CastingRecipe>)((ProcessingRecipe.Factory)CastingRecipe::new), id);
    }

    private void mold(Molds.Mold mold) {
        Ingredient base = mold.shape != null ? Ingredient.of(mold.shape) : Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BARS});
        this.create(BuiltInRegistries.ITEM.getKey((Object)mold.get(Molds.MoldType.STURDY).asItem()), b -> (CastingRecipeBuilder)((CastingRecipeBuilder)((CastingRecipeBuilder)b.require(base)).require(BlazingMetals.STURDY_ALLOY.getFluidTag(), MultiAmount.INGOT.multiply(2.0f))).castingDuration(MultiAmount.INGOT.multiply(2.0f)).output((ItemLike)mold.get(Molds.MoldType.STURDY)));
    }

    private void casting(BlazingMetal metal) {
        for (BlazingForm form : metal.forms) {
            Molds.Mold mold;
            if (!form.flags.contains((Object)BlazingForm.Flag.CASTING) || (mold = form.mold) == null) continue;
            for (Molds.MoldType moldType : Molds.MoldType.values()) {
                if (!moldType.usable) continue;
                for (Mods mod : form.getMods(metal)) {
                    String name = (String)(mod.alwaysIncluded ? "" : "compat/" + mod.id + "/") + form.getCastingRecipeName(moldType, metal);
                    this.create(name, b -> {
                        ((CastingRecipeBuilder)((CastingRecipeBuilder)((CastingRecipeBuilder)b.require((ItemLike)mold.get(moldType))).require(metal.getFluidTag(), form.amount)).duration(form.castingTime)).coolingDuration(form.coolingTime).keepMold(moldType.reusable).output(form.getCastingResult(metal, mod));
                        if (!mod.alwaysIncluded) {
                            b.withConditions(new LoadCondition[]{DefaultLoadConditions.anyModLoaded(mod)});
                        }
                        return b;
                    });
                }
            }
        }
    }
}

