/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.recipe;

import com.dudko.blazinghot.content.metal.BlazingForm;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.foundation.recipe.BlazingIngredients;
import com.dudko.blazinghot.foundation.recipe.BlazingStandardRecipeBuilder;
import com.dudko.blazinghot.foundation.recipe.BlazingStandardRecipeGen;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;

public class MixingRecipeGen
extends BlazingStandardRecipeGen<MixingRecipe> {
    BaseRecipeProvider.GeneratedRecipe NETHER_COMPOUND = this.create("nether_compound", b -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.require((ItemLike)BlazingIngredients.clayBall())).require(BlazingIngredients.netherrackDust())).require(BlazingIngredients.soulDust())).output(BlazingItems.NETHER_COMPOUND, 2));
    BaseRecipeProvider.GeneratedRecipe NETHER_DOUGH = this.create("nether_dough", b -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.require((ItemLike)BlazingIngredients.netherCompound())).require(BlazingIngredients.netherFlora())).require(BlazingIngredients.wheatFlour())).output(BlazingItems.NETHER_DOUGH));
    BaseRecipeProvider.GeneratedRecipe NETHERRACK_DUST = this.create("netherrack_dust", b -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)b.require((ItemLike)BlazingIngredients.cinderFlour())).require(BlazingIngredients.stoneDust())).output(BlazingItems.NETHERRACK_DUST, 2));
    BaseRecipeProvider.GeneratedRecipe MOLTEN_BLAZE_GOLD = this.bCreate("molten_blaze_gold", (BlazingStandardRecipeBuilder<R> b) -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((BlazingStandardRecipeBuilder)((BlazingStandardRecipeBuilder)b.output(BlazingMetals.BLAZE_GOLD.getFluid(), MultiAmount.ROD).requireMultiple((ItemLike)BlazingIngredients.netherEssence(), 2)).require(BlazingIngredients.moltenGold(), MultiAmount.ROD)).mechanicalMixerOnly().requiresHeat(HeatCondition.SUPERHEATED)).duration(200));
    BaseRecipeProvider.GeneratedRecipe MOLTEN_NETHERITE = this.bCreate("molten_netherite", (BlazingStandardRecipeBuilder<R> b) -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((BlazingStandardRecipeBuilder)((BlazingStandardRecipeBuilder)b.output(BlazingMetals.NETHERITE.getFluid(), MultiAmount.INGOT.divide(4.0f)).require(BlazingIngredients.moltenGold(), MultiAmount.INGOT)).require(BlazingIngredients.moltenAncientDebris(), MultiAmount.INGOT)).duration(200)).requiresHeat(HeatCondition.SUPERHEATED));
    BaseRecipeProvider.GeneratedRecipe MOLTEN_ANDESITE = this.bCreate("molten_andesite", (BlazingStandardRecipeBuilder<R> b) -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((BlazingStandardRecipeBuilder)b.output(BlazingMetals.ANDESITE.getFluid(), MultiAmount.ROD.multiply(3.0f)).require(BlazingIngredients.moltenIron(), MultiAmount.NUGGET)).require((ItemLike)BlazingIngredients.andesite())).requiresHeat(HeatCondition.HEATED));
    BaseRecipeProvider.GeneratedRecipe MOLTEN_BRASS = this.bCreate("molten_brass", (BlazingStandardRecipeBuilder<R> b) -> (StandardProcessingRecipe.Builder)((BlazingStandardRecipeBuilder)((BlazingStandardRecipeBuilder)b.output(BlazingMetals.BRASS.getFluid(), MultiAmount.INGOT.multiply(2.0f)).require(BlazingIngredients.moltenCopper(), MultiAmount.INGOT)).require(BlazingIngredients.moltenZinc(), MultiAmount.INGOT)).requiresHeat(HeatCondition.HEATED));
    BaseRecipeProvider.GeneratedRecipe MOLTEN_STURDY_ALLOY = this.bCreate("molten_sturdy_alloy", (BlazingStandardRecipeBuilder<R> b) -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((BlazingStandardRecipeBuilder)b.output(BlazingMetals.STURDY_ALLOY.getFluid(), MultiAmount.INGOT).require(BlazingIngredients.moltenIron(), MultiAmount.INGOT)).require(BlazingIngredients.powderedObsidian())).require((ItemLike)BlazingIngredients.netherCompound())).duration(200)).requiresHeat(HeatCondition.SUPERHEATED));

    public MixingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        BlazingMetals.ALL.forEach(this::melting);
    }

    private void melting(BlazingMetal metal) {
        for (BlazingForm form : metal.forms) {
            if (!form.flags.contains((Object)BlazingForm.Flag.MELTING) || !form.mechanicalMixerMeltable) continue;
            this.bCreate(form.getMeltingRecipeName(metal), (BlazingStandardRecipeBuilder<R> b) -> (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((BlazingStandardRecipeBuilder)((BlazingStandardRecipeBuilder)((BlazingStandardRecipeBuilder)b.withConditions((List)form.getMeltingLoadConditions(metal))).output(metal.getFluid(), form.amount)).require(form.getMeltingIngredient(metal))).mechanicalMixerOnly().duration(form.meltingTime * 3)).requiresHeat(HeatCondition.SUPERHEATED));
        }
    }

    protected IRecipeTypeInfo getRecipeType() {
        return AllRecipeTypes.MIXING;
    }
}

