/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.data.recipe;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.foundation.recipe.BlazingIngredients;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.dudko.blazinghot.registry.BlazingForms;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.dudko.blazinghot.util.ItemUtil;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class StandardRecipeGen
extends BaseRecipeProvider {
    BaseRecipeProvider.GeneratedRecipe BLAZE_GOLD_INGOT_C = this.compressing((ItemLike)BlazingItems.BLAZE_GOLD_INGOT, (ItemLike)BlazingBlocks.BLAZE_GOLD_BLOCK, (ItemLike)BlazingItems.BLAZE_GOLD_INGOT);
    BaseRecipeProvider.GeneratedRecipe BLAZE_GOLD_NUGGET_C = this.compressing((ItemLike)BlazingItems.BLAZE_GOLD_NUGGET, (ItemLike)BlazingItems.BLAZE_GOLD_INGOT, (ItemLike)BlazingItems.BLAZE_GOLD_INGOT);
    BaseRecipeProvider.GeneratedRecipe BLAZE_GOLD_BLOCK_D = this.decompressing((ItemLike)BlazingBlocks.BLAZE_GOLD_BLOCK, (ItemLike)BlazingItems.BLAZE_GOLD_INGOT, 9, (ItemLike)BlazingItems.BLAZE_GOLD_INGOT);
    BaseRecipeProvider.GeneratedRecipe BLAZE_GOLD_INGOT_D = this.decompressing((ItemLike)BlazingItems.BLAZE_GOLD_INGOT, (ItemLike)BlazingItems.BLAZE_GOLD_NUGGET, 9, (ItemLike)BlazingItems.BLAZE_GOLD_INGOT);
    BaseRecipeProvider.GeneratedRecipe IRON_APPLE = this.metalApple(BlazingMetals.IRON, (ItemLike)BlazingItems.IRON_APPLE);
    BaseRecipeProvider.GeneratedRecipe IRON_CARROT = this.metalCarrot(BlazingMetals.IRON, (ItemLike)BlazingItems.IRON_CARROT);
    BaseRecipeProvider.GeneratedRecipe BLAZE_APPLE = this.metalApple(BlazingMetals.BLAZE_GOLD, (ItemLike)BlazingItems.BLAZE_APPLE);
    BaseRecipeProvider.GeneratedRecipe BLAZE_CARROT = this.metalCarrot(BlazingMetals.BLAZE_GOLD, (ItemLike)BlazingItems.BLAZE_CARROT);
    BaseRecipeProvider.GeneratedRecipe BRASS_APPLE = this.metalApple(BlazingMetals.BRASS, (ItemLike)BlazingItems.BRASS_APPLE);
    BaseRecipeProvider.GeneratedRecipe BRASS_CARROT = this.metalCarrot(BlazingMetals.BRASS, (ItemLike)BlazingItems.BRASS_CARROT);
    BaseRecipeProvider.GeneratedRecipe ZINC_APPLE = this.metalApple(BlazingMetals.ZINC, (ItemLike)BlazingItems.ZINC_APPLE);
    BaseRecipeProvider.GeneratedRecipe ZINC_CARROT = this.metalCarrot(BlazingMetals.ZINC, (ItemLike)BlazingItems.ZINC_CARROT);
    BaseRecipeProvider.GeneratedRecipe COPPER_APPLE = this.metalApple(BlazingMetals.COPPER, (ItemLike)BlazingItems.COPPER_APPLE);
    BaseRecipeProvider.GeneratedRecipe COPPER_CARROT = this.metalCarrot(BlazingMetals.COPPER, (ItemLike)BlazingItems.COPPER_CARROT);
    BaseRecipeProvider.GeneratedRecipe WHITE_MODERN_LAMP = this.create((ItemProviderEntry<? extends ItemLike, ?>)BlazingBlocks.MODERN_LAMP_BLOCKS.get(DyeColor.WHITE)).unlockedByTag(BlazingIngredients::blazeGoldRod).returns(2).viaShaped(b -> b.define(Character.valueOf('X'), BlazingIngredients.blazeGoldRod()).define(Character.valueOf('Y'), (ItemLike)BlazingIngredients.glowstone()).define(Character.valueOf('G'), (ItemLike)Items.GLASS).pattern(" G ").pattern("GYG").pattern(" X "));
    BaseRecipeProvider.GeneratedRecipe BLAZE_ARROW = this.create((ItemProviderEntry<? extends ItemLike, ?>)BlazingItems.BLAZE_ARROW).unlockedByTag(BlazingIngredients::blazeGoldRod).returns(4).viaShaped(b -> b.define(Character.valueOf('X'), BlazingIngredients.coal()).define(Character.valueOf('Y'), BlazingIngredients.blazeGoldRod()).define(Character.valueOf('Z'), (ItemLike)BlazingIngredients.feather()).pattern(" X ").pattern(" Y ").pattern(" Z "));
    BaseRecipeProvider.GeneratedRecipe BLAZE_WHISK = this.create((ItemProviderEntry<? extends ItemLike, ?>)BlazingItems.BLAZE_WHISK).unlockedByTag(BlazingIngredients::blazeGoldIngot).viaShaped(b -> b.define(Character.valueOf('X'), BlazingIngredients.brassIngot()).define(Character.valueOf('Y'), BlazingIngredients.blazeGoldSheet()).pattern(" X ").pattern("YXY").pattern("YYY"));
    BaseRecipeProvider.GeneratedRecipe CASTING_DEPOT = this.create((ItemProviderEntry<? extends ItemLike, ?>)BlazingBlocks.CASTING_DEPOT).unlockedBy(BlazingIngredients::sturdyCasing).viaShaped(b -> b.define(Character.valueOf('C'), BlazingIngredients.sturdyCasing()).define(Character.valueOf('A'), BlazingIngredients.sturdyAlloy()).define(Character.valueOf('E'), BlazingIngredients.electronTube()).pattern("A").pattern("C").pattern("E"));

    public StandardRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "blazinghot");
    }

    private BaseRecipeProvider.GeneratedRecipe compressing(ItemLike ingredient, ItemLike result, ItemLike unlockedBy) {
        return this.create(() -> result).unlockedBy(() -> unlockedBy).withSuffix("_from_" + ItemUtil.getItemID(ingredient).getPath()).viaShaped(b -> b.define(Character.valueOf('X'), ingredient).pattern("XXX").pattern("XXX").pattern("XXX"));
    }

    private BaseRecipeProvider.GeneratedRecipe decompressing(ItemLike ingredient, ItemLike result, int count, ItemLike unlockedBy) {
        return this.create(() -> result).returns(count).unlockedBy(() -> unlockedBy).withSuffix("_from_" + ItemUtil.getItemID(ingredient).getPath()).viaShapeless(b -> b.requires(ingredient));
    }

    private BaseRecipeProvider.GeneratedRecipe covering(ItemLike ingredient, TagKey<Item> cover, ItemLike result, TagKey<Item> unlockedBy) {
        return this.create(() -> result).unlockedByTag(() -> unlockedBy).viaShaped(b -> b.define(Character.valueOf('Y'), ingredient).define(Character.valueOf('X'), cover).pattern("XXX").pattern("XYX").pattern("XXX"));
    }

    private BaseRecipeProvider.GeneratedRecipe metalApple(BlazingMetal metal, ItemLike result) {
        return this.covering((ItemLike)BlazingIngredients.apple(), BlazingForms.INGOT.getItemTag(metal), result, BlazingForms.INGOT.getItemTag(metal));
    }

    private BaseRecipeProvider.GeneratedRecipe metalCarrot(BlazingMetal metal, ItemLike result) {
        return this.covering((ItemLike)BlazingIngredients.carrot(), BlazingForms.NUGGET.getItemTag(metal), result, BlazingForms.INGOT.getItemTag(metal));
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ?> result) {
        return this.create(() -> result.get());
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return StandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return StandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private static ResourceLocation clean(ResourceLocation loc) {
            String path = loc.getPath();
            while (path.contains("//")) {
                path = path.replaceAll("//", "/");
            }
            return ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)path);
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return GeneratedRecipeBuilder.clean(BlazingHot.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix));
        }

        private ResourceLocation createLocation(String recipeType) {
            return GeneratedRecipeBuilder.clean(BlazingHot.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().getPath() + this.suffix));
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)this.result.get().asItem()) : this.compatDatagenOutput;
        }
    }
}

