/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.mixin;

import com.dudko.blazinghot.content.casting.casting_depot.SpoutCastingBehaviour;
import com.dudko.blazinghot.foundation.mixin_interfaces.IAirCurrent;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AirCurrent.class}, remap=false)
public abstract class AirCurrentMixin
implements IAirCurrent {
    @Unique
    protected List<Pair<SpoutCastingBehaviour, FanProcessingType>> blazinghot$affectedDepotHandlers = new ArrayList<Pair<SpoutCastingBehaviour, FanProcessingType>>();
    @Shadow
    @Final
    public IAirCurrentSource source;

    @Shadow
    private int getLimit() {
        return 0;
    }

    @Unique
    public void blazinghot$findAffectedDepots() {
        AirCurrent self = (AirCurrent)this;
        Level world = self.source.getAirCurrentWorld();
        BlockPos start = self.source.getAirCurrentPos();
        this.blazinghot$clearCastingHandlers();
        int limit = this.getLimit();
        block0: for (int i = 1; i <= limit; ++i) {
            FanProcessingType segmentType = self.getTypeAt((float)(i - 1));
            for (int offset : Iterate.zeroAndOne) {
                BlockPos pos = start.relative(self.direction, i).below(offset);
                SpoutCastingBehaviour behaviour = (SpoutCastingBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, SpoutCastingBehaviour.TYPE);
                if (behaviour != null) {
                    FanProcessingType type = FanProcessingType.getAt((Level)world, (BlockPos)pos);
                    if (type == null) {
                        type = segmentType;
                    }
                    if (type == null) continue;
                    behaviour.fanModifiers.add(type);
                    this.blazinghot$affectedDepotHandlers.add((Pair<SpoutCastingBehaviour, FanProcessingType>)Pair.of((Object)((Object)behaviour), (Object)type));
                }
                if (self.direction.getAxis().isVertical()) continue block0;
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void blazinghot$tickDepots(CallbackInfo ci) {
        if (this.source.isSourceRemoved()) {
            this.blazinghot$clearCastingHandlers();
        }
    }

    @Override
    @Unique
    public void blazinghot$clearCastingHandlers() {
        this.blazinghot$affectedDepotHandlers.forEach(pair -> ((SpoutCastingBehaviour)((Object)((Object)pair.getFirst()))).fanModifiers.remove(pair.getSecond()));
        this.blazinghot$affectedDepotHandlers.clear();
    }

    @Inject(method={"rebuild()V"}, at={@At(value="RETURN")})
    private void blazinghot$rebuild(CallbackInfo ci) {
        this.blazinghot$findAffectedDepots();
    }
}

