/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.mixin;

import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.BlazeMixingRecipe;
import com.dudko.blazinghot.data.advancement.BlazingAdvancement;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.foundation.mixin_interfaces.IAdvancementBehaviour;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiFluids;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MechanicalMixerBlockEntity.class})
public abstract class MechanicalMixerBlockEntityMixin
extends BasinOperatingBlockEntity
implements IAdvancementBehaviour {
    public MechanicalMixerBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"addBehaviours(Ljava/util/List;)V"}, at={@At(value="TAIL")}, remap=false)
    private void blazinghot$addAdvancements(List<BlockEntityBehaviour> behaviours, CallbackInfo ci) {
        this.blazinghot$registerAwardables(behaviours, new BlazingAdvancement[]{BlazingAdvancements.MOLTEN_GOLD, BlazingAdvancements.MOLTEN_BLAZE_GOLD});
    }

    @ModifyArg(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"), index=2)
    protected int blazinghot$extendDuration(int max) {
        if (this.currentRecipe == null || !BlazeMixingRecipe.isMeltingRecipe(this.currentRecipe)) {
            return max;
        }
        return max * 16;
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/mixer/MechanicalMixerBlockEntity;applyBasinRecipe()V")}, remap=false)
    private void blazinghot$meltingAdvancements(CallbackInfo ci) {
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof MixingRecipe) {
            MixingRecipe recipe2 = (MixingRecipe)recipe;
            if (MultiFluids.recipeResultContains(recipe2, BlazingMetals.GOLD.getFluidTag())) {
                this.blazinghot$award(BlazingAdvancements.MOLTEN_GOLD);
            }
            if (MultiFluids.recipeResultContains(recipe2, BlazingMetals.BLAZE_GOLD.getFluidTag())) {
                this.blazinghot$award(BlazingAdvancements.MOLTEN_BLAZE_GOLD);
            }
        }
    }
}

