/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.mixin.neoforge;

import com.dudko.blazinghot.registry.neoforge.BlazingFluidsImpl;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    protected boolean firstTick;
    @Shadow(remap=false)
    protected Object2DoubleMap<FluidType> forgeFluidTypeHeight;

    @Unique
    private boolean blazinghot$isInBurningFluid() {
        ArrayList<FluidType> burningFluids = new ArrayList<FluidType>();
        burningFluids.add(BlazingFluidsImpl.NETHER_LAVA.getType());
        BlazingFluidsImpl.MOLTEN_METALS.forEach(metal -> burningFluids.add(metal.getType()));
        return !this.firstTick && burningFluids.stream().anyMatch(f -> this.forgeFluidTypeHeight.getDouble(f) > 0.0);
    }

    @ModifyReturnValue(method={"isInLava()Z"}, at={@At(value="RETURN")})
    public boolean blazinghot$isInLavaInjector(boolean original) {
        return original || this.blazinghot$isInBurningFluid();
    }
}

