/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.mixin.neoforge;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.SpoutCastingBehaviour;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.spout.SpoutRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpoutRenderer.class}, remap=false)
public abstract class SpoutRendererMixin {
    @Shadow
    @Final
    static PartialModel[] BITS = new PartialModel[]{AllPartialModels.SPOUT_TOP, AllPartialModels.SPOUT_MIDDLE, AllPartialModels.SPOUT_BOTTOM};

    @Inject(method={"renderSafe(Lcom/simibubi/create/content/fluids/spout/SpoutBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="FIELD", ordinal=0, target="Lcom/simibubi/create/content/fluids/spout/SpoutBlockEntity;processingTicks:I")}, cancellable=true)
    public void blazinghot$modifyProcessingProgress(SpoutBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, CallbackInfo ci, @Local(name={"fluidStack"}) FluidStack fluidStack) {
        int duration;
        boolean isQuick;
        CastingDepotBlockEntity depot = this.blazinghot$getCastingDepot(be);
        if (depot == null) {
            return;
        }
        SpoutCastingBehaviour behaviour = (SpoutCastingBehaviour)depot.getBehaviour(SpoutCastingBehaviour.TYPE);
        int processingTicks = behaviour.getProcessingTicks();
        if (behaviour.getState() == SpoutCastingBehaviour.State.NONE) {
            return;
        }
        if (behaviour.getState() != SpoutCastingBehaviour.State.FILLING) {
            processingTicks = -1;
        }
        boolean bl = isQuick = (duration = behaviour.getRecipeProcessingDuration()) < 20;
        if (processingTicks != -1) {
            processingTicks = duration - processingTicks;
        }
        float processingPT = (float)processingTicks - partialTicks;
        float radius = 0.0f;
        if (!fluidStack.isEmpty() && processingTicks != -1) {
            float start = (float)((double)0.04f * Math.pow(processingPT - (float)duration + 10.0f, 2.0)) - 1.0f;
            float end = (float)((double)0.04f * Math.pow(processingPT - 10.0f, 2.0)) - 1.0f;
            radius = isQuick ? Math.max(start, end) : (processingPT > (float)(duration - 10) ? start : (processingPT < 10.0f ? end : -1.0f));
            radius = Mth.clamp((float)radius, (float)-1.0f, (float)0.0f);
            AABB bb = new AABB(0.5, 0.0, 0.5, 0.5, -1.4, 0.5).inflate((double)(radius / 32.0f));
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, (float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ, buffer, ms, light, true, true);
        }
        float squeeze = radius;
        if (processingPT < 0.0f) {
            squeeze = 0.0f;
        } else if (processingPT < 2.0f && !isQuick) {
            squeeze = Mth.lerp((float)(processingPT / 2.0f), (float)0.0f, (float)-1.0f);
        } else if (processingPT < (float)(duration - 10) && !isQuick) {
            squeeze = -1.0f;
        }
        ms.pushPose();
        for (PartialModel bit : BITS) {
            CachedBuffers.partial((PartialModel)bit, (BlockState)be.getBlockState()).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
            ms.translate(0.0f, -3.0f * squeeze / 32.0f, 0.0f);
        }
        ms.popPose();
        ci.cancel();
    }

    @Unique
    @Nullable
    private CastingDepotBlockEntity blazinghot$getCastingDepot(SpoutBlockEntity spout) {
        Level level = spout.getLevel();
        if (level == null) {
            return null;
        }
        BlockPos pos = spout.getBlockPos();
        BlockEntity beBelow = level.getBlockEntity(pos.below(2));
        if (!(beBelow instanceof CastingDepotBlockEntity)) {
            return null;
        }
        CastingDepotBlockEntity depot = (CastingDepotBlockEntity)beBelow;
        return depot;
    }
}

