/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.multiloader.fluid;

import com.dudko.blazinghot.foundation.multiloader.fluid.neoforge.MultiAmountImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;

public record MultiAmount(long droplets, int millibuckets) {
    public static final MultiAmount EMPTY = MultiAmount.standard(0L);
    public static final MultiAmount BOTTLE = MultiAmount.standard(20250L);
    public static final MultiAmount BUCKET = MultiAmount.standard(81000L);
    public static final MultiAmount INGOT = MultiAmount.metal(9000L);
    public static final MultiAmount NUGGET = MultiAmount.metal(1000L);
    public static final MultiAmount BLOCK = MultiAmount.metal(81000L);
    public static final MultiAmount ROD = MultiAmount.metal(4500L);
    public static final MultiAmount INGOT_COVER = INGOT.multiply(6.0f);
    public static final MultiAmount NUGGET_COVER = NUGGET.multiply(6.0f);
    public static final MultiAmount RAW_ORE = NUGGET.multiply(12.0f);

    public long get() {
        return MultiAmount.get(this);
    }

    public int getInt() {
        return (int)this.get();
    }

    public MultiAmount multiply(float multiplier) {
        if (multiplier == 0.0f) {
            return EMPTY;
        }
        return new MultiAmount((long)((float)this.droplets * multiplier), (int)((float)this.millibuckets * multiplier));
    }

    public MultiAmount divide(float divider) {
        if (divider == 0.0f) {
            return EMPTY;
        }
        return new MultiAmount((long)((float)this.droplets / divider), (int)((float)this.millibuckets / divider));
    }

    public static MultiAmount standard(long droplets) {
        return new MultiAmount(droplets, (int)(droplets / 81L));
    }

    public static MultiAmount standardMb(int millibuckets) {
        return new MultiAmount((long)millibuckets * 81L, millibuckets);
    }

    public static MultiAmount metal(long droplets) {
        return new MultiAmount(droplets, (int)((float)droplets / 100.0f));
    }

    public static MultiAmount metalMb(int millibuckets) {
        return new MultiAmount((long)((float)millibuckets * 100.0f), millibuckets);
    }

    public static MultiAmount fromBucketFraction(long numerator, long denominator) {
        long total = numerator * BUCKET.droplets();
        if (total % denominator != 0L) {
            throw new IllegalArgumentException("Not a valid number of droplets!");
        }
        return MultiAmount.standard(total / denominator);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static long get(MultiAmount amount) {
        return MultiAmountImpl.get(amount);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MultiAmount from(long amount) {
        return MultiAmountImpl.from(amount);
    }
}

