/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.multiloader.neoforge;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.content.block.modern_lamp.AbstractModernLamp;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampDoublePanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampHalfPanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampPanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.SmallModernLampPanelBlock;
import com.dudko.blazinghot.content.casting.Molds;
import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlock;
import com.dudko.blazinghot.data.lang.ItemDescriptions;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlazingBuilderTransformersImpl {
    public static <B extends AbstractModernLamp, P> NonNullUnaryOperator<BlockBuilder<B, P>> anyModernLamp(DyeColor color) {
        return b -> ((BlockBuilder)b.initialProperties(() -> Blocks.GLOWSTONE).properties(p -> p.mapColor(color).lightLevel(s -> (Boolean)s.getValue((Property)ModernLampPanelBlock.LIT) != false ? 15 : 0).forceSolidOn()).onRegisterAfter(Registries.ITEM, v -> ItemDescription.useKey((ItemLike)v, (String)ItemDescriptions.MODERN_LAMP.getKey()))).tag(new TagKey[]{AllTags.AllBlockTags.WRENCH_PICKUP.tag});
    }

    public static <B extends ModernLampBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> modernLampBlock(DyeColor color, BlazingTags.Blocks tag) {
        return a -> (BlockBuilder)a.initialProperties(() -> Blocks.GLOWSTONE).properties(p -> p.mapColor(color).lightLevel(s -> (Boolean)s.getValue((Property)ModernLampBlock.LIT) != false ? 15 : 0)).tag(new TagKey[]{tag.tag()}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().cubeAll(color.getName() + "_modern_lamp" + ((Boolean)state.getValue((Property)ModernLampBlock.LIT) != false ? "_powered" : ""), p.modLoc("block/modern_lamp/block/" + color.getName() + ((Boolean)state.getValue((Property)ModernLampBlock.LIT) != false ? "_powered" : "")))).build())).item().tag(new TagKey[]{tag.itemTag()}).model((c, b) -> b.blockItem((NonNullSupplier)c).texture("#all", b.modLoc("block/modern_lamp/block/" + color.getName()))).build();
    }

    public static <B extends ModernLampPanelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> modernLampPanel(DyeColor color, String name, BlazingTags.Blocks tag) {
        String tagName = name.replace('/', '_') + "s";
        return b -> (BlockBuilder)b.tag(new TagKey[]{tag.tag()}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)ModernLampPanelBlock.FACING);
            int xRotation = facing == Direction.DOWN ? 180 : 0;
            int yRotation = facing.getAxis().isVertical() ? 0 : (int)facing.toYRot();
            Object variant = color.getName();
            if (((Direction)state.getValue((Property)ModernLampPanelBlock.FACING)).getAxis().isHorizontal()) {
                variant = (String)variant + "_vertical";
            }
            if (((Boolean)state.getValue((Property)ModernLampPanelBlock.LIT)).booleanValue()) {
                variant = (String)variant + "_powered";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + name + "/" + (String)variant))).rotationX((xRotation + 360) % 360).rotationY((yRotation + 360) % 360).build();
        })).item().tag(new TagKey[]{tag.itemTag()}).transform(ModelGen.customItemModel((String[])new String[]{name, color.getName()}));
    }

    public static <B extends ModernLampDoublePanelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> modernLampDirectionalPanel(DyeColor color, String name, BlazingTags.Blocks tag) {
        String tagName = name.replace('/', '_') + "s";
        return b -> (BlockBuilder)b.tag(new TagKey[]{tag.tag()}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)ModernLampPanelBlock.FACING);
            int xRotation = facing == Direction.DOWN ? 180 : 0;
            int yRotation = facing.getAxis().isVertical() ? 0 : (int)facing.toYRot();
            Object variant = color.getName();
            if (((Boolean)state.getValue((Property)ModernLampDoublePanelBlock.HORIZONTAL)).booleanValue()) {
                variant = (String)variant + "_h";
            }
            if (((Direction)state.getValue((Property)ModernLampPanelBlock.FACING)).getAxis().isHorizontal()) {
                variant = (String)variant + "_vertical";
            }
            if (((Boolean)state.getValue((Property)ModernLampPanelBlock.LIT)).booleanValue()) {
                variant = (String)variant + "_powered";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + name + "/" + (String)variant))).rotationX((xRotation + 360) % 360).rotationY((yRotation + 360) % 360).build();
        })).item().tag(new TagKey[]{tag.itemTag()}).transform(ModelGen.customItemModel((String[])new String[]{name, color.getName() + "_h"}));
    }

    public static <B extends ModernLampHalfPanelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> modernLampHalfPanel(DyeColor color, String name, BlazingTags.Blocks tag) {
        String tagName = name.replace('/', '_') + "s";
        return b -> (BlockBuilder)b.tag(new TagKey[]{tag.tag()}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)ModernLampPanelBlock.FACING);
            int xRotation = facing == Direction.DOWN ? 180 : 0;
            int yRotation = facing.getAxis().isVertical() ? 0 : (int)facing.toYRot();
            String dir = (Boolean)state.getValue((Property)ModernLampHalfPanelBlock.HORIZONTAL) != false ? "h" : "v";
            String variant = color.getName() + "_" + dir;
            if (((Direction)state.getValue((Property)ModernLampPanelBlock.FACING)).getAxis().isHorizontal()) {
                variant = variant + "_vertical";
            }
            if (((Boolean)state.getValue((Property)ModernLampPanelBlock.LIT)).booleanValue()) {
                variant = variant + "_powered";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + name + "/" + variant))).rotationX((xRotation + 360) % 360).rotationY((yRotation + 360) % 360).build();
        })).item().tag(new TagKey[]{tag.itemTag()}).transform(ModelGen.customItemModel((String[])new String[]{name, color.getName() + "_h"}));
    }

    public static <B extends SmallModernLampPanelBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> modernLampSmallPanel(DyeColor color, String name, BlazingTags.Blocks tag) {
        String tagName = name.replace('/', '_') + "s";
        return b -> (BlockBuilder)b.tag(new TagKey[]{tag.tag()}).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)ModernLampPanelBlock.FACING);
            int xRotation = facing == Direction.DOWN ? 180 : 0;
            int yRotation = facing.getAxis().isVertical() ? 0 : (int)facing.toYRot();
            Object variant = color.getName();
            if (((Direction)state.getValue((Property)ModernLampPanelBlock.FACING)).getAxis().isHorizontal()) {
                variant = (String)variant + "_vertical";
            }
            if (((Boolean)state.getValue((Property)ModernLampPanelBlock.LIT)).booleanValue()) {
                variant = (String)variant + "_powered";
            }
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + name + "/" + (String)variant))).rotationX((xRotation + 360) % 360).rotationY((yRotation + 360) % 360).build();
        })).item().tag(new TagKey[]{tag.itemTag()}).transform(ModelGen.customItemModel((String[])new String[]{name, color.getName()}));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> simpleBlockState() {
        return b -> b.blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0])));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> castingDepotModel() {
        return b -> (BlockBuilder)b.blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)CastingDepotBlock.POWERED) != false ? AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"powered"}) : AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[0])).build())).item().model((c, p) -> p.withExistingParent(c.getName(), BlazingHot.asResource("block/" + c.getName() + "/block"))).build();
    }

    public static <I extends Item, P> NonNullUnaryOperator<ItemBuilder<I, P>> handheld() {
        return b -> b.model((c, p) -> p.handheld((NonNullSupplier)c));
    }

    public static <I extends Item, P> NonNullUnaryOperator<ItemBuilder<I, P>> existingParent(ResourceLocation parent) {
        return b -> b.model((c, p) -> p.withExistingParent(c.getName(), parent));
    }

    public static <T extends Item, P> NonNullUnaryOperator<ItemBuilder<T, P>> mold(String name, Molds.MoldType type) {
        return b -> b.tag(new TagKey[]{BlazingTags.Items.MOLDS.tag(), type.tag}).properties(p -> {
            if (type.fireResistant) {
                p.fireResistant();
            }
            return p;
        }).model((c, p) -> p.generated(() -> ((DataGenContext)c).get(), new ResourceLocation[]{BlazingHot.asResource("item/" + type.name + "_mold/" + name)}));
    }
}

