/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.foundation.recipe;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.data.conditions.LoadCondition;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiFluidIngredient;
import com.dudko.blazinghot.foundation.recipe.neoforge.IBlazingRecipeBuilderImpl;
import com.google.common.base.Joiner;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface IBlazingRecipeBuilder<P extends ProcessingRecipeParams, R extends ProcessingRecipe<?, P>, S extends IBlazingRecipeBuilder<P, R, S>> {
    default public S cast() {
        return (S)this;
    }

    public R build();

    public S require(Ingredient var1);

    public S require(SizedFluidIngredient var1);

    public S output(Fluid var1, MultiAmount var2);

    public S requireMultiple(Ingredient var1, int var2);

    public S withConditions(List<LoadCondition<?>> var1);

    public List<LoadCondition<?>> getLoadConditions();

    public ResourceLocation getRecipeId();

    public boolean isMechanicalMixerOnly();

    default public S require(TagKey<Fluid> fluidTag, MultiAmount amount) {
        return this.require(MultiFluidIngredient.fromTag(fluidTag, amount));
    }

    default public S require(Fluid fluid, MultiAmount amount) {
        return this.require(MultiFluidIngredient.fromFluid((Holder<Fluid>)BuiltInRegistries.FLUID.wrapAsHolder((Object)fluid), amount));
    }

    default public S requireMultiple(TagKey<Item> tag, int amount) {
        return this.requireMultiple(Ingredient.of(tag), amount);
    }

    default public S requireMultiple(ItemLike item, int amount) {
        return this.requireMultiple(Ingredient.of((ItemLike[])new ItemLike[]{item}), amount);
    }

    default public S withConditions(LoadCondition<?> ... conditions) {
        return this.withConditions(List.of(conditions));
    }

    default public void build(RecipeOutput consumer) {
        List errors;
        R recipe = this.build();
        IRecipeTypeInfo recipeType = recipe.getTypeInfo();
        ResourceLocation typeId = recipeType.getId();
        ResourceLocation id = this.getRecipeId().withPrefix(typeId.getPath() + "/");
        if (this.isMechanicalMixerOnly()) {
            id = id.withSuffix("_mixer_only");
        }
        if (!(errors = recipe.validate()).isEmpty()) {
            errors.add(recipe.getClass().getSimpleName() + "with id " + String.valueOf(id) + " failed validation:");
            BlazingHot.LOGGER.warn(Joiner.on((char)'\n').join((Iterable)errors));
        }
        IBlazingRecipeBuilder.finishBuild(consumer, id, recipe, this.getLoadConditions());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <P extends ProcessingRecipeParams, R extends ProcessingRecipe<?, P>> void finishBuild(RecipeOutput consumer, ResourceLocation id, R recipe, List<LoadCondition<?>> loadConditions) {
        void var3_3;
        void var2_2;
        void var1_1;
        IBlazingRecipeBuilderImpl.finishBuild(consumer, (ResourceLocation)var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <P extends ProcessingRecipeParams, R extends ProcessingRecipe<?, P>, S extends ProcessingRecipeBuilder<P, R, S>> S fluidOutput(S builder, Fluid fluid, MultiAmount amount) {
        void var2_2;
        void var1_1;
        return IBlazingRecipeBuilderImpl.fluidOutput(builder, (Fluid)var1_1, (MultiAmount)var2_2);
    }
}

