/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.gui.ponder;

import com.dudko.blazinghot.gui.ponder.BlazingPonderTags;
import com.dudko.blazinghot.gui.ponder.neoforge.BlazingPonderScenesImpl;
import com.dudko.blazinghot.gui.ponder.scenes.CastingScenes;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredHolder;

public class BlazingPonderScenes {
    public static void register(PonderSceneRegistrationHelper<ResourceLocation> helper) {
        PonderSceneRegistrationHelper HELPER = helper.withKeyFunction(DeferredHolder::getId);
        HELPER.forComponents((Object[])new ItemProviderEntry[]{BlazingBlocks.CASTING_DEPOT}).addStoryBoard("casting/spout", CastingScenes::castingBySpout, new ResourceLocation[]{BlazingPonderTags.CASTING_RELATED}).addStoryBoard("casting/molds", CastingScenes::molds).addStoryBoard("casting/air_current", CastingScenes::airCurrent).addStoryBoard("casting/automating", CastingScenes::automating);
    }

    public static void setFluidInTank(SceneBuilder builder, BlockPos pos, Fluid fluid, long amount) {
        builder.addInstruction(scene -> {
            PonderLevel world = scene.getWorld();
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (!(blockEntity instanceof SmartBlockEntity)) {
                return;
            }
            SmartBlockEntity smartBlockEntity = (SmartBlockEntity)blockEntity;
            if (smartBlockEntity instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tank = (FluidTankBlockEntity)smartBlockEntity;
                BlazingPonderScenes.setFluidInTank(tank, fluid, amount);
                return;
            }
            SmartFluidTankBehaviour tank = (SmartFluidTankBehaviour)smartBlockEntity.getBehaviour(SmartFluidTankBehaviour.TYPE);
            if (tank == null) {
                return;
            }
            BlazingPonderScenes.setFluidInTank(tank, fluid, amount);
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setFluidInTank(SmartFluidTankBehaviour tank, Fluid fluid, long amount) {
        void var2_2;
        void var1_1;
        BlazingPonderScenesImpl.setFluidInTank(tank, (Fluid)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setFluidInTank(FluidTankBlockEntity tank, Fluid fluid, long amount) {
        void var2_2;
        void var1_1;
        BlazingPonderScenesImpl.setFluidInTank(tank, (Fluid)var1_1, (long)var2_2);
    }
}

