/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.neoforge;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.data.NeoForgeTagGen;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.data.lang.BlazingLangGen;
import com.dudko.blazinghot.data.recipe.SequencedAssemblyRecipeGen;
import com.dudko.blazinghot.data.recipe.StandardRecipeGen;
import com.dudko.blazinghot.foundation.recipe.BlazingRecipeProvider;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlazingHotDataNeoForge {
    private static final CreateRegistrate REGISTRATE = BlazingHot.registrate();

    public static void gatherDataHighPriority(GatherDataEvent event) {
        if (event.getMods().contains("blazinghot")) {
            BlazingHotDataNeoForge.addExtraRegistrateData();
        }
    }

    public static void gatherData(GatherDataEvent event) {
        if (!event.getMods().contains("blazinghot")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new BlazingAdvancements(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new StandardRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new SequencedAssemblyRecipeGen(output, lookupProvider));
        if (event.includeServer()) {
            BlazingRecipeProvider.registerAllProcessing(output, lookupProvider);
            generator.addProvider(event.includeServer(), new DataProvider(){

                public String getName() {
                    return "Create: Blazing Hot's Processing Recipes";
                }

                public CompletableFuture<?> run(CachedOutput dc) {
                    return CompletableFuture.allOf((CompletableFuture[])BlazingRecipeProvider.GENERATORS.stream().map(gen -> gen.run(dc)).toArray(CompletableFuture[]::new));
                }
            });
        }
    }

    private static void addExtraRegistrateData() {
        REGISTRATE.addDataGenerator(ProviderType.LANG, BlazingLangGen::generate);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, NeoForgeTagGen::generateBlockTags);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, NeoForgeTagGen::generateItemTags);
        REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, NeoForgeTagGen::generateFluidTags);
    }
}

