/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.config.CStress;
import com.dudko.blazinghot.content.block.modern_lamp.AbstractModernLamp;
import com.dudko.blazinghot.content.block.modern_lamp.AbstractModernLampPanel;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampDoublePanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampHalfPanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampPanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampQuadPanelBlock;
import com.dudko.blazinghot.content.block.modern_lamp.SmallModernLampPanelBlock;
import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlock;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.BlazeMixerBlock;
import com.dudko.blazinghot.data.lang.ItemDescriptions;
import com.dudko.blazinghot.foundation.multiloader.BlazingBuilderTransformers;
import com.dudko.blazinghot.registry.BlazingCreativeTabs;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.registry.BlazingSpriteShifts;
import com.dudko.blazinghot.registry.BlazingTags;
import com.dudko.blazinghot.util.DyeUtil;
import com.dudko.blazinghot.util.LangUtil;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.processing.AssemblyOperatorBlockItem;
import com.simibubi.create.foundation.block.DyedBlockList;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class BlazingBlocks {
    private static final CreateRegistrate REGISTRATE = BlazingHot.registrate();
    public static final BlockEntry<CasingBlock> BLAZE_CASING;
    public static final BlockEntry<CasingBlock> STURDY_CASING;
    public static final BlockEntry<CastingDepotBlock> CASTING_DEPOT;
    public static final BlockEntry<BlazeMixerBlock> BLAZE_MIXER;
    public static final BlockEntry<Block> BLAZE_GOLD_BLOCK;
    public static final DyedBlockList<ModernLampBlock> MODERN_LAMP_BLOCKS;
    public static final DyedBlockList<ModernLampPanelBlock> MODERN_LAMP_PANELS;
    public static final DyedBlockList<ModernLampDoublePanelBlock> MODERN_LAMP_DOUBLE_PANELS;
    public static final DyedBlockList<ModernLampQuadPanelBlock> MODERN_LAMP_QUAD_PANELS;
    public static final DyedBlockList<ModernLampHalfPanelBlock> MODERN_LAMP_HALF_PANELS;
    public static final DyedBlockList<SmallModernLampPanelBlock> MODERN_LAMP_SMALL_PANELS;

    public static void register() {
    }

    public static <T extends AbstractModernLamp> BlockEntry<T>[] modernLamps() {
        ArrayList entries = new ArrayList();
        List<DyedBlockList<SmallModernLampPanelBlock>> lists = List.of(MODERN_LAMP_BLOCKS, MODERN_LAMP_PANELS, MODERN_LAMP_DOUBLE_PANELS, MODERN_LAMP_QUAD_PANELS, MODERN_LAMP_HALF_PANELS, MODERN_LAMP_SMALL_PANELS);
        for (DyeColor color : DyeColor.values()) {
            lists.forEach(list -> entries.add(list.get(color)));
        }
        return entries.toArray(new BlockEntry[0]);
    }

    private static ItemLike[] lampPanels(DyeColor color) {
        ArrayList items = new ArrayList();
        List<DyedBlockList<ModernLampQuadPanelBlock>> panelLists = List.of(MODERN_LAMP_PANELS, MODERN_LAMP_DOUBLE_PANELS, MODERN_LAMP_QUAD_PANELS);
        panelLists.forEach(list -> items.add(list.get(color)));
        return items.toArray(new ItemLike[0]);
    }

    private static <T extends AbstractModernLampPanel> void panelStoneCuttingRecipe(DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov, DyeColor color) {
        BlazingBlocks.panelStoneCuttingRecipe(ctx, prov, color, ctx.getName(), 1);
    }

    private static <T extends AbstractModernLampPanel> void panelStoneCuttingRecipe(DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov, DyeColor color, String name, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])BlazingBlocks.lampPanels(color)), (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ctx.get()), (int)count).unlockedBy("has_modern_lamps", RegistrateRecipeProvider.has(BlazingTags.Blocks.MODERN_LAMP_BLOCKS.itemTag())).save((RecipeOutput)prov, BlazingHot.asResource("stonecutting/modern_lamp_panel/" + name));
    }

    private static <T extends AbstractModernLamp> void lampStoneCuttingRecipe(DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov, DyeColor color, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{MODERN_LAMP_BLOCKS.get(color)}), (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ctx.get()), (int)count).unlockedBy("has_modern_lamps", RegistrateRecipeProvider.has(BlazingTags.Blocks.MODERN_LAMP_BLOCKS.itemTag())).save((RecipeOutput)prov, BlazingHot.asResource("stonecutting/modern_lamp/" + ctx.getName() + "_from_block"));
    }

    private static <T extends AbstractModernLamp> void modernLampDyeing(DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov, TagKey<Item> tag, DyeColor color, String name) {
        DyeUtil.dyeingMultiple(RecipeCategory.REDSTONE, tag, (ItemLike)ctx.get(), color).save((RecipeOutput)prov, BlazingHot.asResource("crafting/modern_lamp/" + name + "/" + ctx.getName() + "_from_other_lamps"));
        DyeUtil.dyeingSingle(RecipeCategory.REDSTONE, tag, (ItemLike)ctx.get(), color).save((RecipeOutput)prov, BlazingHot.asResource("crafting/modern_lamp/" + name + "/" + ctx.getName() + "_from_other_lamp"));
    }

    static {
        BlazingCreativeTabs.useBaseTab();
        BLAZE_CASING = ((BlockBuilder)REGISTRATE.block("blaze_casing", CasingBlock::new).transform((NonNullFunction)BuilderTransformers.casing(() -> BlazingSpriteShifts.BLAZE_CASING))).properties(p -> p.mapColor(MapColor.CRIMSON_NYLIUM).sound(SoundType.NETHER_WOOD)).register();
        STURDY_CASING = ((BlockBuilder)REGISTRATE.block("sturdy_casing", CasingBlock::new).transform((NonNullFunction)BuilderTransformers.casing(() -> BlazingSpriteShifts.STURDY_CASING))).properties(p -> p.mapColor(MapColor.COLOR_BLACK).sound(SoundType.NETHERITE_BLOCK).explosionResistance(1200.0f)).register();
        CASTING_DEPOT = ((BlockBuilder)REGISTRATE.block("casting_depot", CastingDepotBlock::new).initialProperties(STURDY_CASING).transform(BlazingBuilderTransformers.castingDepotModel())).register();
        BLAZE_MIXER = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("blaze_mixer", BlazeMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.STONE)).transform(TagGen.axeOrPickaxe())).transform(BlazingBuilderTransformers.simpleBlockState())).transform(CStress.setImpact(4.0))).item(AssemblyOperatorBlockItem::new).onRegisterAfter(Registries.ITEM, v -> ItemDescription.useKey((ItemLike)v, (String)ItemDescriptions.BLAZE_MIXER.getKey()))).transform(ModelGen.customItemModel())).register();
        BlazingCreativeTabs.useBuildingTab();
        BLAZE_GOLD_BLOCK = ((BlockBuilder)REGISTRATE.block("blaze_gold_block", Block::new).initialProperties(() -> Blocks.GOLD_BLOCK).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).tag(new TagKey[]{BlockTags.BEACON_BASE_BLOCKS}).tag(new TagKey[]{BlazingTags.Blocks.BLAZE_GOLD_BLOCKS.tag()}).item().tag(new TagKey[]{BlazingTags.Items.STORAGE_BLOCKS.tag()}).tag(new TagKey[]{BlazingTags.Blocks.BLAZE_GOLD_BLOCKS.itemTag()}).build()).register();
        MODERN_LAMP_BLOCKS = new DyedBlockList(color -> {
            String colorName = color.getSerializedName();
            return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_modern_lamp", p -> new ModernLampBlock((BlockBehaviour.Properties)p, (DyeColor)color)).transform(BlazingBuilderTransformers.anyModernLamp(color))).transform(BlazingBuilderTransformers.modernLampBlock(color, BlazingTags.Blocks.MODERN_LAMP_BLOCKS))).recipe((c, p) -> {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)c.get()), (int)2).pattern(" g ").pattern("glg").pattern(" r ").define(Character.valueOf('g'), (ItemLike)DyeUtil.getStainedGlass(color)).define(Character.valueOf('l'), (ItemLike)Blocks.GLOWSTONE).define(Character.valueOf('r'), BlazingItems.BLAZE_GOLD_ROD).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)BlazingItems.BLAZE_GOLD_ROD.asItem()).getPath(), RegistrateRecipeProvider.has(BlazingItems.BLAZE_GOLD_ROD)).save((RecipeOutput)p, BlazingHot.asResource("crafting/modern_lamp/" + c.getName() + "_from_stained_glass"));
                BlazingBlocks.modernLampDyeing(c, p, BlazingTags.Blocks.MODERN_LAMP_BLOCKS.itemTag(), color, "block");
            }).register();
        });
        MODERN_LAMP_PANELS = new DyedBlockList(color -> {
            String colorName = color.getSerializedName();
            return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_modern_lamp_panel", p -> new ModernLampPanelBlock((BlockBehaviour.Properties)p, (DyeColor)color)).transform(BlazingBuilderTransformers.anyModernLamp(color))).transform(BlazingBuilderTransformers.modernLampPanel(color, "modern_lamp/panel", BlazingTags.Blocks.MODERN_LAMP_PANELS))).recipe((c, p) -> {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)c.get()), (int)4).pattern("ll").define(Character.valueOf('l'), (ItemLike)MODERN_LAMP_BLOCKS.get(color)).unlockedBy("has_modern_lamps", RegistrateRecipeProvider.has(BlazingTags.Blocks.MODERN_LAMP_PANELS.itemTag())).save((RecipeOutput)p, BlazingHot.asResource("crafting/modern_lamp/panel/" + c.getName() + "_from_full_block"));
                BlazingBlocks.panelStoneCuttingRecipe(c, p, color);
                BlazingBlocks.lampStoneCuttingRecipe(c, p, color, 2);
                BlazingBlocks.modernLampDyeing(c, p, BlazingTags.Blocks.MODERN_LAMP_PANELS.itemTag(), color, "panel");
            }).register();
        });
        MODERN_LAMP_DOUBLE_PANELS = new DyedBlockList(color -> {
            String colorName = color.getSerializedName();
            return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_modern_lamp_double_panel", p -> new ModernLampDoublePanelBlock((BlockBehaviour.Properties)p, (DyeColor)color)).transform(BlazingBuilderTransformers.anyModernLamp(color))).transform(BlazingBuilderTransformers.modernLampDirectionalPanel(color, "modern_lamp/double_panel", BlazingTags.Blocks.MODERN_LAMP_DOUBLE_PANELS))).recipe((c, p) -> {
                BlazingBlocks.panelStoneCuttingRecipe(c, p, color);
                BlazingBlocks.lampStoneCuttingRecipe(c, p, color, 2);
                BlazingBlocks.modernLampDyeing(c, p, BlazingTags.Blocks.MODERN_LAMP_DOUBLE_PANELS.itemTag(), color, "double_panel");
            }).register();
        });
        MODERN_LAMP_QUAD_PANELS = new DyedBlockList(color -> {
            String colorName = color.getSerializedName();
            return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_modern_lamp_quad_panel", p -> new ModernLampQuadPanelBlock((BlockBehaviour.Properties)p, (DyeColor)color)).transform(BlazingBuilderTransformers.anyModernLamp(color))).transform(BlazingBuilderTransformers.modernLampPanel(color, "modern_lamp/quad_panel", BlazingTags.Blocks.MODERN_LAMP_QUAD_PANELS))).recipe((c, p) -> {
                BlazingBlocks.panelStoneCuttingRecipe(c, p, color);
                BlazingBlocks.modernLampDyeing(c, p, BlazingTags.Blocks.MODERN_LAMP_QUAD_PANELS.itemTag(), color, "quad_panel");
                BlazingBlocks.lampStoneCuttingRecipe(c, p, color, 2);
            }).register();
        });
        MODERN_LAMP_HALF_PANELS = new DyedBlockList(color -> {
            String colorName = color.getSerializedName();
            return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_modern_lamp_half_panel", p -> new ModernLampHalfPanelBlock((BlockBehaviour.Properties)p, (DyeColor)color)).transform(BlazingBuilderTransformers.anyModernLamp(color))).transform(BlazingBuilderTransformers.modernLampHalfPanel(color, "modern_lamp/half_panel", BlazingTags.Blocks.MODERN_LAMP_HALF_PANELS))).recipe((c, p) -> {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)c.get()), (int)4).pattern("ll").define(Character.valueOf('l'), (ItemLike)MODERN_LAMP_PANELS.get(color)).unlockedBy("has_modern_lamps", RegistrateRecipeProvider.has(BlazingTags.Blocks.MODERN_LAMP_BLOCKS.itemTag())).save((RecipeOutput)p, BlazingHot.asResource("crafting/modern_lamp/half_panel/" + c.getName() + "_from_panel"));
                BlockEntry doublePanel = MODERN_LAMP_DOUBLE_PANELS.get(color);
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)doublePanel).requires((ItemLike)c.get(), 2).unlockedBy("has_modern_lamps", RegistrateRecipeProvider.has(BlazingTags.Blocks.MODERN_LAMP_BLOCKS.itemTag())).save((RecipeOutput)p, BlazingHot.asResource("crafting/modern_lamp/panel/" + BuiltInRegistries.ITEM.getKey((Object)doublePanel.asItem()).getPath() + "_from_half_panels"));
                BlazingBlocks.lampStoneCuttingRecipe(c, p, color, 2);
                BlazingBlocks.panelStoneCuttingRecipe(c, p, color, c.getName() + "_from_panel", 2);
                BlazingBlocks.modernLampDyeing(c, p, BlazingTags.Blocks.MODERN_LAMP_HALF_PANELS.itemTag(), color, "half_panel");
            }).register();
        });
        MODERN_LAMP_SMALL_PANELS = new DyedBlockList(color -> {
            String colorName = color.getSerializedName();
            return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_modern_lamp_small_panel", p -> new SmallModernLampPanelBlock((BlockBehaviour.Properties)p, (DyeColor)color)).lang(LangUtil.titleCaseConversion(colorName.replace('_', ' ')) + " Small Modern Lamp Panel").transform(BlazingBuilderTransformers.anyModernLamp(color))).transform(BlazingBuilderTransformers.modernLampSmallPanel(color, "modern_lamp/small_panel", BlazingTags.Blocks.MODERN_LAMP_SMALL_PANELS))).recipe((c, p) -> {
                BlockEntry quadPanel = MODERN_LAMP_QUAD_PANELS.get(color);
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)quadPanel).requires((ItemLike)c.get(), 4).unlockedBy("has_modern_lamps", RegistrateRecipeProvider.has(BlazingTags.Blocks.MODERN_LAMP_BLOCKS.itemTag())).save((RecipeOutput)p, BlazingHot.asResource("crafting/modern_lamp/panel/" + BuiltInRegistries.ITEM.getKey((Object)quadPanel.asItem()).getPath() + "_from_small_panels"));
                BlazingBlocks.lampStoneCuttingRecipe(c, p, color, 4);
                BlazingBlocks.modernLampDyeing(c, p, BlazingTags.Blocks.MODERN_LAMP_SMALL_PANELS.itemTag(), color, "small_panel");
                BlazingBlocks.panelStoneCuttingRecipe(c, p, color, c.getName() + "_from_panel", 4);
            }).register();
        });
    }
}

