/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry;

import com.dudko.blazinghot.compat.Mods;
import com.dudko.blazinghot.content.casting.Molds;
import com.dudko.blazinghot.content.metal.BlazingForm;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.util.NullableSupplier;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BlazingForms {
    public static BlazingForm INGOT = BlazingForm.create("ingot", b -> b.withAmount(MultiAmount.INGOT).withTagFolder("ingots").withMeltingTime(200).mechanicalMixerMeltable(true).withMold(Molds.INGOT));
    public static BlazingForm NUGGET = BlazingForm.create("nugget", b -> b.withAmount(MultiAmount.NUGGET).withTagFolder("nuggets").withMeltingTime(30).mechanicalMixerMeltable(true).withMold(Molds.NUGGET));
    public static BlazingForm SHEET = INGOT.createFrom("sheet", b -> b.withTagFolder("plates").withMold(Molds.SHEET));
    public static BlazingForm OPTIONAL_ROD = BlazingForm.create("rod", b -> b.withAmount(MultiAmount.ROD).withTagFolder("rods").withMeltingTime(125).mechanicalMixerMeltable(true).withMold(Molds.ROD).optional(true).setFlags(BlazingForm.Flag.MELTING));
    public static BlazingForm OPTIONAL_WIRE = OPTIONAL_ROD.createFrom("wire", b -> b.withTagFolder("wires"));
    public static BlazingForm OPTIONAL_SHEET = SHEET.withFlags(BlazingForm.Flag.MELTING).asOptional(true);
    public static BlazingForm ANCIENT_DEBRIS = BlazingForm.create("ancient_debris", b -> b.withAmount(MultiAmount.RAW_ORE).withMeltingTime(300).withCustomItem((ItemLike)Items.ANCIENT_DEBRIS));
    public static BlazingForm NETHERITE_SCRAP = INGOT.createFrom("netherite_scrap", b -> b.withCustomItem((ItemLike)Items.NETHERITE_SCRAP).mechanicalMixerMeltable(false));
    public static BlazingForm NETHERITE_INGOT = INGOT.createFrom("ingot", b -> b.mechanicalMixerMeltable(false));
    public static BlazingForm RAW_IRON = BlazingForms.rawOre(() -> Items.RAW_IRON, new Mods[0]);
    public static BlazingForm RAW_GOLD = BlazingForms.rawOre((ItemLike)Items.RAW_GOLD, new Mods[0]);
    public static BlazingForm RAW_COPPER = BlazingForms.rawOre((ItemLike)Items.RAW_COPPER, new Mods[0]);
    public static BlazingForm RAW_ZINC = BlazingForms.rawOre("raw_zinc", () -> BlazingForms.getItemKey((ItemLike)AllItems.RAW_ZINC), new Mods[0]);
    public static BlazingForm CRUSHED_RAW_IRON = BlazingForms.rawOre("crushed_raw_iron", () -> BlazingForms.getItemKey((ItemLike)AllItems.CRUSHED_IRON), new Mods[0]);
    public static BlazingForm CRUSHED_RAW_GOLD = BlazingForms.rawOre("crushed_raw_gold", () -> BlazingForms.getItemKey((ItemLike)AllItems.CRUSHED_GOLD), new Mods[0]);
    public static BlazingForm CRUSHED_RAW_COPPER = BlazingForms.rawOre("crushed_raw_copper", () -> BlazingForms.getItemKey((ItemLike)AllItems.CRUSHED_COPPER), new Mods[0]);
    public static BlazingForm CRUSHED_RAW_ZINC = BlazingForms.rawOre("crushed_raw_zinc", () -> BlazingForms.getItemKey((ItemLike)AllItems.CRUSHED_ZINC), new Mods[0]);
    public static BlazingForm ANDESITE_ALLOY = INGOT.createFrom("andesite_alloy", b -> b.withCustomItem(() -> BlazingForms.getItemKey((ItemLike)AllItems.ANDESITE_ALLOY)));
    public static BlazingForm CREATE_NUGGET = NUGGET.withFlags(BlazingForm.Flag.MELTING).asOptional(true);
    public static BlazingForm COPPER_NUGGET = NUGGET.withFlags(BlazingForm.Flag.CASTING).fromMods(Mods.CREATE);
    public static BlazingForm GOLDEN_SHEET = SHEET.createFrom("golden_sheet", b -> b.withCustomItem(() -> Create.asResource((String)"golden_sheet")));
    public static BlazingForm CREATE_SHEET = SHEET.fromMods(Mods.CREATE);
    public static BlazingForm ROD = OPTIONAL_ROD.withFlags(BlazingForm.Flag.MELTING, BlazingForm.Flag.CASTING).asOptional(false);
    public static BlazingForm STURDY_ALLOY = INGOT.createFrom("sturdy_alloy", b -> b.withCustomItem((ItemLike)BlazingItems.STURDY_ALLOY).mechanicalMixerMeltable(false));
    public static BlazingForm STURDY_SHEET = SHEET.createFrom("sturdy_sheet", b -> b.withCustomItem(() -> BlazingForms.getItemKey((ItemLike)AllItems.STURDY_SHEET)).mechanicalMixerMeltable(false));
    public static BlazingForm STURDY_MOLD = INGOT.createFrom("sturdy_mold", b -> b.withAmount(MultiAmount.INGOT.multiply(2.0f)).withMeltingTime(300));
    public static BlazingForm COMPAT_ROD = ROD.withFlags(BlazingForm.Flag.CASTING).fromMods(Mods.CREATE_ADDITIONS);
    public static BlazingForm COMPAT_WIRE = OPTIONAL_WIRE.asOptional(false).withFlags(BlazingForm.Flag.CASTING).fromMods(Mods.CREATE_ADDITIONS);
    public static BlazingForm ZINC_SHEET = SHEET.withFlags(BlazingForm.Flag.CASTING).fromMods(Mods.CREATE_ADDITIONS);

    private static ResourceLocation getItemKey(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem());
    }

    public static BlazingForm rawOre(ItemLike item, Mods ... mods) {
        ResourceLocation key = BlazingForms.getItemKey(item);
        return BlazingForms.rawOre(key.getPath(), () -> key, mods);
    }

    public static BlazingForm rawOre(String name, NullableSupplier<ResourceLocation> rawOre, Mods ... mods) {
        return BlazingForm.create(name, b -> b.withAmount(MultiAmount.RAW_ORE).withCustomItem(rawOre).withMeltingTime(250).fromMods(mods).setFlags(BlazingForm.Flag.MELTING).mechanicalMixerMeltable(false).overrideFuelCost(MultiAmount.fromBucketFraction(1L, 20L)));
    }
}

