/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.content.casting.Molds;
import com.dudko.blazinghot.content.item.BlazeArrowItem;
import com.dudko.blazinghot.content.item.food.BlazingFoodItem;
import com.dudko.blazinghot.content.item.food.StandardFoodBuilders;
import com.dudko.blazinghot.data.lang.ItemDescriptions;
import com.dudko.blazinghot.foundation.multiloader.BlazingBuilderTransformers;
import com.dudko.blazinghot.registry.BlazingCreativeTabs;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.api.data.datamaps.BlazeBurnerFuel;
import com.simibubi.create.api.registry.CreateDataMaps;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class BlazingItems {
    private static final CreateRegistrate REGISTRATE = BlazingHot.registrate();
    public static final List<ItemLike> METAL_FOOD = new ArrayList<ItemLike>();
    public static final ItemEntry<Item> BLAZE_GOLD_INGOT;
    public static final ItemEntry<Item> BLAZE_GOLD_NUGGET;
    public static final ItemEntry<Item> BLAZE_GOLD_SHEET;
    public static final ItemEntry<Item> BLAZE_GOLD_ROD;
    public static final ItemEntry<Item> BLAZE_WHISK;
    public static final ItemEntry<Item> STURDY_ALLOY;
    public static final ItemEntry<Item> NETHER_DOUGH;
    public static final ItemEntry<Item> BLAZE_ROLL;
    public static final ItemEntry<SequencedAssemblyItem> INCOMPLETE_BLAZE_MIXER;
    public static final ItemEntry<Item> NETHERRACK_DUST;
    public static final ItemEntry<Item> STONE_DUST;
    public static final ItemEntry<Item> SOUL_DUST;
    public static final ItemEntry<Item> NETHER_COMPOUND;
    public static final ItemEntry<Item> NETHER_ESSENCE;
    public static final ItemEntry<BlazeArrowItem> BLAZE_ARROW;
    public static final ItemEntry<BlazingFoodItem> STELLAR_GOLDEN_APPLE;
    public static final ItemEntry<BlazingFoodItem> IRON_CARROT;
    public static final ItemEntry<BlazingFoodItem> IRON_APPLE;
    public static final ItemEntry<BlazingFoodItem> STELLAR_IRON_APPLE;
    public static final ItemEntry<BlazingFoodItem> ENCHANTED_IRON_APPLE;
    public static final ItemEntry<BlazingFoodItem> BLAZE_CARROT;
    public static final ItemEntry<BlazingFoodItem> BLAZE_APPLE;
    public static final ItemEntry<BlazingFoodItem> STELLAR_BLAZE_APPLE;
    public static final ItemEntry<BlazingFoodItem> ENCHANTED_BLAZE_APPLE;
    public static final ItemEntry<BlazingFoodItem> COPPER_CARROT;
    public static final ItemEntry<BlazingFoodItem> COPPER_APPLE;
    public static final ItemEntry<BlazingFoodItem> STELLAR_COPPER_APPLE;
    public static final ItemEntry<BlazingFoodItem> ENCHANTED_COPPER_APPLE;
    public static final ItemEntry<BlazingFoodItem> ZINC_CARROT;
    public static final ItemEntry<BlazingFoodItem> ZINC_APPLE;
    public static final ItemEntry<BlazingFoodItem> STELLAR_ZINC_APPLE;
    public static final ItemEntry<BlazingFoodItem> ENCHANTED_ZINC_APPLE;
    public static final ItemEntry<BlazingFoodItem> BRASS_CARROT;
    public static final ItemEntry<BlazingFoodItem> BRASS_APPLE;
    public static final ItemEntry<BlazingFoodItem> STELLAR_BRASS_APPLE;
    public static final ItemEntry<BlazingFoodItem> ENCHANTED_BRASS_APPLE;
    public static final ItemEntry<BlazingFoodItem> ENCHANTED_NETHERITE_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> HEAVY_STELLAR_IRON_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> GILDED_STELLAR_GOLDEN_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> BURNING_STELLAR_BLAZE_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> COATED_STELLAR_COPPER_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> GALVANIZED_STELLAR_ZINC_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> BRASSY_STELLAR_BRASS_APPLE;
    public static final ItemEntry<SequencedAssemblyItem> ANCIENT_ENCHANTED_APPLE;

    private static ItemEntry<Item> ingredient(String name) {
        return REGISTRATE.item(name, Item::new).register();
    }

    private static ItemEntry<SequencedAssemblyItem> sequencedIngredient(String name) {
        return BlazingItems.sequencedIngredient(name, Rarity.COMMON);
    }

    private static ItemEntry<SequencedAssemblyItem> sequencedIngredient(String name, Rarity rarity) {
        return REGISTRATE.item(name, SequencedAssemblyItem::new).properties(p -> p.rarity(rarity)).register();
    }

    @SafeVarargs
    private static ItemEntry<Item> taggedIngredient(String name, TagKey<Item> ... tags) {
        return REGISTRATE.item(name, Item::new).tag(tags).register();
    }

    public static void register() {
        METAL_FOOD.addAll(List.of(Items.GOLDEN_CARROT, Items.GOLDEN_APPLE, Items.ENCHANTED_GOLDEN_APPLE));
    }

    static {
        BlazingCreativeTabs.useBaseTab();
        Molds.register();
        BLAZE_GOLD_INGOT = BlazingItems.taggedIngredient("blaze_gold_ingot", BlazingTags.Items.BLAZE_GOLD_INGOTS.tag(), BlazingTags.Items.INGOTS.tag(), ItemTags.BEACON_PAYMENT_ITEMS);
        BLAZE_GOLD_NUGGET = BlazingItems.taggedIngredient("blaze_gold_nugget", BlazingTags.Items.BLAZE_GOLD_NUGGETS.tag(), BlazingTags.Items.NUGGETS.tag());
        BLAZE_GOLD_SHEET = BlazingItems.taggedIngredient("blaze_gold_sheet", BlazingTags.Items.BLAZE_GOLD_PLATES.tag(), BlazingTags.Items.PLATES.tag());
        BLAZE_GOLD_ROD = ((ItemBuilder)REGISTRATE.item("blaze_gold_rod", Item::new).tag(new TagKey[]{BlazingTags.Items.BLAZE_GOLD_RODS.tag()}).tag(new TagKey[]{BlazingTags.Items.RODS.tag()}).transform(BlazingBuilderTransformers.handheld())).register();
        BLAZE_WHISK = BlazingItems.ingredient("blaze_whisk");
        STURDY_ALLOY = BlazingItems.taggedIngredient("sturdy_alloy", BlazingTags.Items.INGOTS.tag());
        NETHER_DOUGH = BlazingItems.ingredient("nether_dough");
        BLAZE_ROLL = ((ItemBuilder)((ItemBuilder)REGISTRATE.item("blaze_roll", Item::new).onRegisterAfter(Registries.ITEM, v -> ItemDescription.useKey((ItemLike)v, (String)"item.create.blaze_cake"))).dataMap(CreateDataMaps.SUPERHEATED_BLAZE_BURNER_FUELS, (Object)new BlazeBurnerFuel(2400))).burnTime(4800).register();
        INCOMPLETE_BLAZE_MIXER = ((ItemBuilder)REGISTRATE.item("incomplete_blaze_mixer", SequencedAssemblyItem::new).transform(BlazingBuilderTransformers.existingParent(BlazingHot.asResource("block/blaze_mixer/block")))).register();
        NETHERRACK_DUST = BlazingItems.taggedIngredient("netherrack_dust", BlazingTags.Items.NETHERRACK_DUSTS.tag());
        STONE_DUST = BlazingItems.taggedIngredient("stone_dust", BlazingTags.Items.STONE_DUSTS.tag());
        SOUL_DUST = BlazingItems.taggedIngredient("soul_dust", BlazingTags.Items.SOUL_SAND_DUSTS.tag());
        NETHER_COMPOUND = BlazingItems.ingredient("nether_compound");
        NETHER_ESSENCE = REGISTRATE.item("nether_essence", Item::new).lang("Crimson Essence").register();
        BLAZE_ARROW = ((ItemBuilder)REGISTRATE.item("blaze_arrow", BlazeArrowItem::new).tag(new TagKey[]{ItemTags.ARROWS}).onRegisterAfter(Registries.ITEM, v -> ItemDescription.useKey((ItemLike)v, (String)ItemDescriptions.BLAZE_ARROW.getKey()))).register();
        STELLAR_GOLDEN_APPLE = StandardFoodBuilders.stellarApple("golden", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200).effect((Holder<MobEffect>)MobEffects.REGENERATION, 400, 1).effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 3600));
        IRON_CARROT = StandardFoodBuilders.carrot("iron", b -> b.nutrition(5).saturation(0.8f));
        IRON_APPLE = StandardFoodBuilders.apple("iron", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200).effect((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 600));
        STELLAR_IRON_APPLE = StandardFoodBuilders.stellarApple("iron", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200, 1).effect((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 2400, 1).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200));
        ENCHANTED_IRON_APPLE = StandardFoodBuilders.enchantedApple("iron", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 2).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1).effect((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 3600, 2));
        BLAZE_CARROT = StandardFoodBuilders.carrot("blaze", b -> b.nutrition(6).saturation(1.2f).alwaysEat().fireResistant().extinguish());
        BLAZE_APPLE = StandardFoodBuilders.apple("blaze", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400).effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 6000).fireResistant().extinguish());
        STELLAR_BLAZE_APPLE = StandardFoodBuilders.stellarApple("blaze", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 1).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200).effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 9600).fireResistant().extinguish());
        ENCHANTED_BLAZE_APPLE = StandardFoodBuilders.enchantedApple("blaze", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 2).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1).effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 9600).effect((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 6000).fireResistant().extinguish());
        COPPER_CARROT = StandardFoodBuilders.carrot("copper", b -> b.nutrition(3).saturation(1.0f).alwaysEat().addOxygen(50));
        COPPER_APPLE = StandardFoodBuilders.apple("copper", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 600).effect((Holder<MobEffect>)MobEffects.WATER_BREATHING, 1200));
        STELLAR_COPPER_APPLE = StandardFoodBuilders.stellarApple("copper", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200, 1).effect((Holder<MobEffect>)MobEffects.WATER_BREATHING, 6000).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200));
        ENCHANTED_COPPER_APPLE = StandardFoodBuilders.enchantedApple("copper", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 2).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1).effect((Holder<MobEffect>)MobEffects.WATER_BREATHING, 9600).effect((Holder<MobEffect>)MobEffects.DOLPHINS_GRACE, 600));
        ZINC_CARROT = StandardFoodBuilders.carrot("zinc", b -> b.nutrition(5).saturation(0.8f).alwaysEat().removeSlowness(0));
        ZINC_APPLE = StandardFoodBuilders.apple("zinc", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200).effect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 600).removeSlowness(1));
        STELLAR_ZINC_APPLE = StandardFoodBuilders.stellarApple("zinc", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200, 1).effect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 3600, 1).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200).removeSlowness(2));
        ENCHANTED_ZINC_APPLE = StandardFoodBuilders.enchantedApple("zinc", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 2).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1).effect((Holder<MobEffect>)MobEffects.SLOW_FALLING, 2400).effect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 6000, 1).removeSlowness());
        BRASS_CARROT = StandardFoodBuilders.carrot("brass", b -> b.nutrition(6).saturation(1.0f).alwaysEat().effect((Holder<MobEffect>)MobEffects.DIG_SPEED, 200));
        BRASS_APPLE = StandardFoodBuilders.apple("brass", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200).effect((Holder<MobEffect>)MobEffects.DIG_SPEED, 2400));
        STELLAR_BRASS_APPLE = StandardFoodBuilders.stellarApple("brass", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 1200, 1).effect((Holder<MobEffect>)MobEffects.DIG_SPEED, 6000).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1));
        ENCHANTED_BRASS_APPLE = StandardFoodBuilders.enchantedApple("brass", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 2).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1).effect((Holder<MobEffect>)MobEffects.JUMP, 6000, 1).effect((Holder<MobEffect>)MobEffects.DIG_SPEED, 6000, 1));
        ENCHANTED_NETHERITE_APPLE = StandardFoodBuilders.enchantedApple("netherite", b -> b.effect((Holder<MobEffect>)MobEffects.ABSORPTION, 2400, 3).effect((Holder<MobEffect>)MobEffects.REGENERATION, 200, 1).effect((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 9600).effect((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 6000).effect((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, 6000, 1).fireResistant().extinguish());
        HEAVY_STELLAR_IRON_APPLE = BlazingItems.sequencedIngredient("heavy_stellar_iron_apple", Rarity.RARE);
        GILDED_STELLAR_GOLDEN_APPLE = BlazingItems.sequencedIngredient("gilded_stellar_golden_apple", Rarity.RARE);
        BURNING_STELLAR_BLAZE_APPLE = BlazingItems.sequencedIngredient("burning_stellar_blaze_apple", Rarity.RARE);
        COATED_STELLAR_COPPER_APPLE = BlazingItems.sequencedIngredient("coated_stellar_copper_apple", Rarity.RARE);
        GALVANIZED_STELLAR_ZINC_APPLE = BlazingItems.sequencedIngredient("galvanized_stellar_zinc_apple", Rarity.RARE);
        BRASSY_STELLAR_BRASS_APPLE = BlazingItems.sequencedIngredient("brassy_stellar_brass_apple", Rarity.RARE);
        ANCIENT_ENCHANTED_APPLE = BlazingItems.sequencedIngredient("ancient_enchanted_apple", Rarity.EPIC);
    }
}

