/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry;

import com.dudko.blazinghot.compat.Mods;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.registry.BlazingForms;
import com.dudko.blazinghot.registry.BlazingTags;
import com.dudko.blazinghot.util.LangUtil;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BlazingMetals {
    public static List<BlazingMetal> ALL = new ArrayList<BlazingMetal>();
    public static BlazingMetal IRON = BlazingMetal.create("iron", b -> b.createForms().withForms(BlazingForms.OPTIONAL_ROD, BlazingForms.OPTIONAL_WIRE, BlazingForms.COMPAT_ROD, BlazingForms.COMPAT_WIRE, BlazingForms.RAW_IRON, BlazingForms.CRUSHED_RAW_IRON).waterCobble()).register();
    public static BlazingMetal COPPER = BlazingMetal.create("copper", b -> b.withForms(BlazingForms.OPTIONAL_ROD, BlazingForms.OPTIONAL_WIRE, BlazingForms.COMPAT_ROD, BlazingForms.COMPAT_WIRE, BlazingForms.INGOT, BlazingForms.CREATE_SHEET, BlazingForms.CREATE_NUGGET, BlazingForms.COPPER_NUGGET, BlazingForms.RAW_COPPER, BlazingForms.CRUSHED_RAW_COPPER).waterCobble()).register();
    public static BlazingMetal GOLD = BlazingMetal.create("gold", b -> b.vanillaForms().withForms(BlazingForms.OPTIONAL_ROD, BlazingForms.OPTIONAL_WIRE, BlazingForms.COMPAT_ROD, BlazingForms.COMPAT_WIRE, BlazingForms.OPTIONAL_SHEET, BlazingForms.GOLDEN_SHEET, BlazingForms.RAW_GOLD, BlazingForms.CRUSHED_RAW_GOLD).waterCobble()).register();
    public static BlazingMetal ANCIENT_DEBRIS = BlazingMetal.create("ancient_debris", b -> b.withForms(BlazingForms.ANCIENT_DEBRIS, BlazingForms.NETHERITE_SCRAP).addFluidInteraction((Fluid)Fluids.WATER, (NonNullSupplier<Block>)((NonNullSupplier)() -> (Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get()))).register();
    public static BlazingMetal NETHERITE = BlazingMetal.create("netherite", b -> b.withForms(BlazingForms.NETHERITE_INGOT).addFluidInteraction((Fluid)Fluids.WATER, (NonNullSupplier<Block>)((NonNullSupplier)() -> (Block)AllPaletteStoneTypes.SCORCHIA.getBaseBlock().get()))).register();
    public static BlazingMetal BRASS = BlazingMetal.create("brass", b -> b.fromMods(Mods.CREATE).createForms().withForms(BlazingForms.OPTIONAL_ROD, BlazingForms.COMPAT_ROD).waterCobble()).register();
    public static BlazingMetal ANDESITE = BlazingMetal.create("andesite", b -> b.fromMods(Mods.CREATE).withForms(BlazingForms.ANDESITE_ALLOY).waterCobble()).register();
    public static BlazingMetal ZINC = BlazingMetal.create("zinc", b -> b.fromMods(Mods.CREATE).vanillaForms().withForms(BlazingForms.OPTIONAL_SHEET, BlazingForms.ZINC_SHEET, BlazingForms.RAW_ZINC, BlazingForms.CRUSHED_RAW_ZINC).waterCobble()).register();
    public static BlazingMetal BLAZE_GOLD = BlazingMetal.create("blaze_gold", b -> b.fromMods(Mods.BLAZINGHOT).createForms().withForms(BlazingForms.ROD).addFluidInteraction((Fluid)Fluids.WATER, (NonNullSupplier<Block>)((NonNullSupplier)() -> Blocks.NETHERRACK))).register();
    public static BlazingMetal STURDY_ALLOY = BlazingMetal.create("sturdy_alloy", b -> b.fromMods(Mods.BLAZINGHOT).withForms(BlazingForms.STURDY_ALLOY, BlazingForms.STURDY_SHEET).addFluidInteraction((Fluid)Fluids.WATER, (NonNullSupplier<Block>)((NonNullSupplier)() -> Blocks.COBBLED_DEEPSLATE))).register();

    public static void init() {
    }

    public static Set<Item> allBuckets(boolean includeCompat) {
        return ALL.stream().filter(m -> m.mods.getFirst().alwaysIncluded || includeCompat).map(BlazingMetal::getBucket).collect(Collectors.toSet());
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (BlazingMetal metal : ALL) {
            ResourceLocation fluidLoc = metal.getFluidTag().location();
            consumer.accept("tag.fluid." + BlazingTags.Namespace.COMMON.id + "." + fluidLoc.getPath().replace('/', '.'), LangUtil.titleCaseConversion(metal.getFluidLocation().getPath().replace('_', ' ')));
        }
    }
}

