/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry;

import com.dudko.blazinghot.util.LangUtil;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class BlazingTags {
    public static void register() {
    }

    public static <T> TagKey<T> tag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static TagKey<Block> blockTag(ResourceLocation id) {
        return BlazingTags.tag(BuiltInRegistries.BLOCK, id);
    }

    public static TagKey<Block> blockTag(String namespace, String path) {
        return BlazingTags.blockTag(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static TagKey<Item> itemTag(ResourceLocation id) {
        return BlazingTags.tag(BuiltInRegistries.ITEM, id);
    }

    public static TagKey<Item> itemTag(String namespace, String path) {
        return BlazingTags.itemTag(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static TagKey<Fluid> fluidTag(ResourceLocation id) {
        return BlazingTags.tag(BuiltInRegistries.FLUID, id);
    }

    public static TagKey<Fluid> fluidTag(String namespace, String path) {
        return BlazingTags.fluidTag(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        ResourceLocation loc;
        for (Blocks blocks : Blocks.values()) {
            if (!blocks.alwaysDatagen) continue;
            loc = blocks.tag().location();
            consumer.accept("tag.block." + loc.getNamespace() + "." + loc.getPath().replace('/', '.'), LangUtil.titleCaseConversion(blocks.name()).replace('_', ' '));
        }
        for (Enum enum_ : Items.values()) {
            if (!((Items)enum_).alwaysDatagen) continue;
            loc = ((Items)enum_).tag().location();
            consumer.accept("tag.item." + loc.getNamespace() + "." + loc.getPath().replace('/', '.'), LangUtil.titleCaseConversion(enum_.name().replace('_', ' ')));
        }
        for (Enum enum_ : Fluids.values()) {
            if (!((Fluids)enum_).alwaysDatagen) continue;
            loc = ((Fluids)enum_).tag().location();
            consumer.accept("tag.fluid." + loc.getNamespace() + "." + loc.getPath().replace('/', '.'), LangUtil.titleCaseConversion(enum_.name().replace('_', ' ')));
        }
    }

    public static enum Blocks {
        MODERN_LAMPS("modern_lamps", true),
        MODERN_LAMP_BLOCKS("modern_lamps/blocks", true),
        MODERN_LAMP_PANELS("modern_lamps/panels", true),
        MODERN_LAMP_QUAD_PANELS("modern_lamps/quad_panels", true),
        MODERN_LAMP_DOUBLE_PANELS("modern_lamps/double_panels", true),
        MODERN_LAMP_HALF_PANELS("modern_lamps/half_panels", true),
        MODERN_LAMP_SMALL_PANELS("modern_lamps/small_panels", true),
        STORAGE_BLOCKS(Namespace.COMMON, "storage_blocks", true),
        BLAZE_GOLD_BLOCKS(Namespace.COMMON, "storage_blocks/blaze_gold", true);

        public final Namespace namespace;
        public final String path;
        public final boolean item;
        public final boolean alwaysDatagen;

        private Blocks(String path) {
            this(Namespace.BLAZINGHOT, path);
        }

        private Blocks(Namespace namespace, String path) {
            this(namespace, path, false);
        }

        private Blocks(String path, boolean item) {
            this(Namespace.BLAZINGHOT, path, item);
        }

        private Blocks(Namespace namespace, String path, boolean item) {
            this(namespace, path, item, namespace.alwaysDatagenDefault);
        }

        private Blocks(Namespace namespace, String path, boolean item, boolean alwaysDatagen) {
            this.namespace = namespace;
            this.path = path;
            this.item = item;
            this.alwaysDatagen = alwaysDatagen;
        }

        public ResourceLocation resourceLocation() {
            return this.namespace.asResource(this.path);
        }

        public TagKey<Block> tag() {
            return BlazingTags.blockTag(this.resourceLocation());
        }

        public TagKey<Item> itemTag() {
            return BlazingTags.itemTag(this.resourceLocation());
        }
    }

    public static enum Items {
        NETHER_FLORA("nether_flora"),
        MOLDS("molds"),
        STURDY_MOLDS("molds/sturdy"),
        CLAY_MOLDS("molds/clay"),
        PORCELAIN_MOLDS("molds/porcelain"),
        FOODS(Namespace.COMMON, "foods"),
        METAL_FOODS("metal_foods"),
        METAL_CARROTS("metal_foods/carrots"),
        METAL_APPLES("metal_foods/apples"),
        STELLAR_METAL_APPLES("metal_foods/stelar_apples"),
        ENCHANTED_METAL_APPLES("metal_foods/enchanted_apples"),
        STORAGE_BLOCKS(Namespace.COMMON, "storage_blocks"),
        INGOTS(Namespace.COMMON, "ingots"),
        NUGGETS(Namespace.COMMON, "nuggets"),
        PLATES(Namespace.COMMON, "plates"),
        RODS(Namespace.COMMON, "rods"),
        BLAZE_GOLD_INGOTS(Namespace.COMMON, "ingots/blaze_gold", false),
        BLAZE_GOLD_NUGGETS(Namespace.COMMON, "nuggets/blaze_gold", false),
        BLAZE_GOLD_PLATES(Namespace.COMMON, "plates/blaze_gold", false),
        BLAZE_GOLD_RODS(Namespace.COMMON, "rods/blaze_gold", false),
        NETHERRACK_DUSTS(Namespace.COMMON, "dusts/netherrack"),
        STONE_DUSTS(Namespace.COMMON, "dusts/stone"),
        SOUL_SAND_DUSTS(Namespace.COMMON, "dusts/soul_sand"),
        WRENCH(Namespace.COMMON, "tools/wrench");

        public final Namespace namespace;
        public final String path;
        public final boolean alwaysDatagen;

        private Items(String path) {
            this(Namespace.BLAZINGHOT, path);
        }

        private Items(Namespace namespace, String path) {
            this(namespace, path, namespace.alwaysDatagenDefault);
        }

        private Items(Namespace namespace, String path, boolean alwaysDatagen) {
            this.namespace = namespace;
            this.path = path;
            this.alwaysDatagen = alwaysDatagen;
        }

        public ResourceLocation resourceLocation() {
            return this.namespace.asResource(this.path);
        }

        public TagKey<Item> tag() {
            return BlazingTags.itemTag(this.resourceLocation());
        }
    }

    public static enum Fluids {
        BLAZE_MIXER_FUEL("blaze_mixer_fuel"),
        NETHER_LAVA("nether_lava"),
        BLAZE_MIXER_PLACEHOLDER("blaze_mixer_placeholder");

        public final Namespace namespace;
        public final String path;
        public final boolean alwaysDatagen;

        private Fluids(String path) {
            this(Namespace.BLAZINGHOT, path);
        }

        private Fluids(Namespace namespace, String path) {
            this(namespace, path, namespace.alwaysDatagenDefault);
        }

        private Fluids(Namespace namespace, String path, boolean alwaysDatagen) {
            this.namespace = namespace;
            this.path = path;
            this.alwaysDatagen = alwaysDatagen;
        }

        public ResourceLocation resourceLocation() {
            return this.namespace.asResource(this.path);
        }

        public TagKey<Fluid> tag() {
            return BlazingTags.fluidTag(this.resourceLocation());
        }
    }

    public static enum Namespace {
        BLAZINGHOT("blazinghot", true),
        COMMON("c", false);

        public final String id;
        public final boolean alwaysDatagenDefault;

        private Namespace(String id, boolean alwaysDatagenDefault) {
            this.id = id;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }

        public ResourceLocation asResource(String ... path) {
            return ResourceLocation.fromNamespaceAndPath((String)this.id, (String)String.join((CharSequence)"/", path));
        }
    }
}

