/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry.neoforge;

import com.dudko.blazinghot.foundation.multiloader.Env;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.dudko.blazinghot.registry.BlazingCreativeTabs;
import com.dudko.blazinghot.registry.BlazingItems;
import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyItem;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BlazingCreativeTabsImpl
extends BlazingCreativeTabs {
    private static final DeferredRegister<CreativeModeTab> REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"blazinghot");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BASE_CREATIVE_TAB = REGISTER.register("base", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.blazinghot")).withTabsBefore(new ResourceKey[]{AllCreativeModeTabs.PALETTES_CREATIVE_TAB.getKey()}).icon(() -> BlazingItems.BLAZE_GOLD_INGOT.asStack()).displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator(true, BASE_CREATIVE_TAB)).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BUILDING_CREATIVE_TAB = REGISTER.register("building", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.blazinghot.building")).withTabsBefore(new ResourceKey[]{BASE_CREATIVE_TAB.getKey()}).icon(() -> BlazingBlocks.MODERN_LAMP_BLOCKS.get(DyeColor.WHITE).asStack()).displayItems((CreativeModeTab.DisplayItemsGenerator)new RegistrateDisplayItemsGenerator(false, BUILDING_CREATIVE_TAB)).build());

    public static void register(IEventBus eventBus) {
        REGISTER.register(eventBus);
    }

    public static ResourceKey<CreativeModeTab> getBaseTabKey() {
        return BASE_CREATIVE_TAB.getKey();
    }

    public static ResourceKey<CreativeModeTab> getBuildingTabKey() {
        return BUILDING_CREATIVE_TAB.getKey();
    }

    public static void useBaseTab() {
        REGISTRATE.setCreativeTab(BASE_CREATIVE_TAB);
    }

    public static void useBuildingTab() {
        REGISTRATE.setCreativeTab(BUILDING_CREATIVE_TAB);
    }

    public static class RegistrateDisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private final boolean addItems;
        private final DeferredHolder<CreativeModeTab, CreativeModeTab> tab;

        public RegistrateDisplayItemsGenerator(boolean addItems, DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
            this.addItems = addItems;
            this.tab = tab;
        }

        private static Predicate<Item> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemProviderEntry> simpleExclusions = List.of();
            List<ItemProviderEntry> tagDependentExclusions = List.of();
            for (ItemProviderEntry entry : simpleExclusions) {
                exclusions.add(entry.asItem());
            }
            for (ItemProviderEntry entry : tagDependentExclusions) {
                TagDependentIngredientItem item = (TagDependentIngredientItem)entry.get();
                if (!item.shouldHide()) continue;
                exclusions.add(entry.asItem());
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeExclusionPredicate$0((Set)exclusions, arg_0);
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemProviderEntry, ItemProviderEntry> simpleBeforeOrderings = Map.of();
            Map<ItemProviderEntry, ItemProviderEntry> simpleAfterOrderings = Map.of();
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$1((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$2((List)orderings, arg_0, arg_1));
            return orderings;
        }

        private static Function<Item, ItemStack> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemProviderEntry, Function> simpleFactories = Map.of();
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$3((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$4((Map)factories, arg_0);
        }

        private static Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemProviderEntry, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of();
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$5((Map)visibilities, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0);
        }

        public void accept(@NotNull CreativeModeTab.ItemDisplayParameters parameters, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull CreativeModeTab.Output output) {
            Predicate<Item> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<Item, ItemStack> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            LinkedList<Item> items = new LinkedList<Item>();
            Predicate is3d = (Predicate)Env.unsafeRunForDist(() -> () -> item -> Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)item), null, null, 0).isGui3d(), () -> () -> item -> false);
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate, is3d, true));
            }
            items.addAll(this.collectBlocks(exclusionPredicate));
            if (this.addItems) {
                items.addAll(this.collectItems(exclusionPredicate, is3d, false));
                REGISTRATE.getAll(Registries.FLUID).forEach(entry -> items.add(((Fluid)entry.get()).getBucket()));
            }
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : REGISTRATE.getAll(Registries.BLOCK)) {
                Item item;
                if (!CreateRegistrate.isInCreativeTab((RegistryEntry)entry, this.tab) || (item = ((Block)entry.get()).asItem()) == Items.AIR || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> collectItems(Predicate<Item> exclusionPredicate, Predicate<Item> is3d, boolean special) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : REGISTRATE.getAll(Registries.ITEM)) {
                Item item;
                if (!CreateRegistrate.isInCreativeTab((RegistryEntry)entry, this.tab) || (item = (Item)entry.get()) instanceof BlockItem || is3d.test(item) != special || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        private static void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                Item item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
            for (Item item : items) {
                output.accept(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$6(Map visibilities, Item item) {
            CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
            return Objects.requireNonNullElse(visibility, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$5(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
            visibilities.put(entry.asItem(), factory);
        }

        private static /* synthetic */ ItemStack lambda$makeStackFunc$4(Map factories, Item item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (ItemStack)factory.apply(item);
            }
            return new ItemStack((ItemLike)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$3(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.asItem(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$2(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.asItem(), otherEntry.asItem()));
        }

        private static /* synthetic */ void lambda$makeOrderings$1(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.asItem(), otherEntry.asItem()));
        }

        private static /* synthetic */ boolean lambda$makeExclusionPredicate$0(Set exclusions, Item item) {
            return exclusions.contains(item) || item instanceof SequencedAssemblyItem;
        }

        private record ItemOrdering(Item item, Item anchor, Type type) {
            public static ItemOrdering before(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(Item item, Item anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }
}

