/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.registry.neoforge;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.content.metal.BlazingMetal;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class BlazingFluidsImpl {
    private static final CreateRegistrate REGISTRATE = BlazingHot.registrate();
    public static MoltenMetalsList<BaseFlowingFluid.Flowing> MOLTEN_METALS = new MoltenMetalsList<BaseFlowingFluid.Flowing>(metal -> BlazingFluidsImpl.createFromLava(metal.getMoltenName()));
    public static FluidEntry<BaseFlowingFluid.Flowing> NETHER_LAVA = BlazingFluidsImpl.createFromLava("nether_lava", 10, 1);

    public static FluidEntry<BaseFlowingFluid.Flowing> createFromLava(String name, int tickRate) {
        return BlazingFluidsImpl.createFromLava(name, tickRate, 2);
    }

    public static FluidEntry<BaseFlowingFluid.Flowing> createFromLava(String name) {
        return BlazingFluidsImpl.createFromLava(name, 30);
    }

    public static FluidEntry<BaseFlowingFluid.Flowing> createFromLava(String name, int tickRate, int decreaseRate) {
        return ((FluidBuilder)((FluidBuilder)REGISTRATE.standardFluid(name).tag(new TagKey[]{BlazingTags.fluidTag(BlazingTags.Namespace.COMMON.id, name)}).properties(p -> p.density(3000).viscosity(6000).temperature(1300).canExtinguish(false).canHydrate(false).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).motionScale(0.0023333333333333335).canSwim(false).canDrown(false).pathType(PathType.LAVA).adjacentPathType(null)).fluidProperties(p -> p.tickRate(tickRate).levelDecreasePerBlock(decreaseRate).slopeFindDistance(3).explosionResistance(100.0f)).source(BaseFlowingFluid.Source::new).block().initialProperties(() -> Blocks.LAVA).properties(p -> p.lightLevel(b -> 15)).build()).bucket().tag(new TagKey[]{BlazingTags.itemTag(BlazingTags.Namespace.COMMON.id, "bucket/" + name)}).build()).register();
    }

    public static void registerFluidInteractions() {
        BlazingFluidsImpl.fluidInteraction(NETHER_LAVA, (NonNullSupplier<Block>)((NonNullSupplier)() -> Blocks.COBBLESTONE), new Fluid[]{Fluids.WATER, Fluids.WATER.getSource()});
        BlazingFluidsImpl.fluidInteraction(NETHER_LAVA, (NonNullSupplier<Block>)((NonNullSupplier)() -> (Block)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get()), (Fluid)AllFluids.HONEY.get(), ((BaseFlowingFluid.Flowing)AllFluids.HONEY.get()).getSource());
        BlazingFluidsImpl.fluidInteraction(NETHER_LAVA, (NonNullSupplier<Block>)((NonNullSupplier)() -> (Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()), (Fluid)AllFluids.CHOCOLATE.get(), ((BaseFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).getSource());
        for (BlazingMetal metal : BlazingMetals.ALL) {
            for (Map.Entry<Fluid, NonNullSupplier<Block>> entry : metal.fluidInteractions.entrySet()) {
                if (entry.getValue() == null) {
                    BlazingHot.LOGGER.error("Null fluid interaction for {}, {}", (Object)metal.getMoltenName(), (Object)BuiltInRegistries.FLUID.getKey((Object)entry.getKey()));
                    continue;
                }
                BlazingFluidsImpl.fluidInteraction(MOLTEN_METALS.get(metal), entry.getValue(), entry.getKey());
            }
        }
        FluidInteractionRegistry.addInteraction((FluidType)NETHER_LAVA.getType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, fluidState) -> level.getBlockState(relativePos).getBlock() == Blocks.BLUE_ICE && level.getBlockState(currentPos.below()).getBlock() == Blocks.SOUL_SOIL, Blocks.BASALT.defaultBlockState()));
    }

    private static void fluidInteraction(FluidEntry<BaseFlowingFluid.Flowing> entry, NonNullSupplier<Block> result, Fluid ... fluids) {
        Block block = (Block)result.get();
        for (Fluid fluid : fluids) {
            FluidInteractionRegistry.addInteraction((FluidType)entry.getType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(fluid.getFluidType(), fluidState -> {
                if (fluidState.isSource()) {
                    return Blocks.OBSIDIAN.defaultBlockState();
                }
                return block.defaultBlockState();
            }));
        }
    }

    @Nullable
    public static BlockState getFluidInteraction(FluidState fluidState, FluidState metFluidState) {
        for (BlazingMetal metal : BlazingMetals.ALL) {
            for (Map.Entry<Fluid, NonNullSupplier<Block>> entry : metal.fluidInteractions.entrySet()) {
                if (entry.getValue() == null) {
                    BlazingHot.LOGGER.debug("Null fluid interaction for {}, {}", (Object)metal.getMoltenName(), (Object)BuiltInRegistries.FLUID.getKey((Object)entry.getKey()));
                    continue;
                }
                if (!fluidState.getType().isSame((Fluid)MOLTEN_METALS.getFluid(metal)) || !metFluidState.getType().isSame(entry.getKey())) continue;
                return ((Block)entry.getValue().get()).defaultBlockState();
            }
        }
        return null;
    }

    public static void platformRegister() {
    }

    public static class MoltenMetalsList<T extends BaseFlowingFluid>
    implements Iterable<FluidEntry<T>> {
        private static final int METAL_AMOUNT = BlazingMetals.ALL.size();
        private final FluidEntry<?>[] values = new FluidEntry[METAL_AMOUNT];

        private static int metalOrdinal(BlazingMetal metal) {
            return BlazingMetals.ALL.indexOf(metal);
        }

        public MoltenMetalsList(Function<BlazingMetal, FluidEntry<? extends T>> filler) {
            for (BlazingMetal metal : BlazingMetals.ALL) {
                this.values[MoltenMetalsList.metalOrdinal((BlazingMetal)metal)] = filler.apply(metal);
            }
        }

        public FluidEntry<T> get(BlazingMetal metal) {
            return this.values[MoltenMetalsList.metalOrdinal(metal)];
        }

        public T getFluid(BlazingMetal metal) {
            return (T)this.get(metal).getSource();
        }

        public boolean contains(Fluid fluid) {
            for (FluidEntry<?> entry : this.values) {
                if (!entry.is((Object)fluid)) continue;
                return true;
            }
            return false;
        }

        public FluidEntry<T>[] toArray() {
            return Arrays.copyOf(this.values, this.values.length);
        }

        @Override
        @NotNull
        public Iterator<FluidEntry<T>> iterator() {
            return new Iterator<FluidEntry<T>>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < values.length;
                }

                @Override
                public FluidEntry<T> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return values[this.index++];
                }
            };
        }
    }
}

