/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.util;

import com.dudko.blazinghot.compat.Mods;
import com.dudko.blazinghot.registry.BlazingTags;
import com.dudko.blazinghot.util.LangUtil;
import com.simibubi.create.foundation.block.DyedBlockList;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class DyeUtil {
    public static ShapedRecipeBuilder dyeingMultiple(RecipeCategory category, TagKey<Item> tag, ItemLike result, DyeColor dyeColor) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result, (int)8).pattern("###").pattern("#d#").pattern("###").define(Character.valueOf('#'), tag).define(Character.valueOf('d'), DyeUtil.getDyeTag(dyeColor)).unlockedBy("has_" + tag.location().getPath(), RegistrateRecipeProvider.has(tag));
    }

    public static ShapelessRecipeBuilder dyeingSingle(RecipeCategory category, TagKey<Item> tag, ItemLike result, DyeColor dyeColor) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result, (int)1).requires(tag).requires(DyeUtil.getDyeTag(dyeColor)).unlockedBy("has_" + tag.location().getPath(), RegistrateRecipeProvider.has(tag));
    }

    public static TagKey<Item> getDyeTag(DyeColor color) {
        return DyeUtil.get((DyeColor)color).tag;
    }

    public static Item getDyeItem(DyeColor color) {
        return DyeUtil.get((DyeColor)color).item;
    }

    public static Block getStainedGlass(DyeColor color) {
        return DyeUtil.get((DyeColor)color).stainedGlass.get();
    }

    public static Dyes get(DyeColor color) {
        return Arrays.stream(Dyes.values()).filter(dye -> dye.color == color).findFirst().orElse(Dyes.WHITE);
    }

    public static void provideLangEntries(BiConsumer<String, String> consumer) {
        for (Dyes dye : Dyes.values()) {
            ResourceLocation loc = dye.tag.location();
            consumer.accept("tag.item.blazinghot." + loc.getPath().replace('/', '.'), LangUtil.titleCaseConversion(dye.toString().replace('_', ' ')) + " Dyes");
        }
    }

    public static boolean isIn(DyedBlockList<?> list, ItemStack itemStack) {
        return Arrays.stream(list.toArray()).anyMatch(block -> block.isIn(itemStack));
    }

    public static enum Dyes {
        BLACK(DyeColor.BLACK, Items.BLACK_DYE),
        BLUE(DyeColor.BLUE, Items.BLUE_DYE),
        BROWN(DyeColor.BROWN, Items.BROWN_DYE),
        WHITE(DyeColor.WHITE, Items.WHITE_DYE),
        GREEN(DyeColor.GREEN, Items.GREEN_DYE),
        RED(DyeColor.RED, Items.RED_DYE),
        LIME(DyeColor.LIME, Items.LIME_DYE),
        YELLOW(DyeColor.YELLOW, Items.YELLOW_DYE),
        ORANGE(DyeColor.ORANGE, Items.ORANGE_DYE),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE, Items.LIGHT_BLUE_DYE),
        MAGENTA(DyeColor.MAGENTA, Items.MAGENTA_DYE),
        PINK(DyeColor.PINK, Items.PINK_DYE),
        GRAY(DyeColor.GRAY, Items.GRAY_DYE),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY, Items.LIGHT_GRAY_DYE),
        CYAN(DyeColor.CYAN, Items.CYAN_DYE),
        PURPLE(DyeColor.PURPLE, Items.PURPLE_DYE);

        public final DyeColor color;
        public final TagKey<Item> tag;
        public final Item item;
        public final Supplier<Block> stainedGlass;

        private Dyes(DyeColor color, Item item) {
            this.color = color;
            this.tag = BlazingTags.itemTag(BlazingTags.Namespace.COMMON.asResource("dyes", this.toString()));
            this.item = item;
            this.stainedGlass = () -> (Block)BuiltInRegistries.BLOCK.get(Mods.VANILLA.asResource(String.valueOf((Object)this) + "_stained_glass"));
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

