/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;

public class TooltipUtil {
    public static void addEffectTooltip(List<Component> lines, Item.TooltipContext context, MobEffectInstance effect) {
        effect.getEffect().unwrap().mapRight(e -> {
            MutableComponent amplifier = effect.getAmplifier() == 0 ? Component.empty() : Component.translatable((String)("potion.potency." + effect.getAmplifier())).append(" ");
            return lines.add((Component)Component.translatable((String)effect.getDescriptionId()).append(" ").append((Component)amplifier).append("(").append(MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)context.tickRate())).append(")").withStyle(new ChatFormatting[0]));
        });
    }

    public static MutableComponent asciiProgressBar(int length, float value, float max) {
        if (max == 0.0f) {
            return Component.empty();
        }
        float percent = Mth.clamp((float)value, (float)0.0f, (float)max) / max;
        int filled = Math.round((float)length * percent);
        int empty = length - filled;
        MutableComponent filledBar = Component.literal((String)"\u2588".repeat(filled)).withStyle(ChatFormatting.GRAY);
        MutableComponent emptyBar = Component.literal((String)"\u2588".repeat(empty)).withStyle(ChatFormatting.DARK_GRAY);
        return Component.literal((String)"[").withStyle(ChatFormatting.GRAY).append((Component)filledBar).append((Component)emptyBar).append("]").withStyle(ChatFormatting.GRAY);
    }
}

