/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui.widgets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.announcements.Semver;
import net.dawson.adorablehamsterpets.client.gui.AnnouncementScreen;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.mixin.client.accessor.HandledScreenAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class AnnouncementIconWidget
extends Button {
    private static final ResourceLocation ICON_TEXTURE = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"textures/item/announcement_bell_icon.png");
    private static final int ICON_WIDTH = 16;
    private static final int ICON_HEIGHT = 16;
    private final Screen parentScreen;
    private int lastTargetX = -1;
    private int lastTargetY = -1;

    public AnnouncementIconWidget(int x, int y, int width, int height, Button.OnPress onPress, Screen parentScreen) {
        super(x, y, width, height, (Component)Component.m_237119_(), onPress, f_252438_);
        this.parentScreen = parentScreen;
    }

    protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        List<AnnouncementManager.PendingNotification> notifications;
        AnnouncementIconAnimator animator = AnnouncementIconAnimator.INSTANCE;
        Screen screen = this.parentScreen;
        if (screen instanceof AbstractContainerScreen) {
            int targetY;
            int targetX;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            HandledScreenAccessor accessor = (HandledScreenAccessor)containerScreen;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            int guiWidth = accessor.getBackgroundWidth();
            if (containerScreen instanceof CreativeModeInventoryScreen) {
                targetX = guiLeft + guiWidth + 5 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.creativeWidgetIconSettings.get()).offsetX.get();
                targetY = guiTop + 139 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.creativeWidgetIconSettings.get()).offsetY.get();
            } else {
                targetX = guiLeft + guiWidth - this.f_93618_ + 4 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.survivalWidgetIconSettings.get()).offsetX.get();
                targetY = guiTop - 4 + (Integer)((AhpConfig.WidgetIconOffsets)Configs.AHP.survivalWidgetIconSettings.get()).offsetY.get();
            }
            if (targetX != this.lastTargetX || targetY != this.lastTargetY) {
                AnnouncementIconAnimator.INSTANCE.startTransition(targetX, targetY);
                this.lastTargetX = targetX;
                this.lastTargetY = targetY;
            }
        } else if (this.parentScreen instanceof TitleScreen) {
            animator.updateTargetPosition(this.parentScreen.f_96543_, this.parentScreen.f_96544_);
        }
        animator.setHovered(this.m_274382_());
        float animScale = animator.getRenderScale(delta);
        float configScale = ((Float)Configs.AHP.hudIconScale.get()).floatValue();
        float finalScale = animScale * configScale;
        float angle = animator.getRenderAngle(delta);
        double renderX = animator.getRenderX(delta);
        double renderY = animator.getRenderY(delta);
        this.f_93618_ = (int)(16.0f * configScale);
        this.f_93619_ = (int)(16.0f * configScale);
        this.m_252865_((int)Math.round(renderX));
        this.m_253211_((int)Math.round(renderY));
        context.m_280168_().m_85836_();
        context.m_280168_().m_85837_(renderX + (double)this.f_93618_ / 2.0, renderY + (double)this.f_93619_ / 2.0, 0.0);
        context.m_280168_().m_85841_(finalScale, finalScale, 1.0f);
        context.m_280168_().m_252781_(Axis.f_252403_.m_252977_(angle));
        context.m_280168_().m_85837_(-8.0, -8.0, 0.0);
        context.m_280163_(ICON_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        context.m_280168_().m_85849_();
        if (this.m_274382_() && !(notifications = AnnouncementManager.INSTANCE.getPendingNotifications()).isEmpty()) {
            ArrayList<Object> tooltipLines = new ArrayList<Object>();
            MutableComponent modNameText = Component.m_237115_((String)"key.categories.adorablehamsterpets.main").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
            Component mainTooltipLine = null;
            if (this.parentScreen instanceof TitleScreen) {
                mainTooltipLine = notifications.stream().filter(n -> n.reason().equals("update_available_announcement")).findFirst().map(AnnouncementManager::getTooltipTextForNotification).orElse(null);
            } else {
                AnnouncementManager.PendingNotification primary = notifications.get(0);
                mainTooltipLine = AnnouncementManager.getTooltipTextForNotification(primary);
            }
            if (mainTooltipLine != null) {
                tooltipLines.add(mainTooltipLine);
                tooltipLines.add(modNameText);
                context.m_280666_(Minecraft.m_91087_().f_91062_, tooltipLines, mouseX, mouseY);
            }
        }
    }

    public void m_5691_() {
        AnnouncementIconAnimator.INSTANCE.triggerClickAnimation();
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        List<AnnouncementManager.PendingNotification> notifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ResourceLocation bookId = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"hamster_tips_guide_book");
        if (this.parentScreen instanceof TitleScreen) {
            notifications.stream().filter(n -> n.reason().equals("update_available_announcement")).max(Comparator.comparing(n -> Semver.parse(n.announcement().semver()))).ifPresent(notification -> {
                Announcement announcement = notification.announcement();
                Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
                if (book != null) {
                    ResourceLocation entryId = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)("announcement_" + announcement.id()));
                    JsonObject json = new JsonObject();
                    json.addProperty("name", announcement.title());
                    json.addProperty("icon", "minecraft:writable_book");
                    json.addProperty("category", "adorablehamsterpets:update_notes");
                    json.add("pages", (JsonElement)new JsonArray());
                    BookEntry virtualEntry = new BookEntry(json, entryId, book, "adorablehamsterpets");
                    client.m_91152_((Screen)new AnnouncementScreen(announcement, notification.reason(), this.parentScreen, virtualEntry));
                }
            });
        } else if (notifications.size() == 1) {
            AnnouncementManager.PendingNotification notification2 = notifications.get(0);
            Announcement announcement = notifications.get(0).announcement();
            Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
            if (book != null) {
                ResourceLocation entryId = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)("announcement_" + announcement.id()));
                BookEntry realVirtualEntry = (BookEntry)book.getContents().entries.get(entryId);
                if (realVirtualEntry != null) {
                    client.m_91152_((Screen)new AnnouncementScreen(announcement, notification2.reason(), null, realVirtualEntry));
                } else {
                    AdorableHamsterPets.LOGGER.error("[AHP] Could not find virtual entry '{}' in book contents to open announcement screen.", (Object)entryId);
                }
            }
        } else {
            Book book = (Book)BookRegistry.INSTANCE.books.get(bookId);
            if (book != null) {
                book.getContents().currentGui = null;
                book.getContents().guiStack.clear();
            }
            PatchouliAPI.get().openBookGUI(bookId);
        }
    }
}

