/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.sound;

import java.util.Objects;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class HamsterFlightSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final HamsterEntity hamster;
    private boolean done = false;
    private int ticksElapsed = 0;
    private final int effectDuration = 30;
    private final float initialPitch = 1.0f;
    private final float basePitch = 0.5f;
    private final float initialVolume = 1.0f;
    private final float endVolume = 0.2f;

    public HamsterFlightSoundInstance(SoundEvent sound, SoundSource category, HamsterEntity hamster) {
        super(sound, category, hamster.m_217043_());
        this.hamster = hamster;
        this.f_119575_ = hamster.m_20185_();
        this.f_119576_ = hamster.m_20186_();
        this.f_119577_ = hamster.m_20189_();
        this.f_119578_ = false;
        this.f_119579_ = 0;
        this.f_119573_ = 1.0f;
        this.f_119574_ = 1.0f;
        this.f_119582_ = false;
        this.f_119580_ = SoundInstance.Attenuation.LINEAR;
    }

    public boolean m_7801_() {
        AdorableHamsterPets.LOGGER.debug("HamsterFlightSoundInstance isDone() checked, returning: {}", (Object)this.done);
        return this.done;
    }

    public void m_7788_() {
        if (!this.hamster.m_6084_() || this.hamster.m_213877_()) {
            if (!this.done) {
                AdorableHamsterPets.LOGGER.debug("HamsterFlightSoundInstance: Hamster invalid, setting done=true.");
            }
            this.done = true;
            return;
        }
        if (this.ticksElapsed > this.effectDuration) {
            if (!this.done) {
                AdorableHamsterPets.LOGGER.debug("HamsterFlightSoundInstance: Duration exceeded ({}), setting done=true.", (Object)this.effectDuration);
            }
            this.done = true;
            return;
        }
        ++this.ticksElapsed;
        this.f_119575_ = this.hamster.m_20185_();
        this.f_119576_ = this.hamster.m_20186_();
        this.f_119577_ = this.hamster.m_20189_();
        float f = this.ticksElapsed;
        Objects.requireNonNull(this);
        float progress = Mth.m_14036_((float)(f / 30.0f), (float)0.0f, (float)1.0f);
        float curveFactor = Mth.m_14089_((float)(progress * 1.5707964f));
        Objects.requireNonNull(this);
        this.f_119574_ = this.basePitch + (1.0f - this.basePitch) * curveFactor;
        Objects.requireNonNull(this);
        this.f_119573_ = this.endVolume + (1.0f - this.endVolume) * curveFactor;
        this.f_119574_ = Mth.m_14036_((float)this.f_119574_, (float)0.5f, (float)2.0f);
        this.f_119573_ = Mth.m_14036_((float)this.f_119573_, (float)0.0f, (float)1.0f);
    }
}

