/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.client.HamsterBedRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterMountPayload;
import net.dawson.adorablehamsterpets.networking.payload.SpawnBeddingParticlesPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }

    public static void init() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.GREEN_BEANS_CROP.get(), (class_2248)ModBlocks.CUCUMBER_CROP.get(), (class_2248)ModBlocks.SUNFLOWER_BLOCK.get(), (class_2248)ModBlocks.WILD_CUCUMBER_BUSH.get(), (class_2248)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (class_2248)ModBlocks.HAMSTER_BED.get()});
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.GREEN_BEANS_CROP.get(), (class_2248)ModBlocks.CUCUMBER_CROP.get(), (class_2248)ModBlocks.SUNFLOWER_BLOCK.get(), (class_2248)ModBlocks.WILD_CUCUMBER_BUSH.get(), (class_2248)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (class_2248)ModBlocks.HAMSTER_BED.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)class_2960.method_60655((String)"adorablehamsterpets", (String)"main"))) {
                ConfigDataCache.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client following GUI update. *wink wink*");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (class_1935[])new class_1935[]{(class_1935)ModItems.HAMSTER_SPAWN_EGG.get()});
        ModPackets.registerS2CPackets();
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientGuiEvent.RENDER_HUD.register((context, tickCounter) -> announcementHudRenderer.render(context, tickCounter.method_60637(true)));
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (player.method_37908().field_9236 && hand == class_1268.field_5808 && entity instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.method_1434() && hamster.method_6181() && hamster.method_6171((class_1309)player)) {
                    NetworkManager.sendToServer((class_8710)new RequestHamsterMountPayload(hamster.method_5628()));
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.pass();
        });
    }

    public static void initBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), HamsterBedRenderer::new);
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(class_310 client) {
        boolean isGuiOpen = client.field_1755 != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.field_1687 != null && !AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
            AnnouncementManager.INSTANCE.syncPatchouliReadState();
            if (AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
                AnnouncementManager.INSTANCE.processDeferredReadMarks();
            }
        }
        if (client.field_1687 != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.method_1436()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.field_1724).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    NetworkManager.sendToServer((class_8710)new ThrowHamsterPayload());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            NetworkManager.sendToServer((class_8710)new UpdateHamsterRenderStatePayload(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
    }

    private static void handleDismountKeyPress(class_310 client) {
        long delayMillis;
        long currentTime;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        boolean hasShoulderHamster = ((PlayerEntityAccessor)client.field_1724).hasAnyShoulderHamster();
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            class_304 vanillaSneak = client.field_1690.field_1832;
            class_304 customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.method_23481(false);
                while (vanillaSneak.method_1436()) {
                }
            }
            if (customDismount != null) {
                customDismount.method_23481(false);
                while (customDismount.method_1436()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Mount transition detected -> draining input queues and starting debounce ({} ticks).", (Object)5);
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            if (isWaitingForSecondSneakPress) {
                isWaitingForSecondSneakPress = false;
            }
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        class_304 keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.field_1690.field_1832;
        boolean wasKeyPressed = keyToListenFor != null && keyToListenFor.method_1436();
        AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: Listening for '{}'. wasPressed() = {}", (Object)(keyToListenFor != null ? keyToListenFor.method_1431() : "null-binding"), (Object)wasKeyPressed);
        if (wasKeyPressed) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: SINGLE_PRESS detected. Press type config: {}", config.dismountPressType.get());
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                NetworkManager.sendToServer((class_8710)new DismountHamsterPayload());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP second press detected. Sending dismount payload.");
                    NetworkManager.sendToServer((class_8710)new DismountHamsterPayload());
                    isWaitingForSecondSneakPress = false;
                } else {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP first press detected. Starting timer.");
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP timed out.");
            isWaitingForSecondSneakPress = false;
        }
    }

    public static void handleSpawnBeddingParticles(SpawnBeddingParticlesPayload payload) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2338 spawnPos = payload.pos().method_10093(payload.direction());
        class_243 particleCenter = class_243.method_24953((class_2382)spawnPos);
        class_2400 particleType = ModParticles.getForVariant(payload.variant());
        for (int i = 0; i < 30; ++i) {
            double offsetX = client.field_1687.field_9229.method_43059() * 1.2;
            double offsetY = client.field_1687.field_9229.method_43059() * 1.2;
            double offsetZ = client.field_1687.field_9229.method_43059() * 1.2;
            client.field_1687.method_8406((class_2394)particleType, particleCenter.field_1352 + offsetX, particleCenter.field_1351 + offsetY, particleCenter.field_1350 + offsetZ, 0.0, -1.23E-4, 0.0);
        }
    }

    public static void handlePlayGuidebookEffects() {
        int i;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        client.method_1507(null);
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        if (player == null || world == null) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.guidebook_rediscovered").method_27692(class_124.field_1065), true);
        world.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15119, class_3419.field_15248, 0.5f, 1.2f, false);
        world.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_17481, class_3419.field_15248, 0.7f, 1.5f, false);
        for (i = 0; i < 50; ++i) {
            world.method_8406((class_2394)class_2398.field_11215, player.method_23322(0.6), player.method_23319(), player.method_23325(0.6), (world.field_9229.method_43058() - 0.5) * 0.5, (world.field_9229.method_43058() - 0.5) * 0.5, (world.field_9229.method_43058() - 0.5) * 0.5);
        }
        for (i = 0; i < 20; ++i) {
            world.method_8406((class_2394)class_2398.field_11211, player.method_23322(1.0), player.method_23319(), player.method_23325(1.0), (world.field_9229.method_43058() - 0.5) * 0.5, (world.field_9229.method_43058() - 0.5) * 0.5, (world.field_9229.method_43058() - 0.5) * 0.5);
        }
    }
}

