/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.entity;

import java.util.Optional;
import java.util.UUID;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedBlockEntity
extends class_2586
implements GeoBlockEntity {
    private Optional<UUID> linkedHamsterUuid = Optional.empty();
    private Optional<class_2561> linkedHamsterName = Optional.empty();
    private WanderDistance wanderDistance = WanderDistance.MEDIUM;
    private boolean isNewlyPlaced = true;
    private boolean allowSleep = true;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "hamster_bed_controller", 2, state -> {
            class_2680 blockState = ((HamsterBedBlockEntity)state.getAnimatable()).method_11010();
            if (((Boolean)blockState.method_11654((class_2769)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("anim_bed_idle_waving_occupied"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("anim_bed_idle_waving_unoccupied"));
        });
        controller.triggerableAnim("anim_bed_being_placed", RawAnimation.begin().thenPlay("anim_bed_being_placed"));
        controller.triggerableAnim("anim_bed_becoming_occupied", RawAnimation.begin().thenPlay("anim_bed_becoming_occupied"));
        controller.triggerableAnim("anim_bed_becoming_unoccupied", RawAnimation.begin().thenPlay("anim_bed_becoming_unoccupied"));
        controller.triggerableAnim("anim_bed_interact_occupied", RawAnimation.begin().thenPlay("anim_bed_interact_occupied"));
        controller.triggerableAnim("anim_bed_interact_unoccupied", RawAnimation.begin().thenPlay("anim_bed_interact_unoccupied"));
        registrar.add(controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Optional<UUID> getLinkedHamsterUuid() {
        return this.linkedHamsterUuid;
    }

    public Optional<class_2561> getLinkedHamsterName() {
        return this.linkedHamsterName;
    }

    public boolean isWanderModeActive() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_1297 entity;
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.method_14190(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                return hamster.isWanderModeActive();
            }
        }
        return false;
    }

    public boolean isNewlyPlaced() {
        return this.isNewlyPlaced;
    }

    public void markAsUsed() {
        this.isNewlyPlaced = false;
    }

    public boolean isSleepingAllowed() {
        return this.allowSleep;
    }

    public void setAllowSleep(boolean allow) {
        this.allowSleep = allow;
        this.method_5431();
    }

    public void applyRepellentEffect() {
        this.setAllowSleep(false);
    }

    public HamsterBedBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get(), pos, state);
    }

    public void setLinkedHamster(UUID uuid, class_2561 name, WanderDistance distance) {
        this.linkedHamsterUuid = Optional.of(uuid);
        this.linkedHamsterName = Optional.of(name);
        this.wanderDistance = distance;
        this.method_5431();
    }

    public WanderDistance getWanderDistance() {
        return this.wanderDistance;
    }

    public void toggleWanderMode(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_1297 entity;
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.method_14190(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                boolean newMode = !hamster.isWanderModeActive();
                hamster.setWanderModeActive(newMode);
                if (!newMode && ((Boolean)this.method_11010().method_11654((class_2769)HamsterBedBlock.OCCUPIED)).booleanValue() && hamster.method_6113()) {
                    hamster.wakeUpFromBed(true);
                }
                class_5250 status = newMode ? class_2561.method_43470((String)"ENABLED") : class_2561.method_43470((String)"DISABLED");
                player.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.wander_mode_set", (Object[])new Object[]{hamster.method_5477(), status}), true);
                this.field_11863.method_8396(null, this.method_11016(), (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15245, 0.5f, newMode ? 1.2f : 0.8f);
            }
        }
    }

    public void cycleWanderDistance(class_1657 player) {
        WanderDistance[] values = WanderDistance.values();
        this.wanderDistance = values[(this.wanderDistance.ordinal() + 1) % values.length];
        this.method_5431();
        if (this.linkedHamsterName.isPresent()) {
            player.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.wander_distance_set", (Object[])new Object[]{this.linkedHamsterName.get(), this.wanderDistance.method_15434()}), true);
            this.field_11863.method_8396(null, this.method_11016(), (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15245, 0.5f, 1.0f);
        }
    }

    public boolean lureHamsterToBed(class_1657 player, class_1799 lureItem) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_1297 entity;
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.method_14190(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (!hamster.isWanderModeActive()) {
                    hamster.setWanderModeActive(true);
                }
                if (hamster.method_24345() || hamster.method_6113()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.lure_to_bed_fail").method_27692(class_124.field_1061), true);
                    return false;
                }
                hamster.lureToBed();
                class_3414 lureSound = ModSounds.getDynamicItemSound(lureItem);
                this.field_11863.method_8396(null, this.method_11016(), lureSound, class_3419.field_15245, 1.0f, 1.0f);
                ((class_3218)this.field_11863).method_14199((class_2394)new class_2392(class_2398.field_11218, lureItem), (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.7, (double)this.method_11016().method_10260() + 0.5, 8, 0.25, 0.25, 0.25, 0.05);
                return true;
            }
        }
        return false;
    }

    public void unlinkHamster(class_1657 player) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.linkedHamsterUuid.isPresent()) {
                HamsterEntity hamster;
                class_1297 entity;
                UUID uuidToUnlink = this.linkedHamsterUuid.get();
                class_2561 hamsterNameToUnlink = this.linkedHamsterName.orElse((class_2561)class_2561.method_43470((String)"A hamster"));
                if (((Boolean)this.method_11010().method_11654((class_2769)HamsterBedBlock.OCCUPIED)).booleanValue() && (entity = serverWorld.method_14190(uuidToUnlink)) instanceof HamsterEntity && (hamster = (HamsterEntity)entity).method_6113()) {
                    hamster.wakeUpFromBed(true);
                }
                this.linkedHamsterUuid = Optional.empty();
                this.linkedHamsterName = Optional.empty();
                this.wanderDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                this.method_5431();
                entity = serverWorld.method_14190(uuidToUnlink);
                if (entity instanceof HamsterEntity) {
                    hamster = (HamsterEntity)entity;
                    hamster.setWanderModeActive(false);
                    hamster.setLinkedBedPos(Optional.empty());
                }
                player.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.bed_unlinked", (Object[])new Object[]{hamsterNameToUnlink}).method_27692(class_124.field_1054), true);
                this.field_11863.method_8396(null, this.method_11016(), class_3417.field_14975, class_3419.field_15245, 1.0f, 1.2f);
            }
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.linkedHamsterUuid.ifPresent(uuid -> nbt.method_25927("LinkedHamsterUuid", uuid));
        this.linkedHamsterName.ifPresent(name -> nbt.method_10582("LinkedHamsterName", class_2561.class_2562.method_10867((class_2561)name, (class_7225.class_7874)registryLookup)));
        nbt.method_10582("WanderDistance", this.wanderDistance.method_15434());
        nbt.method_10556("IsNewlyPlaced", this.isNewlyPlaced);
        if (!((Boolean)this.method_11010().method_11654((class_2769)HamsterBedBlock.UPSIDE_DOWN)).booleanValue()) {
            nbt.method_10556("AllowSleep", this.allowSleep);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.linkedHamsterUuid = nbt.method_25928("LinkedHamsterUuid") ? Optional.of(nbt.method_25926("LinkedHamsterUuid")) : Optional.empty();
        this.linkedHamsterName = nbt.method_10545("LinkedHamsterName") ? Optional.ofNullable(class_2561.class_2562.method_10877((String)nbt.method_10558("LinkedHamsterName"), (class_7225.class_7874)registryLookup)) : Optional.empty();
        this.wanderDistance = WanderDistance.valueOf(nbt.method_10558("WanderDistance").toUpperCase());
        this.isNewlyPlaced = nbt.method_10545("IsNewlyPlaced") ? nbt.method_10577("IsNewlyPlaced") : false;
        this.allowSleep = !nbt.method_10545("AllowSleep") || nbt.method_10577("AllowSleep");
    }
}

