/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ConfigDataCache {
    private static final Set<class_1792> tamingItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> tamingTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> standardFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> standardFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> stealableItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> stealableTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> buffFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> buffFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> lureItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> lureItemTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> bedAvoidanceFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> bedAvoidanceFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> pouchUnlockItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> pouchUnlockTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> repeatableFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> repeatableFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> pouchAllowedItems = new HashSet<class_1792>();
    private static final Set<class_1792> autoHealFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> autoHealFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_6862<class_1792>> pouchAllowedTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> pouchDisallowedItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> pouchDisallowedTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_2960> blueBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> blueBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> blueExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> blueExclusionBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> lavenderBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> lavenderBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> lavenderExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> lavenderExclusionBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> whiteBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> whiteBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> whiteExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> whiteExclusionBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> grayBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> grayBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> grayExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> grayExclusionBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> blackBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> blackBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> blackExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> blackExclusionBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> creamBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> creamBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> creamExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> creamExclusionBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> chocolateBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> chocolateBiomeTags = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> chocolateExclusionBiomeIds = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> chocolateExclusionBiomeTags = new HashSet<class_6862<class_1959>>();

    public static void parseConfig() {
        ConfigDataCache.clearAllItemSets();
        ConfigDataCache.clearAllBiomeSets();
        ConfigDataCache.parseItemList(Configs.AHP.tamingFoods, tamingItems, tamingTags, "tamingFoods");
        ConfigDataCache.parseItemList(Configs.AHP.standardFoods, standardFoodItems, standardFoodTags, "standardFoods");
        ConfigDataCache.parseItemList(Configs.AHP.stealableItems, stealableItems, stealableTags, "stealableItems");
        ConfigDataCache.parseItemList(Configs.AHP.buffFoods, buffFoodItems, buffFoodTags, "buffFoods");
        ConfigDataCache.parseItemList(Configs.AHP.lureItems, lureItems, lureItemTags, "lureItems");
        ConfigDataCache.parseItemList(Configs.AHP.bedAvoidanceFoods, bedAvoidanceFoodItems, bedAvoidanceFoodTags, "bedAvoidanceFoods");
        ConfigDataCache.parseItemList(Configs.AHP.pouchUnlockFoods, pouchUnlockItems, pouchUnlockTags, "pouchUnlockFoods");
        ConfigDataCache.parseItemList(Configs.AHP.repeatableFoods, repeatableFoodItems, repeatableFoodTags, "repeatableFoods");
        ConfigDataCache.parseItemList(Configs.AHP.pouchAllowedItems, pouchAllowedItems, pouchAllowedTags, "pouchAllowedItems");
        ConfigDataCache.parseItemList(Configs.AHP.pouchDisallowedItems, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedItems");
        ConfigDataCache.parseItemList(Configs.AHP.pouchDisallowedTags, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedTags");
        ConfigDataCache.parseItemList(Configs.AHP.autoHealFoods, autoHealFoodItems, autoHealFoodTags, "autoHealFoods");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blueBiomes, blueBiomeIds, "blueBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blueTags, blueBiomeTags, "blueTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blueExclusionBiomes, blueExclusionBiomeIds, "blueExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blueExclusionTags, blueExclusionBiomeTags, "blueExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.lavenderBiomes, lavenderBiomeIds, "lavenderBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.lavenderTags, lavenderBiomeTags, "lavenderTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.lavenderExclusionBiomes, lavenderExclusionBiomeIds, "lavenderExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.lavenderExclusionTags, lavenderExclusionBiomeTags, "lavenderExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.whiteBiomes, whiteBiomeIds, "whiteBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.whiteTags, whiteBiomeTags, "whiteTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.whiteExclusionBiomes, whiteExclusionBiomeIds, "whiteExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.whiteExclusionTags, whiteExclusionBiomeTags, "whiteExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.grayBiomes, grayBiomeIds, "grayBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.grayTags, grayBiomeTags, "grayTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.grayExclusionBiomes, grayExclusionBiomeIds, "grayExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.grayExclusionTags, grayExclusionBiomeTags, "grayExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blackBiomes, blackBiomeIds, "blackBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blackTags, blackBiomeTags, "blackTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blackExclusionBiomes, blackExclusionBiomeIds, "blackExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blackExclusionTags, blackExclusionBiomeTags, "blackExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.creamBiomes, creamBiomeIds, "creamBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.creamTags, creamBiomeTags, "creamTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.creamExclusionBiomes, creamExclusionBiomeIds, "creamExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.creamExclusionTags, creamExclusionBiomeTags, "creamExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.chocolateBiomes, chocolateBiomeIds, "chocolateBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.chocolateTags, chocolateBiomeTags, "chocolateTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.chocolateExclusionBiomes, chocolateExclusionBiomeIds, "chocolateExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.chocolateExclusionTags, chocolateExclusionBiomeTags, "chocolateExclusionTags");
        AdorableHamsterPets.LOGGER.info("Parsed all item and biome tag overrides from config.");
    }

    public static boolean isTamingFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, tamingItems, tamingTags);
    }

    public static boolean isStandardFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, standardFoodItems, standardFoodTags);
    }

    public static boolean isStealableItem(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, stealableItems, stealableTags);
    }

    public static boolean isBuffFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, buffFoodItems, buffFoodTags);
    }

    public static boolean isLureItem(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, lureItems, lureItemTags);
    }

    public static boolean isBedAvoidanceFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, bedAvoidanceFoodItems, bedAvoidanceFoodTags);
    }

    public static boolean isPouchUnlockFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, pouchUnlockItems, pouchUnlockTags);
    }

    public static boolean isRepeatableFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, repeatableFoodItems, repeatableFoodTags);
    }

    public static boolean isAutoHealFood(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, autoHealFoodItems, autoHealFoodTags);
    }

    public static boolean isPouchAllowed(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, pouchAllowedItems, pouchAllowedTags);
    }

    public static boolean isPouchDisallowed(class_1799 stack) {
        return ConfigDataCache.matchesItem(stack, pouchDisallowedItems, pouchDisallowedTags);
    }

    public static boolean isBlueBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, blueBiomeIds, blueBiomeTags, blueExclusionBiomeIds, blueExclusionBiomeTags);
    }

    public static boolean isLavenderBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, lavenderBiomeIds, lavenderBiomeTags, lavenderExclusionBiomeIds, lavenderExclusionBiomeTags);
    }

    public static boolean isWhiteBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, whiteBiomeIds, whiteBiomeTags, whiteExclusionBiomeIds, whiteExclusionBiomeTags);
    }

    public static boolean isGrayBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, grayBiomeIds, grayBiomeTags, grayExclusionBiomeIds, grayExclusionBiomeTags);
    }

    public static boolean isBlackBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, blackBiomeIds, blackBiomeTags, blackExclusionBiomeIds, blackExclusionBiomeTags);
    }

    public static boolean isCreamBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, creamBiomeIds, creamBiomeTags, creamExclusionBiomeIds, creamExclusionBiomeTags);
    }

    public static boolean isChocolateBiome(class_6880<class_1959> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, chocolateBiomeIds, chocolateBiomeTags, chocolateExclusionBiomeIds, chocolateExclusionBiomeTags);
    }

    private static void parseItemList(List<String> configList, Set<class_1792> itemSet, Set<class_6862<class_1792>> tagSet, String listName) {
        for (String entry : configList) {
            if (entry.startsWith("#")) {
                try {
                    class_2960 tagId = class_2960.method_60654((String)entry.substring(1));
                    tagSet.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId));
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item tag identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
                }
                continue;
            }
            try {
                class_2960 itemId = class_2960.method_60654((String)entry);
                class_7923.field_41178.method_17966(itemId).ifPresent(itemSet::add);
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static void parseBiomeIdList(List<String> configList, Set<class_2960> idSet, String listName) {
        for (String entry : configList) {
            try {
                idSet.add(class_2960.method_60654((String)entry));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeTagManager] Invalid biome identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static void parseBiomeTagList(List<String> configList, Set<class_6862<class_1959>> tagSet, String listName) {
        for (String entry : configList) {
            String tagName = entry.startsWith("#") ? entry.substring(1) : entry;
            try {
                tagSet.add((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60654((String)tagName)));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeTagManager] Invalid biome tag in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static boolean matchesItem(class_1799 stack, Set<class_1792> itemSet, Set<class_6862<class_1792>> tagSet) {
        if (stack.method_7960()) {
            return false;
        }
        if (itemSet.contains(stack.method_7909())) {
            return true;
        }
        for (class_6862<class_1792> tag : tagSet) {
            if (!stack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesBiome(class_6880<class_1959> biomeEntry, Set<class_2960> ids, Set<class_6862<class_1959>> tags, Set<class_2960> exclusionIds, Set<class_6862<class_1959>> exclusionTags) {
        class_2960 biomeId = biomeEntry.method_40230().map(class_5321::method_29177).orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (exclusionIds.contains(biomeId)) {
            return false;
        }
        for (class_6862<class_1959> tag : exclusionTags) {
            if (!biomeEntry.method_40220(tag)) continue;
            return false;
        }
        if (ids.contains(biomeId)) {
            return true;
        }
        for (class_6862<class_1959> tag : tags) {
            if (!biomeEntry.method_40220(tag)) continue;
            return true;
        }
        return false;
    }

    private static void clearAllItemSets() {
        tamingItems.clear();
        tamingTags.clear();
        standardFoodItems.clear();
        standardFoodTags.clear();
        stealableItems.clear();
        stealableTags.clear();
        buffFoodItems.clear();
        buffFoodTags.clear();
        lureItems.clear();
        lureItemTags.clear();
        bedAvoidanceFoodItems.clear();
        bedAvoidanceFoodTags.clear();
        pouchUnlockItems.clear();
        pouchUnlockTags.clear();
        repeatableFoodItems.clear();
        repeatableFoodTags.clear();
        autoHealFoodItems.clear();
        autoHealFoodTags.clear();
        pouchAllowedItems.clear();
        pouchAllowedTags.clear();
        pouchDisallowedItems.clear();
        pouchDisallowedTags.clear();
    }

    private static void clearAllBiomeSets() {
        blueBiomeIds.clear();
        blueBiomeTags.clear();
        blueExclusionBiomeIds.clear();
        blueExclusionBiomeTags.clear();
        lavenderBiomeIds.clear();
        lavenderBiomeTags.clear();
        lavenderExclusionBiomeIds.clear();
        lavenderExclusionBiomeTags.clear();
        whiteBiomeIds.clear();
        whiteBiomeTags.clear();
        whiteExclusionBiomeIds.clear();
        whiteExclusionBiomeTags.clear();
        grayBiomeIds.clear();
        grayBiomeTags.clear();
        grayExclusionBiomeIds.clear();
        grayExclusionBiomeTags.clear();
        blackBiomeIds.clear();
        blackBiomeTags.clear();
        blackExclusionBiomeIds.clear();
        blackExclusionBiomeTags.clear();
        creamBiomeIds.clear();
        creamBiomeTags.clear();
        creamExclusionBiomeIds.clear();
        creamExclusionBiomeTags.clear();
        chocolateBiomeIds.clear();
        chocolateBiomeTags.clear();
        chocolateExclusionBiomeIds.clear();
        chocolateExclusionBiomeTags.clear();
    }
}

