/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.Optional;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleBreadcrumbHelper;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;

public class HamsterGoToBedAndSleepGoal
extends class_1352 {
    private final HamsterEntity hamster;
    private final class_1937 world;
    private int pounceTicks;
    @Nullable
    private class_243 pounceStartPos;
    private int startDelay = 0;
    private boolean wasLured = false;
    private int awakeTimer = 0;
    private static final int MIN_START_DELAY_TICKS = 5;
    private static final int MAX_START_DELAY_TICKS = 100;
    private State currentState = State.MOVING_TO_BED;

    public HamsterGoToBedAndSleepGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (!this.hamster.isWanderModeActive() || this.hamster.method_24345() || !((Boolean)Configs.AHP.allowSleepInBed.get()).booleanValue()) {
            return false;
        }
        Optional<class_4208> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty() || this.world.method_27983() != bedPosOptional.get().comp_2207()) {
            return false;
        }
        class_2338 bedPos = bedPosOptional.get().comp_2208();
        class_2680 bedState = this.world.method_8320(bedPos);
        class_2586 be = this.world.method_8321(bedPos);
        if (!(bedState.method_26204() instanceof HamsterBedBlock) || ((Boolean)bedState.method_11654((class_2769)HamsterBedBlock.OCCUPIED)).booleanValue() || !(be instanceof HamsterBedBlockEntity)) {
            return false;
        }
        HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
        if (!bedEntity.isSleepingAllowed()) {
            return false;
        }
        if (this.hamster.getLureToBedTimer() > 0) {
            return true;
        }
        if (bedEntity.isNewlyPlaced()) {
            return true;
        }
        if (this.hamster.getGoToBedCooldown() > 0) {
            return false;
        }
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            if (this.awakeTimer > 0) {
                --this.awakeTimer;
                return false;
            }
            return true;
        }
        boolean isSleepTime = (Boolean)Configs.AHP.sleepDuringDay.get() != false ? this.world.method_8530() : this.world.method_23886();
        return isSleepTime;
    }

    public void method_6269() {
        boolean isLured;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        this.hamster.setOnTheWayToBed(true);
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            int min = (Integer)Configs.AHP.minNapInBedIntervalSeconds.get() * 20;
            int max = (Integer)Configs.AHP.maxNapInBedIntervalSeconds.get() * 20;
            this.awakeTimer = this.hamster.method_59922().method_39332(min, max);
        }
        this.wasLured = isLured = this.hamster.getLureToBedTimer() > 0;
        boolean isNewBed = false;
        boolean shouldBypass = this.hamster.shouldBypassNextSleepDelay();
        Optional<class_4208> bedPosOpt = this.hamster.getLinkedBedPos();
        if (bedPosOpt.isPresent()) {
            class_2586 be;
            class_2338 bedPos = bedPosOpt.get().comp_2208();
            if (this.world.method_27983() == bedPosOpt.get().comp_2207() && (be = this.world.method_8321(bedPos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                isNewBed = bedEntity.isNewlyPlaced();
            }
        }
        if (isLured || isNewBed || shouldBypass || ((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            this.startDelay = 0;
            if (isLured) {
                this.hamster.setLureToBedTimer(0);
            }
            if (shouldBypass) {
                this.hamster.setBypassNextSleepDelay(false);
            }
        } else {
            this.startDelay = this.hamster.method_59922().method_39332(5, 100);
        }
        this.hamster.setGoToBedDelayTicks(this.startDelay);
        this.currentState = State.MOVING_TO_BED;
    }

    public void method_6270() {
        this.hamster.method_5942().method_6340();
        this.currentState = State.MOVING_TO_BED;
        this.pounceStartPos = null;
        this.wasLured = false;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.hamster.setOnTheWayToBed(false);
        this.hamster.setGoToBedDelayTicks(this.startDelay);
    }

    public boolean method_6266() {
        if (this.hamster.method_24345() || !this.hamster.isWanderModeActive()) {
            return false;
        }
        Optional<class_4208> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty() || this.world.method_27983() != bedPosOptional.get().comp_2207()) {
            return false;
        }
        class_2338 bedPos = bedPosOptional.get().comp_2208();
        class_2680 bedState = this.world.method_8320(bedPos);
        return bedState.method_26204() instanceof HamsterBedBlock && (Boolean)bedState.method_11654((class_2769)HamsterBedBlock.OCCUPIED) == false;
    }

    public void method_6268() {
        if (this.startDelay > 0) {
            --this.startDelay;
            this.hamster.setGoToBedDelayTicks(this.startDelay);
            return;
        }
        Optional<class_4208> bedPosOptional = this.hamster.getLinkedBedPos();
        if (bedPosOptional.isEmpty()) {
            this.method_6270();
            return;
        }
        class_2338 bedPos = bedPosOptional.get().comp_2208();
        if (this.currentState == State.MOVING_TO_BED && this.hamster.method_5942().method_6357()) {
            this.hamster.method_5942().method_6337((double)bedPos.method_10263() + 0.5, (double)bedPos.method_10264(), (double)bedPos.method_10260() + 0.5, 0.75);
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                String settleAnimId;
                this.hamster.method_5988().method_19615(class_243.method_24953((class_2382)bedPos));
                if (this.wasLured && !this.world.method_8608() && !this.hamster.method_5942().method_6357()) {
                    ParticleBreadcrumbHelper.spawnBreadcrumbs((class_3218)this.world, this.hamster.method_5942().method_6345());
                }
                if (this.hamster.method_5942().method_6357()) {
                    this.method_6270();
                    return;
                }
                if (!this.hamster.method_24515().method_19771((class_2382)bedPos, 1.2)) break;
                this.hamster.method_5942().method_6340();
                this.currentState = State.POUNCING_INTO_BED;
                this.pounceTicks = 5;
                this.pounceStartPos = this.hamster.method_19538();
                this.hamster.method_18800(this.hamster.method_18798().field_1352, 0.4, this.hamster.method_18798().field_1350);
                this.hamster.field_6007 = true;
                this.hamster.suffocationGracePeriod = 40;
                this.world.method_8396(null, this.hamster.method_24515(), (class_3414)ModSounds.HAMSTER_SWISH.get(), class_3419.field_15254, 0.35f, 1.0f + this.hamster.method_59922().method_43057() * 0.5f);
                int choice = this.hamster.method_59922().method_43048(3);
                this.hamster.method_5841().method_12778(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)(switch (choice) {
                    case 0 -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep1";
                        yield "anim_hamster_sleep_pose1";
                    }
                    case 1 -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep2";
                        yield "anim_hamster_sleep_pose2";
                    }
                    default -> {
                        settleAnimId = "anim_hamster_stand_settle_sleep3";
                        yield "anim_hamster_sleep_pose3";
                    }
                }));
                this.hamster.triggerAnimOnServer("mainController", settleAnimId);
                break;
            }
            case 1: {
                --this.pounceTicks;
                this.hamster.method_5988().method_19615(class_243.method_24953((class_2382)bedPos));
                if (this.pounceStartPos != null && this.pounceTicks >= 0) {
                    double progress = 1.0 - (double)this.pounceTicks / 5.0;
                    double easedProgress = progress * progress;
                    class_243 targetCenter = class_243.method_24953((class_2382)bedPos).method_1031(0.0, 0.1, 0.0);
                    double newX = this.pounceStartPos.field_1352 + easedProgress * (targetCenter.field_1352 - this.pounceStartPos.field_1352);
                    double newZ = this.pounceStartPos.field_1350 + easedProgress * (targetCenter.field_1350 - this.pounceStartPos.field_1350);
                    this.hamster.method_5814(newX, this.hamster.method_23318(), newZ);
                }
                if (this.pounceTicks >= 0) break;
                class_243 targetCenter = class_243.method_24953((class_2382)bedPos).method_1031(0.0, 0.1, 0.0);
                this.hamster.method_5814(targetCenter.field_1352, targetCenter.field_1351, targetCenter.field_1350);
                this.hamster.method_18799(class_243.field_1353);
                this.hamster.field_6007 = true;
                this.hamster.setDozingPhase(HamsterEntity.DozingPhase.DEEP_SLEEP);
                this.hamster.setSleeping(true);
                this.hamster.method_6179(true);
                this.world.method_8652(bedPos, (class_2680)this.world.method_8320(bedPos).method_11657((class_2769)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
                this.hamster.startNapTimer();
                class_2586 be = this.world.method_8321(bedPos);
                if (be instanceof GeoBlockEntity) {
                    GeoBlockEntity geoBlockEntity = (GeoBlockEntity)be;
                    geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_occupied");
                }
                this.hamster.startBedSleepEffects();
                if (!(be instanceof HamsterBedBlockEntity)) break;
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.markAsUsed();
            }
        }
    }

    private static enum State {
        MOVING_TO_BED,
        POUNCING_INTO_BED;

    }
}

