/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5534;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class HamsterStealDiamondGoal
extends class_1352 {
    private final HamsterEntity hamster;
    private final class_1937 world;
    @Nullable
    private class_1542 targetItem;
    @Nullable
    private class_1657 owner;
    @Nullable
    private class_243 pounceStartPos;
    private int bounceSoundDelayTicks;
    private int tauntSettleTicks;
    @Nullable
    private class_243 repositionTarget;
    private int repositionAttempts;
    private static final int LUNGE_DURATION_TICKS = 5;
    private int lungeTicks;
    private State currentState = State.SCANNING;
    private int stealDurationTimer;

    public HamsterStealDiamondGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        float chance;
        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Evaluating canStart...", (Object)this.hamster.method_5628());
        if (this.hamster.isStealingDiamond()) {
            if (this.hamster.method_24345()) {
                return false;
            }
            if (!(this.hamster.method_35057() instanceof class_1657)) {
                return false;
            }
            this.owner = (class_1657)this.hamster.method_35057();
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart SUCCEEDED: Resuming existing steal.", (Object)this.hamster.method_5628());
            return true;
        }
        if (!Configs.AHP.enableDiamondStealing) {
            return false;
        }
        if (this.hamster.isStealingDiamond()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster is already in a stealing state.", (Object)this.hamster.method_5628());
            return false;
        }
        if (this.hamster.method_24345()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster is sitting.", (Object)this.hamster.method_5628());
            return false;
        }
        long currentTime = this.world.method_8510();
        if (this.hamster.stealCooldownEndTick > currentTime) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Steal cooldown is active for another {} ticks.", (Object)this.hamster.method_5628(), (Object)(this.hamster.stealCooldownEndTick - currentTime));
            return false;
        }
        float randomVal = this.hamster.method_59922().method_43057();
        if (randomVal > (chance = ((Float)Configs.AHP.diamondPounceChance.get()).floatValue())) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Pounce chance check failed (Rolled {} > Chance {})", new Object[]{this.hamster.method_5628(), String.format("%.2f", Float.valueOf(randomVal)), String.format("%.2f", Float.valueOf(chance))});
            return false;
        }
        class_1309 class_13092 = this.hamster.method_35057();
        if (!(class_13092 instanceof class_1657)) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster has no valid owner.", (Object)this.hamster.method_5628());
            return false;
        }
        class_1657 playerOwner = (class_1657)class_13092;
        this.owner = playerOwner;
        List<class_1792> stealableItems = Configs.AHP.stealableItems.stream().map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).filter(item -> item != class_1802.field_8162).toList();
        if (stealableItems.isEmpty()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: No valid stealable items configured or parsed.", (Object)this.hamster.method_5628());
            return false;
        }
        List nearbyItems = this.world.method_8390(class_1542.class, this.hamster.method_5829().method_1014(10.0), itemEntity -> ConfigDataCache.isStealableItem(itemEntity.method_6983()) && itemEntity.method_24828());
        Optional<class_1542> closestItem = nearbyItems.stream().filter(item -> this.hamster.method_5942().method_6349((class_1297)item, 0) != null).min((item1, item2) -> Float.compare(item1.method_5739((class_1297)this.hamster), item2.method_5739((class_1297)this.hamster)));
        if (closestItem.isPresent()) {
            this.targetItem = closestItem.get();
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart SUCCEEDED. Target item: {} at {}. Owner: {}", new Object[]{this.hamster.method_5628(), this.targetItem.method_6983().method_7909(), this.targetItem.method_24515(), this.owner.method_5477().getString()});
            return true;
        }
        return false;
    }

    public boolean method_6266() {
        if (this.hamster.method_24345()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Hamster is sitting.", (Object)this.hamster.method_5628());
            return false;
        }
        if (this.owner == null || !this.owner.method_5805()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Owner is null or not alive.", (Object)this.hamster.method_5628());
            return false;
        }
        if (this.stealDurationTimer <= 0) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Steal duration timer expired.", (Object)this.hamster.method_5628());
            return false;
        }
        if (this.currentState == State.FLEEING || this.currentState == State.TAUNTING) {
            if (!this.hamster.isStealingDiamond()) {
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Player retrieved diamond (isStealingDiamond is false).", (Object)this.hamster.method_5628());
                return false;
            }
        } else if (!(this.currentState != State.MOVING_TO_DIAMOND && this.currentState != State.POUNCING || this.targetItem != null && this.targetItem.method_5805())) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Target item disappeared before pounce.", (Object)this.hamster.method_5628());
            return false;
        }
        return true;
    }

    public void method_6269() {
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        if (this.hamster.isStealingDiamond()) {
            this.stealDurationTimer = this.hamster.getStealDurationTimer();
            this.targetItem = null;
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Resuming steal. Duration left: {} ticks.", (Object)this.hamster.method_5628(), (Object)this.stealDurationTimer);
            this.currentState = this.hamster.method_5739((class_1297)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue() ? State.FLEEING : State.TAUNTING;
        } else {
            this.currentState = State.MOVING_TO_DIAMOND;
            this.hamster.method_5942().method_6335((class_1297)this.targetItem, 0.75);
            this.stealDurationTimer = this.hamster.method_59922().method_39332((Integer)Configs.AHP.minStealDurationSeconds.get() * 20, (Integer)Configs.AHP.maxStealDurationSeconds.get() * 20);
            this.hamster.setStealDurationTimer(this.stealDurationTimer);
            this.repositionTarget = null;
            this.repositionAttempts = 0;
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Goal started fresh. State: MOVING_TO_DIAMOND. Duration: {} ticks.", (Object)this.hamster.method_5628(), (Object)this.stealDurationTimer);
        }
    }

    public void method_6270() {
        class_1799 stolenStack;
        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Goal stopped. Final state was: {}.", (Object)this.hamster.method_5628(), (Object)this.currentState);
        this.hamster.stealCooldownEndTick = this.world.method_8510() + (long)((Integer)Configs.AHP.stealCooldownTicks.get()).intValue();
        if (this.hamster.isStealingDiamond() && this.stealDurationTimer <= 0 && !(stolenStack = this.hamster.getStolenItemStack()).method_7960()) {
            this.world.method_8649((class_1297)new class_1542(this.world, this.hamster.method_23317(), this.hamster.method_23318(), this.hamster.method_23321(), stolenStack.method_7972()));
            this.hamster.method_5783(ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.hamster.method_59922()), 1.0f, 1.0f);
            class_3414 pounceSound = ModSounds.getDynamicItemSound(stolenStack);
            float volume = pounceSound == class_3417.field_20614 ? 0.35f : 1.0f;
            this.world.method_8396(null, this.hamster.method_24515(), pounceSound, class_3419.field_15254, volume, 1.7f);
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Dropped stolen item {} because timer expired.", (Object)this.hamster.method_5628(), (Object)stolenStack.method_7909());
        }
        this.hamster.setStolenItemStack(class_1799.field_8037);
        this.hamster.setStealDurationTimer(0);
        this.hamster.setTaunting(false);
        this.hamster.setStealingDiamond(false);
        this.hamster.method_5942().method_6340();
        this.targetItem = null;
        this.owner = null;
        this.currentState = State.SCANNING;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void method_6268() {
        if (this.stealDurationTimer > 0) {
            --this.stealDurationTimer;
            this.hamster.setStealDurationTimer(this.stealDurationTimer);
        }
        if (this.owner == null) {
            return;
        }
        if (this.bounceSoundDelayTicks > 0) {
            --this.bounceSoundDelayTicks;
            if (this.bounceSoundDelayTicks == 0) {
                this.hamster.method_5783((class_3414)ModSounds.HAMSTER_BOUNCE.get(), 0.6f, this.hamster.method_6017() * 1.2f);
            }
        }
        --this.stealDurationTimer;
        this.hamster.setStealDurationTimer(this.stealDurationTimer);
        switch (this.currentState.ordinal()) {
            case 1: {
                if (this.targetItem == null) {
                    return;
                }
                this.hamster.method_5988().method_6226((class_1297)this.targetItem, 25.0f, 25.0f);
                if (this.hamster.method_5942().method_6357()) {
                    this.currentState = State.REPOSITIONING;
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Navigator is idle, transitioning to REPOSITIONING.", (Object)this.hamster.method_5628());
                    return;
                }
                if (!((double)this.hamster.method_5739((class_1297)this.targetItem) < 1.5)) break;
                this.currentState = State.POUNCING;
                this.lungeTicks = 5;
                this.pounceStartPos = this.hamster.method_19538();
                this.hamster.method_5942().method_6340();
                this.hamster.triggerAnimOnServer("mainController", "anim_hamster_diamond_pounce");
                this.bounceSoundDelayTicks = 5;
                class_3414 celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.hamster.method_59922());
                if (celebrationSound != null) {
                    this.hamster.method_5783(celebrationSound, 0.7f, this.hamster.method_6017());
                }
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed to POUNCING.", (Object)this.hamster.method_5628());
                break;
            }
            case 2: {
                if (this.targetItem == null) {
                    return;
                }
                if (this.repositionAttempts >= 3) {
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Exceeded max reposition attempts. Stopping goal.", (Object)this.hamster.method_5628());
                    this.stealDurationTimer = 0;
                    return;
                }
                if (this.repositionTarget == null) {
                    ++this.repositionAttempts;
                    this.repositionTarget = class_5534.method_31528((class_1314)this.hamster, (int)2, (int)3, (class_243)class_243.method_24953((class_2382)this.targetItem.method_24515()));
                    if (this.repositionTarget != null) {
                        this.hamster.method_5942().method_6337(this.repositionTarget.field_1352, this.repositionTarget.field_1351, this.repositionTarget.field_1350, 0.75);
                        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Attempt #{}: Found repositioning target at {}. Moving now.", new Object[]{this.hamster.method_5628(), this.repositionAttempts, this.repositionTarget});
                    } else {
                        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Could not find a repositioning target. Stopping goal.", (Object)this.hamster.method_5628());
                        this.stealDurationTimer = 0;
                        return;
                    }
                }
                if (!this.hamster.method_5942().method_6357()) break;
                this.repositionTarget = null;
                this.currentState = State.MOVING_TO_DIAMOND;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Repositioning move complete. Transitioning back to MOVING_TO_DIAMOND.", (Object)this.hamster.method_5628());
                break;
            }
            case 3: {
                if (this.targetItem == null) {
                    return;
                }
                --this.lungeTicks;
                if (this.pounceStartPos != null && this.lungeTicks >= 0) {
                    double progress = (double)(5 - this.lungeTicks) / 5.0;
                    double easedProgress = progress * progress;
                    double newX = this.pounceStartPos.field_1352 + easedProgress * (this.targetItem.method_23317() - this.pounceStartPos.field_1352);
                    double newZ = this.pounceStartPos.field_1350 + easedProgress * (this.targetItem.method_23321() - this.pounceStartPos.field_1350);
                    this.hamster.method_5814(newX, this.hamster.method_23318(), newZ);
                }
                if (this.lungeTicks >= 0) break;
                class_1799 stackToSteal = this.targetItem.method_6983().method_7972();
                if (stackToSteal.method_7960()) {
                    this.stealDurationTimer = 0;
                    return;
                }
                this.hamster.setStolenItemStack(stackToSteal);
                this.targetItem.method_31472();
                this.hamster.setStealingDiamond(true);
                class_3414 pounceSound = ModSounds.getDynamicItemSound(stackToSteal);
                float volume = pounceSound == class_3417.field_20614 ? 0.35f : 1.0f;
                this.world.method_8396(null, this.hamster.method_24515(), pounceSound, class_3419.field_15254, volume, 1.7f);
                if (!this.world.field_9236) {
                    ((class_3218)this.world).method_14199((class_2394)class_2398.field_11207, this.hamster.method_23317(), this.hamster.method_23318() + 0.5, this.hamster.method_23321(), 5, 0.1, 0.1, 0.1, 0.05);
                    ((class_3218)this.world).method_14199((class_2394)new class_2392(class_2398.field_11218, stackToSteal), this.hamster.method_23317(), this.hamster.method_23318() + 0.5, this.hamster.method_23321(), 18, 0.2, 0.2, 0.2, 0.1);
                }
                this.currentState = State.FLEEING;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Pounce finished. Item stolen. State changed to FLEEING.", (Object)this.hamster.method_5628());
                break;
            }
            case 4: {
                this.hamster.setTaunting(false);
                if (this.hamster.method_5739((class_1297)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue()) {
                    class_243 fleePos = class_5534.method_31534((class_1314)this.hamster, (int)((Integer)Configs.AHP.maxFleeDistance.get()), (int)7, (class_243)this.owner.method_19538());
                    if (fleePos == null) break;
                    this.hamster.method_5942().method_6337(fleePos.field_1352, fleePos.field_1351, fleePos.field_1350, 1.5);
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Fleeing: Owner too close, found new flee point at {}.", (Object)this.hamster.method_5628(), (Object)fleePos);
                    break;
                }
                this.currentState = State.TAUNTING;
                this.hamster.method_5942().method_6340();
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed to TAUNTING.", (Object)this.hamster.method_5628());
                break;
            }
            case 5: {
                this.hamster.method_5988().method_6226((class_1297)this.owner, 25.0f, 25.0f);
                if (!this.hamster.isTaunting() && this.tauntSettleTicks == 0) {
                    this.tauntSettleTicks = 5;
                }
                if (this.tauntSettleTicks > 0) {
                    --this.tauntSettleTicks;
                }
                if (this.hamster.method_5942().method_6357() && this.tauntSettleTicks == 0) {
                    this.hamster.setTaunting(true);
                }
                if (!(this.hamster.method_5739((class_1297)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue())) break;
                this.currentState = State.FLEEING;
                this.hamster.setTaunting(false);
                this.tauntSettleTicks = 0;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed back to FLEEING.", (Object)this.hamster.method_5628());
            }
        }
    }

    private static enum State {
        SCANNING,
        MOVING_TO_DIAMOND,
        REPOSITIONING,
        POUNCING,
        FLEEING,
        TAUNTING;

    }
}

