/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_4208;
import net.minecraft.class_5534;
import org.jetbrains.annotations.Nullable;

public class HamsterWanderAroundFarGoal
extends class_1394 {
    private final HamsterEntity hamster;
    private static final double BUFFED_WANDER_SPEED = 0.9;

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed) {
        super((class_1314)hamster, speed);
        this.hamster = hamster;
        this.method_6303(110);
    }

    public HamsterWanderAroundFarGoal(HamsterEntity hamster, double speed, float probability) {
        super((class_1314)hamster, speed, probability);
        this.hamster = hamster;
        this.method_6303(110);
    }

    public boolean method_6264() {
        if (this.hamster.method_24345() || this.hamster.method_6113() || this.hamster.isKnockedOut() || this.hamster.isSulking() || this.hamster.isCelebratingDiamond() || this.hamster.isCelebratingChase()) {
            return false;
        }
        if (this.hamster.hasGreenBeanBuff()) {
            if (this.field_6566.method_59922().method_43048(3) != 0) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - On cooldown.", (Object)this.hamster.method_5628());
                return false;
            }
            class_243 target = this.method_6302();
            if (target == null) {
                AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): FAILED - No valid target found.", (Object)this.hamster.method_5628());
                return false;
            }
            this.field_6563 = target.field_1352;
            this.field_6562 = target.field_1351;
            this.field_6561 = target.field_1350;
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Zoomies): SUCCEEDED. Target: ({}, {}, {})", new Object[]{this.hamster.method_5628(), String.format("%.2f", target.field_1352), String.format("%.2f", target.field_1351), String.format("%.2f", target.field_1350)});
            return true;
        }
        boolean canStartNormal = super.method_6264();
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] canStart (Normal): Result: {}", (Object)this.hamster.method_5628(), (Object)canStartNormal);
        return canStartNormal;
    }

    public boolean method_6266() {
        if (this.hamster.hasGreenBeanBuff()) {
            return !this.hamster.method_24345() && !this.hamster.method_6113() && !this.hamster.isKnockedOut() && !this.field_6566.method_5942().method_6357();
        }
        return super.method_6266();
    }

    public void method_6268() {
        if (this.hamster.hasGreenBeanBuff() && this.field_6566.method_5942().method_6357()) {
            AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] tick (Zoomies): Navigation is idle. Finding new target.", (Object)this.hamster.method_5628());
            class_243 newTarget = this.method_6302();
            if (newTarget != null) {
                this.field_6566.method_5942().method_6337(newTarget.field_1352, newTarget.field_1351, newTarget.field_1350, 0.9);
            }
        }
    }

    public void method_6269() {
        double currentSpeed = this.hamster.hasGreenBeanBuff() ? 0.9 : this.field_6567;
        this.field_6566.method_5942().method_6337(this.field_6563, this.field_6562, this.field_6561, currentSpeed);
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.hamster.hasGreenBeanBuff() ? " (Zoomies)" : ""));
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] start: Goal has started. IsBuffed: {}", (Object)this.hamster.method_5628(), (Object)this.hamster.hasGreenBeanBuff());
    }

    @Nullable
    protected class_243 method_6302() {
        Optional<class_4208> bedPosOptional;
        if (this.hamster.hasGreenBeanBuff()) {
            return this.getPreciseZoomiesTarget().map(class_243::method_24953).orElse(null);
        }
        if (this.hamster.isWanderModeActive() && (bedPosOptional = this.hamster.getLinkedBedPos()).isPresent()) {
            class_4208 bedGlobalPos = bedPosOptional.get();
            if (this.hamster.method_37908().method_27983() == bedGlobalPos.comp_2207()) {
                class_2338 bedPos = bedGlobalPos.comp_2208();
                class_2586 be = this.hamster.method_37908().method_8321(bedPos);
                if (be instanceof HamsterBedBlockEntity) {
                    int radius;
                    HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                    WanderDistance distance = bedEntity.getWanderDistance();
                    switch (distance) {
                        case NEAR: {
                            int n = (Integer)Configs.AHP.wanderDistanceNear.get();
                            break;
                        }
                        case FAR: {
                            int n = (Integer)Configs.AHP.wanderDistanceFar.get();
                            break;
                        }
                        default: {
                            int n = radius = ((Integer)Configs.AHP.wanderDistanceMedium.get()).intValue();
                        }
                    }
                    if (this.hamster.method_24515().method_10262((class_2382)bedPos) > (double)(radius * radius)) {
                        class_243 directionToBed = class_243.method_24953((class_2382)bedPos).method_1020(this.hamster.method_19538());
                        return class_5534.method_31528((class_1314)this.field_6566, (int)7, (int)7, (class_243)directionToBed);
                    }
                    for (int i = 0; i < 10; ++i) {
                        class_2338 validatedPos;
                        int dz;
                        int dx = this.hamster.method_59922().method_43048(2 * radius + 1) - radius;
                        class_2338 potentialTarget = bedPos.method_10069(dx, 0, dz = this.hamster.method_59922().method_43048(2 * radius + 1) - radius);
                        if (!(bedPos.method_10262((class_2382)potentialTarget) <= (double)(radius * radius)) || (validatedPos = class_5534.method_31533((class_1314)this.field_6566, (class_2338)potentialTarget)) == null) continue;
                        return class_243.method_24955((class_2382)validatedPos);
                    }
                    return null;
                }
            }
        }
        return super.method_6302();
    }

    private Optional<class_2338> getPreciseZoomiesTarget() {
        class_1309 class_13092 = this.hamster.method_35057();
        if (!(class_13092 instanceof class_1657)) {
            return Optional.empty();
        }
        class_1657 owner = (class_1657)class_13092;
        double lastAngle = this.hamster.getLastZoomiesAngle();
        boolean isClockwise = this.hamster.getZoomiesIsClockwise();
        double angleStep = Math.toRadians(this.hamster.method_59922().method_39332(40, 70));
        double newAngle = isClockwise ? lastAngle + angleStep : lastAngle - angleStep;
        this.hamster.setLastZoomiesAngle(newAngle);
        int radiusModifier = this.hamster.getZoomiesRadiusModifier();
        double radius = this.hamster.method_59922().method_39332(3 + radiusModifier, 5 + radiusModifier);
        double targetX = owner.method_23317() + radius * Math.cos(newAngle);
        double targetZ = owner.method_23321() + radius * Math.sin(newAngle);
        class_2338 idealPos = new class_2338((int)targetX, (int)this.hamster.method_23318(), (int)targetZ);
        Optional<class_2338> finalTargetPos = this.hamster.findSafeSpawnPosition(idealPos, this.hamster.method_37908(), 2);
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] getPreciseZoomiesTarget:\n  - IsClockwise: {}\n  - LastAngle(rad): {}\n  - AngleStep(rad): {}\n  - NewAngle(rad): {}\n  - Radius: {}\n  - IdealPos: {}\n  - FinalTarget: {}", new Object[]{this.hamster.method_5628(), isClockwise, String.format("%.2f", lastAngle), String.format("%.2f", angleStep), String.format("%.2f", newAngle), String.format("%.2f", radius), idealPos, finalTargetPos.map(class_2382::toString).orElse("null")});
        return this.hamster.findSafeSpawnPosition(idealPos, this.hamster.method_37908(), 2);
    }

    public void method_6270() {
        super.method_6270();
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        AdorableHamsterPets.LOGGER.trace("[WanderGoal-{}] stop: Goal has stopped.", (Object)this.hamster.method_5628());
    }
}

