/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import java.util.EnumMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderHamsterState;
import net.dawson.adorablehamsterpets.entity.client.renderer.ShoulderHamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_8685;
import org.joml.Matrix4f;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;

public class HamsterShoulderFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private static final float HAMSTER_SHOULDER_SCALE = 0.8f;
    private final Map<ShoulderLocation, HamsterEntity> dummyHamsters = new EnumMap<ShoulderLocation, HamsterEntity>(ShoulderLocation.class);
    private final Map<ShoulderLocation, ShoulderHamsterRenderer> hamsterRenderers = new EnumMap<ShoulderLocation, ShoulderHamsterRenderer>(ShoulderLocation.class);

    public HamsterShoulderFeatureRenderer(class_3883<class_742, class_591<class_742>> context) {
        super(context);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ClientShoulderHamsterData clientData;
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        if (!playerAccessor.hasAnyShoulderHamster()) {
            return;
        }
        if (this.dummyHamsters.isEmpty()) {
            this.initializeDummies(player.method_37908());
        }
        if ((clientData = playerAccessor.adorablehamsterpets$getClientShoulderData()) == null) {
            return;
        }
        for (ShoulderLocation location : ShoulderLocation.values()) {
            class_2487 shoulderNbt = playerAccessor.getShoulderHamster(location);
            if (shoulderNbt.method_33133()) continue;
            HamsterShoulderData.fromNbt(shoulderNbt).ifPresent(shoulderData -> this.renderShoulderHamster(matrices, vertexConsumers, light, player, (HamsterShoulderData)shoulderData, tickDelta, clientData, location));
        }
    }

    private void applyShoulderData(HamsterEntity dummyHamster, HamsterShoulderData data, class_1657 owner) {
        dummyHamster.setShoulderPet(true);
        dummyHamster.setVariant(data.variantId());
        dummyHamster.setLeftCheekFull((data.hamsterFlags() & 0x40) != 0);
        dummyHamster.setRightCheekFull((data.hamsterFlags() & 0x80) != 0);
        dummyHamster.method_5841().method_12778(HamsterEntity.PINK_PETAL_TYPE, (Object)data.pinkPetalType());
        dummyHamster.method_5841().method_12778(HamsterEntity.ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
        dummyHamster.method_5614(data.breedingAge());
        dummyHamster.method_6174(owner.method_5667());
        dummyHamster.method_6173(true, false);
    }

    private void renderShoulderHamster(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, HamsterShoulderData shoulderData, float tickDelta, ClientShoulderHamsterData clientData, ShoulderLocation location) {
        float renderScaleY;
        AnimatableManager manager;
        HamsterEntity dummyHamster = this.dummyHamsters.get((Object)location);
        ShoulderHamsterRenderer hamsterRenderer = this.hamsterRenderers.get((Object)location);
        if (dummyHamster == null || hamsterRenderer == null) {
            return;
        }
        this.updateDummyState(dummyHamster, shoulderData, clientData, location, (class_1657)player);
        AnimatableInstanceCache cache = dummyHamster.getAnimatableInstanceCache();
        if (cache != null && (manager = cache.getManagerForId((long)dummyHamster.method_5628())) != null) {
            manager.updatedAt(0.0);
        }
        float renderOffsetY = clientData.getRenderOffsetY(location, tickDelta);
        dummyHamster.dynamicScaleY = renderScaleY = clientData.getRenderScaleY(location, tickDelta);
        matrices.method_22903();
        class_1799 chestStack = player.method_31548().method_7372(2);
        boolean isWearingChestplate = !chestStack.method_7960() && !chestStack.method_31574(class_1802.field_8833);
        boolean isSlim = player.method_52814().comp_1629() == class_8685.class_7920.field_41122;
        switch (location) {
            case RIGHT_SHOULDER: {
                float yOffset;
                float xOffset;
                ((class_591)this.method_17165()).field_3401.method_22703(matrices);
                if (isWearingChestplate) {
                    xOffset = -0.18f;
                    yOffset = -0.18f;
                } else {
                    xOffset = isSlim ? -0.08f : -0.12f;
                    yOffset = -0.12f;
                }
                matrices.method_46416(xOffset, yOffset, -0.016f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(15.0f));
                break;
            }
            case LEFT_SHOULDER: {
                float yOffset;
                float xOffset;
                ((class_591)this.method_17165()).field_27433.method_22703(matrices);
                if (isWearingChestplate) {
                    xOffset = 0.18f;
                    yOffset = -0.18f;
                } else {
                    xOffset = isSlim ? 0.08f : 0.12f;
                    yOffset = -0.12f;
                }
                matrices.method_46416(xOffset, yOffset, -0.016f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-15.0f));
                break;
            }
            case HEAD: {
                ((class_591)this.method_17165()).field_3398.method_22703(matrices);
                matrices.method_46416(0.0f, -0.5f, -0.05f);
            }
        }
        matrices.method_46416(0.0f, -renderOffsetY, 0.0f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22905(0.8f, 0.8f, 0.8f);
        float renderYaw = 180.0f - player.method_43078();
        hamsterRenderer.render(dummyHamster, renderYaw, tickDelta, matrices, vertexConsumers, light);
        matrices.method_22909();
    }

    private double getAnchorBoneWorldY(class_4587 matrices, class_630 anchorBone) {
        class_4587 tempMatrices = new class_4587();
        tempMatrices.method_34425(matrices.method_23760().method_23761());
        anchorBone.method_22703(tempMatrices);
        Matrix4f finalMatrix = tempMatrices.method_23760().method_23761();
        return finalMatrix.m31();
    }

    private void updateDummyState(HamsterEntity dummyHamster, HamsterShoulderData nbtData, ClientShoulderHamsterData clientData, ShoulderLocation location, class_1657 owner) {
        this.applyShoulderData(dummyHamster, nbtData, owner);
        dummyHamster.field_6012 = clientData.getAnimationAge(location);
        ShoulderHamsterState state = clientData.getHamsterState(location);
        if (state != null) {
            ShoulderAnimationState currentState = state.getCurrentState();
            dummyHamster.method_5841().method_12778(HamsterEntity.SHOULDER_ANIMATION_STATE, (Object)currentState.ordinal());
            dummyHamster.setSitting(currentState == ShoulderAnimationState.SITTING, true);
        }
        dummyHamster.shoulderLocation = location;
    }

    private void initializeDummies(class_1937 world) {
        if (world == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_5617.class_5618 context = new class_5617.class_5618(client.method_1561(), client.method_1480(), client.method_1541(), client.method_1561().method_43336(), client.method_1478(), client.method_31974(), client.field_1772);
        for (ShoulderLocation location : ShoulderLocation.values()) {
            HamsterEntity dummy = new HamsterEntity((class_1299<? extends class_1321>)((class_1299)ModEntities.HAMSTER.get()), world);
            dummy.method_5875(true);
            dummy.method_5803(true);
            this.dummyHamsters.put(location, dummy);
            this.hamsterRenderers.put(location, new ShoulderHamsterRenderer(context));
        }
    }
}

